/*
**	caller
**
**	Interacts with target system to setup a virtual circuit.
**
**	Bob Kummerfeld.
*/

static char	sccsid[]	= "@(#)caller.c	1.13 85/08/01";

#include	"global.h"
#include	"debug.h"

#include	"caller.h"

#include	<setjmp.h>
#include	<signal.h>



char *		Name;
char		input[LINESIZE+1];
char *		delim		= ":\n";
int		Traceflag;
jmp_buf		FlushJmp;

struct patlist *current;
struct patlist *cp;

extern unsigned	alarm();



main(argc, argv)
	int	argc;
	char	*argv[];
{
	if ( (Name = strrchr(*argv, '/')) != NULLSTR )
		Name++;
	else
		Name = *argv;

	init(argc, argv);

	for (;;)
	{
		if (cp->pattern == NULLSTR)
			reset();

		if (match(input, cp->pattern))
			(*cp->func)();
		else
			next();
	}
}



match(s, pat)
	char	*s;
	char	*pat;
{
	char	*cpat;
	int	result;

	if ((cpat = regcmp(pat, 0)) == NULLSTR)
	{
		out("fail cannot compile pattern - \""); out(pat); outend("\"");
		exit(1);
	}

	result = regex(cpat, s);
	free(cpat);
	return result;
}



getinput()
{
	register int	i;

	for (i = 0; i < LINESIZE; )
	{
		char	c;

		if (read(0, &c, 1) <= 0)
		{
			strcpy(input, EOFSTR);
			return;
		}

		if ( (c &= 0x7f) == 0 )
			continue;

		input[i++] = c;

		if (strchr(delim, c))
			break;
	}

	input[i] = '\0';
}



/*
**	output a string
**
*/

out(s)
	char	*s;
{
	write(1, s, strlen(s));
}



outend(s)
	char	*s;
{
	write(1, s, strlen(s)+1);
}



/*
**	Combine above for NULLSTR terminated list.
*/

void
Command(s1, s2, s3, s4, s5, s6, s7)
	char *		s1;
	char *		s2;
	char *		s3;
	char *		s4;
	char *		s5;
	char *		s6;
	char *		s7;
{
	char **		ap;
	register char *	cp;
	register int	n;

	if ( n = Traceflag )
	{
		Traceflag = 0;
		Command("trace ", s1, s2, s3, s4, s5, s6, s7, NULLSTR);
		Traceflag = n;
	}

	for ( ap = &s1 ; (cp = ARGS_OFF_STACK(ap)) != NULLSTR ; )
	{
		n = strlen(cp);

		if ( *ap == NULLSTR )
			n++;

		write(1, cp, n);
	}
}



state(p)
	struct	patlist	*p;
{
	current = p;
	cp = current;
}



next()
{
	cp++;	/* move to next pattern */
}



reset()
{
	cp = current;
	getinput();
}



/*
**	Extract arguments from passed file,
**	and pass them back via the passed function
**	to look like program invoked arguments.
*/

bool
readargs(file, funcp)
	char *		file;
	int		(*funcp)();
{
	register char *	ap;
	VarArgs		va;

	if ( (ap = ReadFile(file)) == NULLSTR )
		return false;

	FIRSTARG(&va) = Name;

	if ( SplitArg(&va, ap) > MAXVARARGS )
		Error("Too many arguments in \"%s\"", file);

	(*funcp)(NARGS(&va), &ARG(&va, 0));
	free(ap);

	return true;
}



/*
**	Clean up after Error()
*/

void
finish(err)
	int	err;
{
	char	numb[12];

	sprintf(numb, "%d", err);
	out("fail error type "); outend(numb);

	exit(1);
}



flushcatch(sig)
	int	sig;
{
	(void)signal(sig, SIG_IGN);
	longjmp(FlushJmp, 1);
}



flushinput()
{
	char	c;

	if ( setjmp(FlushJmp) )
		return;
	
	(void)signal(SIGALRM, flushcatch);
	(void)alarm(2);

	while ( read(0, &c, 1) == 1 );

	(void)alarm(0);
}



char *
expandstr(str)
	register char *	str;
{
	register char *	res;
	register char *	p;
	static char	expanders[] = "befnrst\\";
	static char	expandees[] = "\b\\\f\n\r \t\\";

	res = (char *)malloc(strlen(str) + 1);

	for (p = res; *str; p++, str++)
	{
		if (*str == '\\' && str[1] != '\0')
		{
			register char *q;

			q = strchr(expanders, *++str);
			if (q == NULLSTR)
			{
				*p++ = '\\';
				*p = *str;
			}
			else
				*p = expandees[q - expanders];
		}
		else
			*p = *str;
	}
	*p = '\0';

	return (res);
}
