#
#	summarise acsnet log	- Bruce Ellis, July 1984.
#
$1 == "Options"		{
				x = $2;

				while (x != "")
				{
					y = substr(x, 1, 1);

					if (y == "a")
						all = 1;
					else if (y == "c")
						cpu = 1;
					else if (y == "d")
						diag = 1;
					else if (y == "g")
						garbage = 1;
					else if (y == "e")
						errors = 1;
					else if (y == "r")
						report = 1;
					else if (y != "-")
					{
						print "usage: logsum [-acdegr] file ...";
						croaked = 1;
						exit;
					}

					x = substr(x, 2, length(x) - 1);					}

				next;
			}

/STARTED/		{
				if (start_date != "")
				{
					sh = substr(start_time, 1, 2) + 0;
					sm = substr(start_time, 4, 2) + 0;
					ss = substr(start_time, 7, 2) + 0;
					fh = substr(finish_time, 1, 2) + 0;
					fm = substr(finish_time, 4, 2) + 0;
					fs = substr(finish_time, 7, 2) + 0;

					if (fh < sh)
						fh += 24;

					real = fs - ss + 60 * (fm - sm + 60 * (fh - sh));

					if (all)
						printf "%s  %2d:%02d:%02d %4d %8d  %s\n", start_date, real / (60*60), (real / 60) % 60, real % 60, messages, bytes, finish_cause;

					tot_real += real;
				}

				start_date = sprintf("%s %2s %s", $1, $2, $3);
				start_time = $3;
				finish_time = "";
				next;
			}

/FINISHED|TERMIN|HANGUP|ERROR|TIMEOUT|SLOW/	{
				finish_time = $3;
				split($0, gumph, ")");
				finish_cause = gumph[2];
				next;
			}

/bytes in.*message/	{
				bytes = $1;
				messages = $4;
				tot_bytes += $1;
				tot_messages += $4;
				next;
			}

/^Protocol|^Usages|^Total|^average|^overall/	{
				next;
			}

/NN.*: report --/	{
				if (report) {
					split($0, gumph, "-");
					print "Report: " $1 " " $2 " " $3 " --" gumph[3] gumph[4];
				}
				next;
			}

/NN.*: error --/	{
				if (errors) {
					split($0, gumph, "-");
					print "Error: " $1 " " $2 " " $3 " --" gumph[3] gumph[4];
				}
				next;
			}

/^[ 	]+[0-9]/	{
				s = $2;

				if (NF > 2)
					s = s " " $3;

				if (NF > 3)
					s = s " " $4;

				if (NF > 4)
					s = s " " $5;

				packet_mesg[s] += $1;
				next;
			}

/^Cpu/			{
				sys += substr($4, 1, length($4) - 1);
				user += substr($6, 1, length($6) - 1);
				csys += substr($9, 1, length($9) - 1);
				cuser += substr($12, 1, length($12) - 1);
				next;
			}

/^Daemon/		{
				sys += $3;
				user += $2;
				next;
			}

/^Child/		{
				csys += $3;
				cuser += $2;
				next;
			}

/./			{
				if (garbage)
					print "'" $0 "' garbage";

				next;
			}

END			{
				if (start_date != "" && finish_time != "")
				{
					sh = substr(start_time, 1, 2) + 0;
					sm = substr(start_time, 4, 2) + 0;
					ss = substr(start_time, 7, 2) + 0;
					fh = substr(finish_time, 1, 2) + 0;
					fm = substr(finish_time, 4, 2) + 0;
					fs = substr(finish_time, 7, 2) + 0;

					if (fh < sh)
						fh += 24;

					real = fs - ss + 60 * (fm - sm + 60 * (fh - sh));

					if (all)
						printf "%s  %2d:%02d:%02d %4d %8d  %s\n", start_date, real / (60*60), (real / 60) % 60, real % 60, messages, bytes, finish_cause;

					tot_real += real;
				}

				if (!croaked)
				{
					if (all)
						printf "%-17s", "Total";

					printf "%2d:%02d:%02d %4d %8d", tot_real / (60*60), (tot_real / 60) % 60, tot_real % 60, tot_messages, tot_bytes;

					if (cpu)
					{
						if (all)
							printf "\n";
						else
							printf " ";

						printf "(%du %ds + %dcu %dcs = %d)", user, sys, cuser, csys, user + sys + cuser + csys;
					}

					printf "\n";

					if (diag)
					{
						for (s in packet_mesg)
							printf "%9d %s\n", packet_mesg[s], s;
					}
				}
			}
