#-h- field.r         4807 local 08/09/81 12:00:00
#-h- defns             89 local 08/09/81 12:00:00
 # include ratdef
define(MAXFIELDS,10)
define(ARGFLAG,-1)       # or define(ARGFLAG,255)
#-t- defns             89 local 08/09/81 12:00:00
#-h- field           2056 local 08/09/81 12:00:00
# field - rearrange fields in a file
 DRIVER
   character buf(MAXLINE), tabc
   integer from(MAXFIELDS), to(MAXFIELDS)
   character ofmt(MAXLINE)
   integer i, j, k, n, nflds, len, fd, tflag, files
   integer getarg, getlin, open, doflds, getfmt
   data tabc /TAB/, tflag /YES/, nflds /MAXFIELDS/
   i = 1        # assume no field specification is given
   if (getarg(1, buf, MAXLINE) == EOF)
      call usage
   else if (buf(1) == QMARK & buf(2) == EOS)
        call usage
                                        # tab fields are specified?
   if (buf(1) == MINUS & (buf(2) == LETT | buf(2) == BIGT) ) {
      if (buf(3) ^= EOS)
         tabc = buf(3)
      i = 2
      }
   else if (buf(1) >= DIG0 & buf(1) <= DIG9) {  # fields are specified
      nflds = doflds(buf, from, to, MAXFIELDS)
      if (nflds == ERR)
                call error ("illegal field specification.")
      tflag = NO
      i = 2
      }
   if (getarg(i, buf, MAXLINE) == EOF)
      call usage                #error, no output format specified
   junk = getfmt(buf, ofmt)
   files = NO
   for (i=i+1; ; i=i+1)
      {
      if (getarg(i, buf, MAXLINE) == EOF)     #done?
          {
          if (files == YES)             #yes, done
               break
          fd = STDIN              #not done, read from STDIN
          }
      else if (buf(1) == MINUS & buf(2) == EOS)
         fd = STDIN
      else
         fd = open(buf, READ)
      files = YES
      if (fd == ERR)
         call cant(buf)
      len = getlin(buf, fd)
      while (len ^= EOF) {
         if (tflag == YES)
            call dotabs(buf, tabc, from, to, nflds)
         for (j = 1; ofmt(j) ^= EOS; j = j + 1)
            if (ofmt(j) == ARGFLAG) {
               n = ofmt(j+1)
               for (k = from(n); k <= to(n) & k < len; k = k + 1)
                   call putch(buf(k), STDOUT)
               j = j + 1
               }
            else
               call putch(ofmt(j), STDOUT)
         call putch(NEWLINE, STDOUT)
         len = getlin(buf, fd)
         }
      if (fd ^= STDIN)
         call close(fd)
      }
    DRETURN
   end
#-t- field           2056 local 08/09/81 12:00:00
#-h- doflds          1025 local 08/09/81 12:00:00
# doflds - get field specifications from buf into from and to
   integer function doflds(buf, from, to, maxsiz)
   character buf(ARB)
   integer from(ARB), to(ARB), maxsiz
   integer i, n
   integer ctoi
   n = 1
   from(1) = 1
   to(1) = HUGE
   for (i = 1; buf(i) ^= EOS; ) {
      n = n + 1
      if (n > maxsiz)
         return(ERR)
      from(n) = ctoi(buf, i)
      to(n) = from(n)
      call skipbl(buf, i)
      if (buf(i) == MINUS) {            # form is n-m
         i = i + 1
         to(n) = ctoi(buf, i)
         call skipbl(buf, i)
         }
      else if (buf(i) == PLUS) {        # form is n+m
         i = i + 1
         to(n) = from(n) + ctoi(buf, i) - 1
         call skipbl(buf, i)
         }
      if (from(n) < 1 |
          from(n) > to(n) |
         (buf(i) ^= COMMA & buf(i) ^= EOS))
           return(ERR)
      if (buf(i) == COMMA)
         i = i + 1
      }
   for (i = n + 1; i <= maxsiz; i = i + 1) {    # clear other fields
      from(i) = HUGE
      to(i) = HUGE
      }
   return(n)
   end
#-t- doflds          1025 local 08/09/81 12:00:00
#-h- dotabs           642 local 08/09/81 12:00:00
# dotabs - break buf into fields defined by tab character c
   subroutine dotabs(buf, c, from, to, maxsiz)
   character buf(ARB), c
   integer from(ARB), to(ARB), maxsiz
   integer i, j, n
   n = 1
   from(n) = 1
   to(n) = HUGE
   j = 1
   for (i = 1; buf(i) ^= EOS & n < maxsiz; i = i + 1)
      if (buf(i) == c) {
         n = n + 1
         from(n) = j
         to(n) = i - 1
         j = i + 1
         }
      if (n < maxsiz)
        {
        n = n + 1
        from(n) = j
        to(n) = HUGE
        }
   for ( ; n < maxsiz; n = n + 1) {     # clear other fields
      from(n+1) = HUGE
      to(n+1) = HUGE
      }
   return
   end
#-t- dotabs           642 local 08/09/81 12:00:00
#-h- getfmt           552 local 08/09/81 12:00:00
# getfmt - convert output format in buf to internal form in fmt
   subroutine getfmt(buf, fmt)
   character buf(ARB)
   character fmt(ARB)
   integer i, j
   character esc
   integer addset
   j = 1
   for (i = 1; buf(i) ^= EOS; i = i + 1)
      {
      if (buf(i) == DOLLAR & buf(i+1) >= DIG0 & buf(i+1) <= DIG9) {
        junk = addset(ARGFLAG, fmt, j, MAXLINE)
        junk = addset(buf(i+1) - DIG0 + 1, fmt, j, MAXLINE)
         i = i + 1
         }
      else
        junk = addset(esc(buf,i), fmt, j, MAXLINE)
      }
 fmt(j) = EOS
 return
 end
#-t- getfmt           552 local 08/09/81 12:00:00
#-h- usage            143 local 08/09/81 12:00:00
# usage - print usage message and die
   subroutine usage
 call error ("usage: field [-t[c] | fieldslist] outputformat [files].")
 return
 end
#-t- usage            143 local 08/09/81 12:00:00
#-t- field.r         4807 local 08/09/81 12:00:00
