#-h-  detab.r                    3378  ascii   02/01/82  16:42:01
#-h-  detab                       840  local   12/22/80  15:32:29
 ## detab - driver for detab tool
 DRIVER(detab)
    character buf(MAXLINE)
    integer open, getarg, length, alldig
    integer tabs(MAXLINE), int, i, k, l


    call settab(tabs)   # set initial tab stops
    int = ERR
    call query ("usage:  detab [<t1> <t2> etc] [+<n>] [files].")

     for (i=1; getarg(i, buf, MAXLINE) != EOF; i=i+1)
        {
        if (buf(1) == PLUS | alldig(buf) == YES)        #ignore flags
                next
        if (buf(1) == MINUS & buf(2) == EOS)    #read from standard input
                int = STDIN
        else
                int = open(buf, READ)
        if (int == ERR)
                call cant(buf)
        call dotab (tabs, int)
        if (int != STDIN)
                call close(int)
        }

    if (int == ERR)     #no files read
        call dotab(tabs, STDIN)
    return
    end
#-t-  detab                       840  local   12/22/80  15:32:29
#-h-  alldig                      281  local   12/22/80  15:32:30
 ## alldig - return YES if str is all digits
 integer function alldig (str)

 integer type, i
 character str(ARB)

 alldig = NO
 if (str(1) == EOS)
        return
 for (i=1; str(i) != EOS; i=i+1)
        if (type(str(i)) != DIGIT)
                return
 alldig = YES
 return
 end
#-t-  alldig                      281  local   12/22/80  15:32:30
#-h-  dotab                       583  local   12/22/80  15:32:30
 ## dotab - convert tabs to equivalent number of blanks
 subroutine dotab (tabs, int)
 integer int
 character getch
 character c
 integer tabs(ARB)
 integer tabpos
 integer col

    col = 1
    while (getch(c, int) != EOF)
       if (c == TAB)
          repeat {
             call putc(BLANK)
             col = col + 1
             if (tabpos(col, tabs) == YES)
                break
             }
       else if (c == NEWLINE) {
          call putc(NEWLINE)
          col = 1
          }
       else {
          call putc(c)
          col = col + 1
          }
    return
    end
#-t-  dotab                       583  local   12/22/80  15:32:30
#-h-  settab                      799  local   12/22/80  15:32:30
 # settab - set initial tab stops
    subroutine settab(tabs)
    integer alldig
    integer tabs(MAXLINE), m, p, k, i, j, l
    integer getarg, ctoi
    character n(4)

   p = 0
   for (i=1; i<=MAXLINE; i=i+1)
       tabs(i) = NO
   for (j=1; getarg(j,n,4)!=EOF; j=j+1)
       {
       k=1
       if (n(1) == PLUS)
          k = k + 1
       if (alldig(n(k)) == NO)
                next
       l = ctoi(n,k)
       if (l<=0 | l>MAXLINE)
          next
       if (n(1)!=PLUS)
          {
          p = l
          tabs(p) = YES
          }
       else
          {
          if (p==0)
             p = l  + 1
          for (m=p; m<=MAXLINE; m=m+l)
             tabs(m) = YES
          }
      }
   if (p==0)
      {
      for (i=9; i<=MAXLINE; i=i+8)
          tabs(i) = YES
      }
   return
   end
#-t-  settab                      799  local   12/22/80  15:32:30
#-h-  tabpos                      215  local   12/22/80  15:32:30
 # tabpos - return YES if col is a tab stop
    integer function tabpos(col, tabs)
    integer col, i, tabs(MAXLINE)

    if (col > MAXLINE)
       tabpos = YES
    else
       tabpos = tabs(col)
    return
    end
#-t-  tabpos                      215  local   12/22/80  15:32:30
#-t-  detab.r                    3378  ascii   02/01/82  16:42:01
