[cc]mc |
.hd fdmlc "interface to Prime DBMS Fortran DML preprocessor" 08/27/84
[cc]mc
fdmlc <input file>
         [-b [<output file>]]
         [-l [<listing file>]]
         [-z <FDML option>]
.ds
'Fdmlc' serves as the Subsystem interface to the Prime DBMS
Fortran DML preprocessor (FDML).
It examines its option specifications and checks them for consistency,
provides Subsystem-compatible default file names for the listing
and output files as needed, and then produces a
Primos FDML command and causes it to be executed.
.sp
The "-b" option is used to select the name of the file to receive the
output Fortran code from the preprocessor.
If a file name follows the option, then that file receives the output.
If the option is not specified, or no file name follows it, a default
filename is constructed from the input filename by changing its suffix
to ".df".
For example, if the input filename is "prog.f", the output file will be
"prog.df";
if the input filename is "foo", the output file will be "foo.df".
.sp
The "-l" option is used to select the name of the file to receive the
listing generated by the preprocessor.
If a file name follows the option, then that file receives the listing.
If the "-l" option is specified without a file name following it
or is not specified,
a default filename is constructed from the input filename by changing
its suffix to ".dl".
For example, if the input filename is "gonzo", the listing file will
be "gonzo.dl";
if the input filename is "bar", the listing file will be "bar.dl".
.sp
The input filename must be a disk file name (conventionally
ending in ".f", ".f77", or ".ftn").
.sp
In summary, then, the default command line for compiling a file named
"file.f" is
.sp
.nf
     fdmlc  file.f  -b file.df  -l file.dl
.sp
which corresponds to the FDML command
.sp
     fdml -i *>file.f -b *>file.df -l *>file.dl
.sp
.fi
.es
fdmlc file.f
fdmlc payroll.f -b b_payroll -l l_payroll
fdmlc funnyprog.f -z"-newopt"
.me
.in +5
.ti -5
"Usage: fdmlc ..." for invalid option syntax.
.ti -5
"missing input file name" if no input filename could be found.
.ti -5
"<name>: unreasonable input file name" if an attempt was made to read
from the null device or the line printer spooler.
.ti -5
"<name>: unreasonable binary file name" if an attempt was made to
output on the terminal or line printer spooler.
.ti -5
"Sorry, the listing file must be a disk file" if the listing
file was directed to a device file.
.in -5
.bu
'Fdmlc' pays no attention to standard ports.

There is no way to avoid getting both a listing and output file.
.sa
[cc]mc |
ddlc (1), f77c (1), fc (1), fsubc (1), ld (1), bind (3)
[cc]mc
