/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)TraceNode.c	1.1 84/06/12
*/

/*
**	Print out details of node if tracing turned on.
*/

#include	"global.h"
#include	"debug.h"
#include	"state.h"

#include	"node.h"

#include	<stdio.h>


#define	Fprintf	(void)fprintf


void
TraceNode(name)
	char *			name;
{
	register Entry *	ep;

	if ( Traceflag < 2 )
		return;

	Fprintf(stderr, "Trace node \"%s\"", name);

	if ( (ep = Lookup(name, NodeHash)) == (Entry *)0 )
	{
		Fprintf(stderr, " does not exist!\n");
		return;
	}

	if ( ep == Home )
		Fprintf(stderr, " (home)");

	Fprintf
	(
		stderr,
		", to %d, from %d, states 0x%x\n",
		ep->e_node->n_tolinks,
		ep->e_node->n_fromlinks,
		ep->e_states
	);
}
