/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)Packet.h	1.1 84/06/12
*/

/*
**	Node-Node Packet Description
*/

#define	PKTHDR		0		/* Header info in byte 0 */
#define	PKTSIZE		1		/* Size of data in byte 1 */
#define	PKTNSIZE	2		/* Complement of size in byte 2 */
#define	PKTHDRZ		3		/* Header size */
#define	PKTDATAZ	128		/* Maximum data size */
#define	PKTCRCZ		2		/* CRC-16 */

/*
**	Definition of bit fields in header byte 0
**	'_S' is low bit position in byte,
**	'_M' is mask for field.
**	(if only bit fields in C were m/c independent, sigh ...)
*/

#define	PKTCHK_M	1		/* CRC present bit */
#define	PKTCHK_S	7
#define	PKTTYP_M	3		/* Type */
#define	PKTTYP_S	5
#define	PKTCHN_M	3		/* Channel number */
#define	PKTCHN_S	3
#define	PKTSEQ_M	7		/* Sequence number */
#define	PKTSEQ_S	0

#define	MAXCHANS	(PKTCHN_M+1)	/* Number of channels */
#define	SEQMOD		(PKTSEQ_M+1)	/* Range for sequence number */

/*
**	Packet Types
*/

#define	PKTDATATYP	0		/* Packet contains message data */
#define	PKTACKTYP	1		/* Packet acknowledgement */
#define	PKTNAKTYP	2		/* Packet negative acknowledgement */
#define	PKTCNTLTYP	3		/* Packet contains control data */

/*
**	Structure for a maximum sized packet
*/

typedef struct 
{
	char	pkt_hdr[PKTHDRZ];
	char	pkt_data[PKTDATAZ];
	char	pkt_crc[PKTCRCZ];
}
			Packet;

typedef Packet *	Pkt_p;

/*
**	Structure for out-of-band control packets
*/

#define	CNTLPKTZ	3

typedef struct 
{
	char	cpk_hdr[PKTHDRZ];
	char	cpk_data[CNTLPKTZ];
	char	cpk_crc[PKTCRCZ];
}
			Cntlpkt;

/*
**	Structure for in-band reply packets
*/

typedef struct 
{
	char	rpk_hdr[PKTHDRZ];
	char	rpk_crc[PKTCRCZ];
}
			Replypkt;

/*
**	Table of ordered sequence numbers
*/

Extern char		SeqTable[2*SEQMOD];
