/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)CopyFrComF.c	1.1 84/06/12
*/

/*
**	Read a command file, and copy all files listed as per commands.
*/

#define	FILE_CONTROL
#define	STDIO

#include	"global.h"


static int	Ofd;
static char *	Ofile;
static char *	OneFile;

static char *	Cantread = "Can't read \"%s\"";

bool		CFCFread();



void
CopyFromComFile(comfile, ofd, ofile, onefile)
	char *		comfile;
	int		ofd;
	char *		ofile;
	char *		onefile;
{
	register int	ifd;
	Time_t		mtime;

	while ( (ifd = open(comfile, O_READ)) == SYSERROR )
		Syserror(Cantread, comfile);

	Ofd = ofd;
	Ofile = ofile;
	OneFile = onefile;

	if ( !ReadCom(ifd, &mtime, CFCFread) )
		Error("bad commands in \"%s\"", comfile);

	(void)close(ifd);
}



bool
CFCFread(name, base, range)
	char *		name;
	register long	base;
	long		range;
{
	if
	(
		range != 0
		&&
		(
			OneFile == NULLSTR
			||
			strcmp(OneFile, name) == STREQUAL
		)
	)
	{
		register int	fd;

		while ( (fd = open(name, O_READ)) == SYSERROR )
			Syserror(Cantread, name);

		(void)lseek(fd, base, 0);

		while ( range > 0 )
		{
			register int	r;
			register int	w;
			register char *	cp;
			char		buf[BUFSIZ];

			if ( range > sizeof buf )
				r = sizeof buf;
			else
				r = range;

			if ( (r = read(fd, buf, r)) <= 0 )
			{
				Syserror(Cantread, name);
				continue;
			}

			range -= r;

			cp = buf;

			while ( (w = write(Ofd, cp, r)) != r )
			{
				if ( w == SYSERROR )
					Syserror("Can't write \"%s\"", Ofile);
				else
				{
					cp += w;
					r -= w;
				}
			}
		}

		(void)close(fd);
	}

	free(name);
	return true;
}
