/* Copyright (c) 1982 Regents of the University of California */

/* @(#)ndir.h 4.4 3/30/82 */

#ifndef	major
#include	<sys/types.h>
#endif

#if	BSD4 == 1 && BSD4V == 'a'
#include	"/usr/include/ndir.h"
#else	BSD4 == 1
#if	BSD4 >= 2 || (BSD4 == 1 && BSD4V > 'a')
#include	<sys/dir.h>
#else	BSD4 >= 2 || ...

#define		DIRSIZ	14

/*
 * This sets the "page size" for directories.
 * Requirements are DEV_BSIZE <= DIRBLKSIZ <= MINBSIZE with
 * DIRBLKSIZ a power of two.
 * Dennis Ritchie feels that directory pages should be atomic
 * operations to the disk, so we use DEV_BSIZE.
 */
#define DIRBLKSIZ 512

/*
 * This limits the directory name length. Its main constraint
 * is that it appears twice in the user structure. (u. area)
 */
#define MAXNAMLEN DIRSIZ

struct	direct {
	ino_t	d_ino;
	char	d_name[MAXNAMLEN + 1];
	/* typically shorter */
};

typedef struct _dirdesc {
	int	dd_fd;
	long	dd_loc;
	long	dd_size;
	char	dd_buf[DIRBLKSIZ];
} DIR;

/*
 * useful macros.
 */
#ifndef	NULL
#define	NULL	0
#endif

/*
 * functions defined on directories
 */
extern DIR *opendir();
extern struct direct *readdir();
extern long telldir();
extern void seekdir();
#define rewinddir(dirp)	seekdir((dirp), 0L)
extern void closedir();

#endif	BSD4 == 2 || ...
#endif	BSD4 == 1
