/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)ftheader.h	1.4 85/05/03
*/

/*
**	Define file transfer protocol header and memory image.
*/

#define	FTH_TYP1	1	/* Type 1 header */

#define	FTH_LENGTH_SIZE	8	/* Fixed length field at end of header */
#define	MIN_FTH_LENGTH	11	/* Minimum number of bytes in a legal header */
#define	MODE_SIZE	4	/* Number of bytes in a file mode */

#define	FTH_USEP	','	/* Char to separate user names */
#define	FTH_UDEST	'@'	/* Char to separate destinations from users */
#define	FTH_UDSEP	';'	/* Char to separate user/destination pairs */
#define	FTH_FDSEP	','	/* Char to separate file descriptor fields */
#define	FTH_FSEP	';'	/* Char to separate file descriptors */

/*
**	Define positions of null terminated fields
*/

typedef enum
{
	fth_type,
	fth_to, fth_from,
	fth_files,
	fth_n,
	fth_badread = fth_n, fth_badcrc, fth_badlen, fth_baddatacrc,
	fth_ok
}
	FthReason;

#define	NFTHFIELDS	(int)fth_n

typedef struct
{
	char *	fth_start[NFTHFIELDS];
}
	Fth_Fields;

Extern Fth_Fields	FthFields;

Extern char *		FthDescs[]
#ifdef	HDR_DATA
=
{
	"type",
	"to",
	"from",
	"file descriptors",
	"read",
	"CRC",
	"length",
	"data CRC"
}
#endif	HDR_DATA
;

#ifndef	unreasonable
#define	FthType		FthFields.fth_start[(int)fth_type]
#define	FthTo		FthFields.fth_start[(int)fth_to]
#define	FthFrom		FthFields.fth_start[(int)fth_from]
#define	FthFdescs	FthFields.fth_start[(int)fth_files]
#else	unreasonable
#define	FthType		FthFields.fth_start[0]
#define	FthTo		FthFields.fth_start[1]
#define	FthFrom		FthFields.fth_start[2]
#define	FthFdescs	FthFields.fth_start[3]
#endif	unreasonable

#define	FTHREASON(A)	FthDescs[(int)A]

/*
**	Type field
*/

enum { ftt_ack, ftt_datacrc, ftt_type };

#define	FTH_BASE_TYPE	0100		/* Base for 1st char in type field */

#define	FTH_ACK		(1<<(int)ftt_ack)
#define	FTH_DATACRC	(1<<(int)ftt_datacrc)
#define	FTH_TYPE	((FTH_TYP1<<(int)ftt_type)|FTH_BASE_TYPE)

#define	TYPOF_FTH(C)	(((C)&~FTH_BASE_TYPE)>>(int)ftt_type)

/*
**	Structure of file descriptor list
*/

typedef struct FthFDesc *FthFD_p;

typedef struct FthFDesc
{
	FthFD_p	f_next;
	char *	f_name;		/* Name */
	long	f_length;	/* Length */
	Time_t	f_time;		/* Modify time */
	short	f_mode;		/* Permissions */
}
			FthFDesc;

#define	FTH_MODES	00777	/* Permission bits from inode */
#define	FTH_NOT_IN_MESG	01000	/* Flag used by sendfile */

/*
**	Structure of user list.
*/

typedef struct FthUlist	*FthUl_p;

typedef struct FthUlist
{
	FthUl_p	u_next;
	char *	u_name;		/* A user */
	char *	u_dest;		/* Associated address */
}
			FthUlist;

/*
**	Globals
*/

Extern Crc_t		DataCrc;
Extern long		FtDataLength;
Extern char *		FtHeader;
#ifndef	HDR_DATA
Extern int		FthLength;
#endif	HDR_DATA
Extern FthFDesc *	FthFiles;
Extern FthUlist *	FthUsers;
Extern int		NFthFiles;
Extern int		NFthUsers;

extern bool		AtHome();
extern void		FreeFthFiles();
extern void		FthToFree();
extern FthReason	GetFthFiles();
extern int		GetFthTo();
extern bool		InFthTo();
extern FthReason	ReadFtHeader();
extern void		SetFthFiles();
extern void		SetFthTo();
extern int		WriteFtHeader();
