/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)Stream.h	1.6 85/02/08
*/

/*
**	Message streams
*/

#define	NSTREAMS	3		/* Number of simultaneous streams in each direction */
#define	STREAMIDZ	NNCFNZ		/* Maximum length of a stream identifier */
#define	SIZELEN		10		/* Maximum length of an ASCII stream size */
#define	TIMELEN		10		/* Maximum length of an ASCII unix time */

/*
**	Message transmission descriptor
*/

typedef struct DQel	DQel;
typedef struct DQel
{
	DQel *	ql_next;		/* Next descriptor in queue */
	char *	ql_filename;		/* Filename for data */
	long	ql_base;		/* Start address in file */
	long	ql_range;		/* Length of data from "start" */
};

typedef DQel *		DQl_p;
Extern DQl_p		DQfreelist;	/* Free list of descriptors */

typedef struct
{
	long	dq_count;		/* Count of data left in current descriptor */
	DQl_p	dq_first;		/* First descriptor in queue */
	char *	dq_data;		/* Data from command file */
	Time_t	dq_time;		/* Time of last control message */
}
			DQhead;

/*
**	Message reception data
*/

typedef struct
{
	char *	rh_fn;			/* Work file name */
	char	rh_id[STREAMIDZ+1];	/* Last component of rh_fn for recovery */
}
			Rhead;

/*
**	Message stream control data, receive/transmit
*/

typedef union
{
	Rhead	dt_rh;			/* Filenames for receive */
	DQhead	dt_dqh;			/*  or transmission descriptor queue */
}
			Data;

typedef struct
{
	Data	str_data;		/* Pointer to data for files */
	long	str_size;		/* The message's size */
	long	str_posn;		/* Current position in message */
	ulong	str_bytes;		/* Bytes transferred */
	ulong	str_messages;		/* Messages transferred */
	Time_t	str_time;		/* Time at start of message */
	short	str_fd;			/* Unix file descriptor for current data file */
	char	str_state;		/* State of stream */
	char	str_flags;		/* Flags for stream */
	char	str_id[STREAMIDZ+1];	/* The message's "id" */
}
			Stream;

typedef Stream *	Str_p;

#define	str_recv	str_data.dt_rh
#define	str_fname	str_recv.rh_fn
#define	str_descr	str_data.dt_dqh
#define	str_count	str_descr.dq_count
#define	str_sent	str_descr.dq_time

/*
**	Stream states
*/

enum
{
	str_idle, str_start, str_active,
	str_ending, str_ended, str_empty,
	str_error, str_inactive, str_again
};

#define	STR_IDLE	(int)str_idle	/* Stream is inactive */
#define	STR_START	(int)str_start	/* Stream has message awaiting transmission */
#define	STR_ACTIVE	(int)str_active	/* Stream has message in transmission */
#define	STR_ENDING	(int)str_ending	/* Stream has message terminating */
#define	STR_ENDED	(int)str_ended	/* Stream has completed message handling */
#define	STR_EMPTY	(int)str_empty	/* Stream has no messages waiting */
#define	STR_ERROR	(int)str_error	/* Stream has an error condition */
#define	STR_INACTIVE	(int)str_inactive /* Stream has an error condition */
#define	STR_AGAIN	(int)str_again	/* Message may have been received ok */

/*
**	Stream flags.
*/

enum { str_dup };			/* This message may be a duplicate */

#define	STR_DUP		(1<<(int)str_dup)

/*
**	State structure.
*/

typedef struct
{
	char	linkstate;		/* State of link */
	char	procstate;		/* State of daemon */
	short	procid;			/* Process ID */
	long	speed;			/* Minimum effective bytes/second of link */
	long	maxspeed;		/* Maximum effective bytes/second of link */
	short	packetsize;		/* Current packet data size */
	short	nbufs;			/* Current window size */
	short	recvtimo;		/* Current receive timeout */
	ulong	inbytes;		/* Bytes received recently */
	ulong	outbytes;		/* Bytes transmitted recently */
	Time_t	lasttime;		/* Beginning of "recently" */
	ulong	allbytes;		/* Total bytes transferred */
	ulong	allmessages;		/* Total messages transferred */
	Time_t	starttime;		/* Daemon start time */
	Time_t	thistime;		/* Status file write time */
	ulong	activetime;		/* Total time while active */
	ulong	inpkts;			/* Total packets received */
	ulong	outpkts;		/* Total packets transmitted */
	Stream	streams[2][NSTREAMS];	/* I/O status */
	char	version[8];		/* SCCSID */
}
			NN_state;

Extern NN_state		NNstate;

#define	INSTREAMS	0
#define	OUTSTREAMS	1

#define	inStreams	NNstate.streams[INSTREAMS]
#define	outStreams	NNstate.streams[OUTSTREAMS]

#define	inByteCount	NNstate.inbytes
#define	outByteCount	NNstate.outbytes

#define	StreamSCCSID	"1.6"

/*
**	Link states
*/

enum {	link_down, link_up };

#define	LINK_DOWN	(int)link_down
#define	LINK_UP		(int)link_up

/*
**	Daemon states
*/

enum {	proc_idle, proc_running, proc_error, proc_opening, proc_calling };

#define	PROC_IDLE	(int)proc_idle
#define	PROC_RUNNING	(int)proc_running
#define	PROC_ERROR	(int)proc_error
#define	PROC_OPENING	(int)proc_opening
#define	PROC_CALLING	(int)proc_calling
