/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)UpdateHeader.c	1.8 85/05/04
*/

/*
**	Update the statistics in the header.
**	If 'TimeToDie' field in non-zero, decrement it.
**	Write out statistics record for later processing by 'state'.
**
**	Return false if message has timed out, otherwise true.
*/

#define	STDIO

#include	"global.h"
#include	"address.h"
#include	"header.h"
#include	"stats.h"


extern Time_t	Time;

static char *	Link;

bool		UpPrint();



bool
UpdateHeader(tt, ttd_p)
	ulong		tt;	/* Travel time for last link */
	ulong *		ttd_p;	/* The remaining time-to-die for message */
{
	register ulong	ttd;
	register char *	cp;
	char		stats[1+NODE_NAME_SIZE+1+TIME_SIZE+1];

	(void)sprintf(stats, "%c%s%c%lu", HC_ROUTE, HomeNode, HC_TIME, tt);
	HdrRoute = concat(HdrRoute, stats, NULLSTR);

	if ( tt > 0 )
	{
		ttd = atol(HdrTt);
		HdrTt = Malloc(TIME_SIZE+1);
		(void)sprintf(HdrTt, "%lu", tt+ttd);
	}

	if ( !HomeAddress(HdrSource, (char **)0, EXCL_HIER) )
	{
		/*
		**	Write out statistics record
		*/

		Link = NULLSTR;

		if ( (cp = GetEnv(ENV_RETURNED)) != NULLSTR )
		{
			free(cp);
			WrStats(ST_RETMESG, UpPrint);
		}
		else
			WrStats(ST_INMESG, UpPrint);
	}

	/*
	**	Update "time-to-die".
	*/

	*ttd_p = 0;

	if ( (ttd = atol(HdrTtd)) == 0 )
		return true;

	if ( tt >= ttd )
	{
		/*
		**	This messsage has expired.
		*/

		return false;
	}
	else
	{
		ttd -= tt;
		HdrTtd = Malloc(TIME_SIZE+1);
		(void)sprintf(HdrTtd, "%lu", ttd);
		*ttd_p = ttd;
	}

	return true;
}



/*
**	Called from "WriteStats()" to put out statistics fields.
*/

bool
UpPrint(fd, count)
	FILE *	fd;
	int	count;
{
	static char *	string = "%s";
	static char *	number = "%lu";

	switch ( (StMesg_t)count )
	{
	case sm_time:	(void)fprintf(fd, number, Time);		break;
	case sm_size:	(void)fprintf(fd, number, DataLength+HdrLength);break;
	case sm_dest:	(void)fprintf(fd, string, HdrDest);		break;
	case sm_source:	(void)fprintf(fd, string, HdrSource);		break;
	case sm_route:	(void)fprintf(fd, string, HdrRoute);		break;
	case sm_handler:(void)fprintf(fd, string, HdrHandler);		break;
	case sm_tt:	(void)fprintf(fd, string, HdrTt);		break;
	case sm_link:	if ( Link != NULLSTR )
				(void)fprintf(fd, string, Link);
			break;
	}

	if ( count < (int)sm_last )
		return true;

	return false;
}



/*
**	Write out a statistics record for outbound message
*/

void
UpStats(link)
	char *	link;
{
	Link = link;

	WrStats(ST_OUTMESG, UpPrint);
}
