#!/bin/sh
#
#	Print out all stater messages
#

for i in *
do
	case $i
	in
	State*|Addstate)
		;;
	*)
		node=`expr \( $i : '[^/]*/\([^.]*\)' \) \| \( $i : '\([^.]*\)' \)`
		/bin/state -EV -h$node -s$i
		;;
	esac
done |
	awk	'
						{
				# print "    ____: " $0
			}
		/^ACSnet map/			{
				hier = ""
				node = ""
				ignore = 0
				next
			}
						{
				if ( ignore ) next
			}
		/^ -> /				{
				if ( node == "" ) next
				printf "%s", node
				if ( hier != "" ) printf "%s", hier
				len = length(node hier)
				while ( len < 35 ) { printf " "; len++ }
				printf " \"\"\n"
				hier = ""
				node = ""
				ignore = 1
			}
		/^Local domain hierarchy/	{
				hier = "." $4 
				# print "    HIER: " hier
				next
			}
		/^[^ ]+/ && $0 !~ /"/		{
				node = $1 
				# print "    NODE: " node
				next
			}
		/^ +"/				{
				printf "%s", node
				if ( hier != "" ) printf "%s", hier
				len = length(node hier)
				while ( len < 35 ) { printf " "; len++ }
				for ( i = 1 ; i <= NF ; i++ ) printf " %s", $i
				printf "\n"
				hier = ""
				node = ""
				ignore = 1
			}' |
				sort -u
