#
/*
 */

#include "../param.h"
#include "../systm.h"
#include "../user.h"
#include "../proc.h"
#include "../buf.h"
#include "../reg.h"
#include "../inode.h"
#include "../text.h"
#include "../pgrp.h"

/*
 * exec system call.
 * Because of the fact that an I/O buffer is used
 * to store the caller's arguments during exec,
 * and more buffers are needed to read in the text file,
 * deadly embraces waiting for free buffers are possible.
 * Therefore the number of processes simultaneously
 * running in exec has to be limited to NEXEC.
 * errors --
 * E2BIG: The program is too big to execute.
 * EACCESS: not executable.
 * ENEXEC: The program isn't in proper format (no magic #).
 * ETXTBSY: Someone is accessing the file. (messes up cdb).
 */

exec()
{
	/* ##stt 9/16/76 changes for 405 i-space only made */
	int argaddr, ap, na, nc, *bp;
	int ts, ds, ss, sep;
	int newaddr, oldaddr;
	register c, *ip;
	register char *cp;
	extern uchar;

	/*
	 * pick up file names
	 * and check various modes
	 * for execute permission
	 */

	if ((ip = namei(&uchar, 0)) == NULL)
		return;
	while(execnt >= NEXEC)
		sleep(&execnt, PEXEC);
	execnt++;
	if(access(ip, IEXEC) || (ip->i_mode&IFMT)!=0)
		goto bad2;	/*##stt 11/29/76 leave with EACCES error */

	argaddr = u.u_arg[1];	/* ##stt9/16 save arg addr. */

	/*
	 * read in first 8 bytes
	 * of file for segment
	 * sizes:
	 * w0 = 407/410/411 (410 implies RO text) (411 implies sep ID)
	 * w1 = text size
	 * w2 = data size
	 * w3 = bss size
	 */

	u.u_base = &u.u_arg[0];
	u.u_count = 8;
	u.u_offset[1] = 0;
	u.u_offset[0] = 0;
	u.u_segflg = 1;
	readi(ip);
	u.u_segflg = 0;
	if(u.u_error)
		goto bad1;
	sep = 0;
	c = u.u_arg[0];
	if(c == 0405) {
		/*##stt 405 i-space only */
		if (u.u_sep == 0) goto noexec;
		sep = c;	/*##stt sep = 0405 if 405 exec */
	} else
	if(c == 0407) {
		u.u_arg[2] =+ u.u_arg[1];
		u.u_arg[1] = 0;
	} else
	if(c == 0411)
		sep++; else
	if(c != 0410) {
     noexec:	u.u_error = ENOEXEC;
		goto bad2;
	}
	if(u.u_arg[1]!=0 && (ip->i_flag&ITEXT)==0 && ip->i_count!=1) {
		u.u_error = ETXTBSY;
		goto bad2;
	}
	/*##stt 8/7/76 check for max # simul uses of text */
	if (xlimchk(ip) == 0) {
		u.u_error = ETXTBSY;
		goto bad2;
	}

	/*
	 * pack up arguments into
	 * allocated disk buffer
	 */

       if (sep != 0405) {	/*##stt no args on 405 exec */
	bp = getblk(NODEV);
	cp = bp->b_addr;
	na = 0;
	nc = 0;
	while(ap = fuword(argaddr)) {
		na++;
		if(ap == -1)
			goto bad1;
		argaddr =+ 2;
		for(;;) {
			c = fubyte(ap++);
			if(c == -1)
				goto bad1;
			*cp++ = c;
			nc++;
			if(nc > 510) {
				u.u_error = E2BIG;
				goto bad1;
			}
			if(c == 0)
				break;
		}
	}
	if((nc&1) != 0) {
		*cp++ = 0;
		nc++;
	}
       }	/*##stt above done only if not 0405 exec */

	/*
	 * find text and data sizes
	 * try them out for possible
	 * exceed of max sizes
	 */

	ts = ((u.u_arg[1]+63)>>6) & 01777;
	if (sep != 0405) {
		ds = ((u.u_arg[2]+u.u_arg[3]+63)>>6) & 01777;
		ss = SSIZE;
	} else {
		ds = u.u_dsize;
		ss = u.u_ssize;
		oldaddr = u.u_procp->p_addr + USIZE;
		u.u_procp->p_size =- (ds + ss);
	}
	if(estabur(ts, ds, ss, sep))
		goto bad1;

	/*
	 * allocate and clear core
	 * at this point, committed
	 * to the new image
	 */

	u.u_prof[3] = 0;
	if ((cp = u.u_procp->p_textp) == 0 || cp->x_iptr != ip) {
		/*##stt 1/25/77 avoid re-exec of self to avoid lockup */
		xfree();
		expand(USIZE);
		xalloc(ip);
	}
	c = ds + ss;
	expand (USIZE + c);
	newaddr = u.u_procp->p_addr + USIZE;
	if (sep != 0405) {
		while(--c >= 0)
			clearseg(newaddr+c);
	
		/*
		 * read in data segment
		 */
	
		estabur(0, ds, 0, 0);
		u.u_base = 0;
		u.u_offset[1] = 020+u.u_arg[1];
		u.u_count = u.u_arg[2];
		readi(ip);
	} else {
		/*
		 * copy data segment from old area
		 */
		while (--c >= 0)
			copyseg(oldaddr+c, newaddr+c);
		mfree(coremap, ss+ds, oldaddr);
	}

	/*
	 * set up final process size
	 */

	estabur(u.u_tsize = ts,
		u.u_dsize = ds,
		u.u_ssize = ss,
		u.u_sep = sep);

	/*
	 * initialize stack segment
	 */

	if (sep != 0405) {
		cp = bp->b_addr;
		ap = -nc - na*2 - 4;
		u.u_ar0[R6] = ap;
		suword(ap, na);
		c = -nc;
		while(na--) {
			suword(ap=+2, c);
			do
				subyte(c++, *cp);
			while(*cp++);
		}
		suword(ap+2, -1);
	}

	/*
	 * set SUID/SGID protections, if no tracing
	 */

	if ((u.u_procp->p_flag&STRC)==0) {
		if(ip->i_mode&ISUID && u.u_uid) {
/**rjb**/		c = ip->i_uid;
/**rjb**/		c =<< 8;
/**rjb**/		c =| ip->i_gid;
/**rjb**/		u.u_uid = c;
/**rjb**/		u.u_procp->p_uid = c;
		}
	}

	/*
	 * Clear any signals to meaningless subroutines.
	 * Clear all registers. ##stt unless 405 exec
	 * R0 is set to the parent id and R1 is set to the process id.
	 */

	c = ip;
	for(ip = &u.u_hsignal[0]; ip < &u.u_signal[NSIG]; ip++)
		if((*ip & 1) == 0)
			*ip = 0;
	if (sep != 0405) {
		for(cp = &regloc[0]; cp < &regloc[6];)
			u.u_ar0[*cp++] = 0;
		ip = u.u_procp;
		u.u_ar0[R0] = ip->p_ppid;
		u.u_ar0[R1] = ip->p_pid;
		for(ip = &u.u_fsav[0]; ip < &u.u_fsav[25];)
			*ip++ = 0;
	}
	u.u_ar0[R7] = 0;
	ip = c;

bad1:
	if (sep != 0405 ) brelse(bp);	/*##stt no buf if 405 exec */
bad2:
	iput(ip);
	if(execnt >= NEXEC)
		wakeup(&execnt);
	execnt--;
}

/*
 * exit system call:
 * pass back caller's r0
 */
rexit()
{

	u.u_arg[0] = u.u_ar0[R0] << 8;
	exit();
}

/*
 * Release resources.
 * Signal to ignore everthing (including kill).
 * Close all user file descriptors.
 * Free any reference to a sharable text segment.
 * Save u. area for parent to look at.
 * Enter zombie state.
 * Wake up parent and init processes,
 * and dispose of children.
 */
exit()
{
	register int *q;
	register struct proc *p;
	register char *a;
	struct proc *foster;
	static struct pgrp nulpgrp;	/* used to simplify logic later */

	u.u_procp->p_flag =& ~STRC;
	for(q = &u.u_hsignal[0]; q < &u.u_signal[NSIG];)
		*q++ = 1;
 /* protocol change... ofile to pfile below ##bsb 3-27-76 */
	for(q = &u.u_ofile[0]; q < &u.u_pfile[NOFILE]; q++)
		if(a = *q) {
			*q = NULL;
			closef(a);
		}
	ilkput(u.u_cdir);	/*##stt 1/17/77 improve locking */
	xfree();
	if ((a = malloc(swapmap, 1)) == NULL)
		panic("out of swap");
	p = getblk(swapdev, a);
	bcopy(&u, p->b_addr, 256);
	bwrite(p);
	q = u.u_procp;
	mfree(coremap, q->p_size, q->p_addr);
	q->p_addr = a;
	q->p_stat = SZOMB;

	/* ##stt 3/2/77 rewrite with process groups */
	a = q->p_grp;	/* save for compare later */
	/* set a to point to a null pgrp if null */
	if (a == NULL) a = &nulpgrp;
	if (q == a->pg_procp)
		/* super pop, wipe out process group */
		pgremove(q);

loop:
	for(p = &proc[0]; p <= maxproc; p++)
	if(q->p_ppid == p->p_pid) {
		/* ##stt/bsb 4/7/77 setrun instead of wakeup */
		setrun(p);
		for(p = &proc[0]; p <= maxproc; p++)
		if(q->p_pid == p->p_ppid) {
			if (p->p_uid == 0 && a == p->p_grp)
				pgremove(p);
			foster = (a != p->p_grp)?
			    &proc[1]: a->pg_procp;
			p->p_ppid = foster->p_pid;
			if (p->p_stat == SZOMB)
				setrun(foster);
			else if (p->p_stat == SSTOP)
				setrun(p);
		}
		swtch();
		/* no return */
	}
	q->p_ppid = 1;
	goto loop;
}

/*
 * Wait system call.
 * Search for a terminated (zombie) child,
 * finally lay it to rest, and collect its status.
 * Look also for stopped (traced) children,
 * and pass back status from them.
 * errors --
 * ECHILD: The process doesn't have any children to wait for.
 */
wait()
{
	register f, *bp;
	register struct proc *p;

	f = 0;

loop:
	for(p = &proc[0]; p <= maxproc; p++)
	if(p->p_ppid == u.u_procp->p_pid) {
		f++;
		if(p->p_stat == SZOMB) {
			u.u_ar0[R0] = p->p_pid;
			bp = bread(swapdev, f=p->p_addr);
			mfree(swapmap, 1, f);
			pgremove(p);
			p->p_pid = 0;
			p->p_ppid = 0;
			p->p_sig = 0;
			p->p_flag = 0;
			p->p_stat = NULL;
			if (p==maxproc){
				while((--p)->p_stat==NULL);
				maxproc=p;
			}
			p = bp->b_addr;
			u.u_cstime[0] =+ p->u_cstime[0];
			dpadd(u.u_cstime, p->u_cstime[1]);
			dpadd(u.u_cstime, p->u_stime);
			u.u_cutime[0] =+ p->u_cutime[0];
			dpadd(u.u_cutime, p->u_cutime[1]);
			dpadd(u.u_cutime, p->u_utime);
			u.u_ar0[R1] = p->u_arg[0];
			brelse(bp);
			return;
		}
		if(p->p_stat == SSTOP) {
			if((p->p_flag&SWTED) == 0) {
				p->p_flag =| SWTED;
				u.u_ar0[R0] = p->p_pid;
				u.u_ar0[R1] = (p->p_sig<<8) | 0177;
				return;
			}
			p->p_flag =& ~(STRC|SWTED);
			setrun(p);
		}
	}
	if(f) {
		sleep(u.u_procp, PWAIT);
		goto loop;
	}
	u.u_error = ECHILD;
}

/*
 * fork system call.
 * errors --
 * EAGAIN: System process table is full, try again.
 */
fork()
{
	register struct proc *p1, *p2;
	register struct pgrp *g;

	p1 = u.u_procp;
	g = p1->p_grp;
	for(p2 = &proc[0]; p2->p_stat != NULL; ) {
		if (++p2 >= &proc[NPROC]) {
			u.u_error = EAGAIN;
			u.u_ar0[R7] =+ 2;
			return;
		}
	}
	if (g != NULL && g->pg_pleft != 0 && --g->pg_pleft == 0) {
		g->pg_pleft++;
		u.u_error = EPLIM;
		u.u_ar0[R7] =+ 2;
		return;
	}
	if(newproc()) {
		u.u_ar0[R0] = p1->p_pid;
		u.u_cstime[0] = 0;
		u.u_cstime[1] = 0;
		u.u_stime = 0;
		u.u_cutime[0] = 0;
		u.u_cutime[1] = 0;
		u.u_utime = 0;
		return;
	}
	u.u_ar0[R0] = p2->p_pid;
	u.u_ar0[R7] =+ 2;
}

/*
 * break system call.
 *  -- bad planning: "break" is a dirty word in C.
 */
sbreak()
{
	register a, n, d;
	int i;

	/*
	 * set n to new data size
	 * set d to new-old
	 * set n to new total size
	 */

	n = (((u.u_arg[0]+63)>>6) & 01777);
	if(!u.u_sep)
		n =- nseg(u.u_tsize) * 128;
	if(n < 0)
		n = 0;
	d = n - u.u_dsize;
	n =+ USIZE+u.u_ssize;
	if(estabur(u.u_tsize, u.u_dsize+d, u.u_ssize, u.u_sep))
		return;
	u.u_dsize =+ d;
	if(d > 0)
		goto bigger;
	a = u.u_procp->p_addr + n - u.u_ssize;
	i = n;
	n = u.u_ssize;
	while(n--) {
		copyseg(a-d, a);
		a++;
	}
	expand(i);
	return;

bigger:
	expand(n);
	a = u.u_procp->p_addr + n;
	n = u.u_ssize;
	while(n--) {
		a--;
		copyseg(a-d, a);
	}
	while(d--)
		clearseg(--a);
}
