#
/*
 */

/*
 *	indirect driver for controlling tty.
 */
#include "../param.h"
#include "../conf.h"
#include "../user.h"
#include "../tty.h"
#include "../proc.h"
#include "../pgrp.h"

syopen(dev, flag)
{

	if((dev = sytdev()) >= 0)
	(*cdevsw[dev.d_major].d_open)(dev, flag);
}

syread(dev)
{

	if((dev = sytdev()) >= 0)
	(*cdevsw[dev.d_major].d_read)(dev);
}

sywrite(dev)
{

	if((dev = sytdev()) >= 0)
	(*cdevsw[dev.d_major].d_write)(dev);
}

sysgtty(dev, flag)
{

	if((dev = sytdev()) >= 0)
	(*cdevsw[dev.d_major].d_sgtty)(dev, flag);
}

sytdev()
{
	register struct pgrp *g;
	register char *dminor;	/* unsigned */

	g = u.u_procp->p_grp;
	if (g == NULL || (dminor = g->pg_dev.d_major) >= nchrdev) {
		u.u_error = ENXIO;
		return(-1);
	}
	return(g->pg_dev);
}
