#include "/h/dirent.h"
#include "/h/stat.h"
#include "/h/errors.h"
main(c,v)
char **v;
{
	register char *cp, *lp, *pp;
	char *zp;
	int fh, ruid;
	static struct inode statb;
	static struct dirent dir;
	static char linkbuf[128], parentbuf[128];
	int i;

	errno = 0;	/* initialize error return value */
    for (i = 1; i < c; i++) {
	cp = v[i];
	lp = linkbuf;
	pp = parentbuf;
	zp = pp;
	while (*cp) {
		*pp++ = *cp;
		*lp++ = *cp;
		if (*cp++ == '/' && *cp != 0 && *cp != '/') zp = pp;
	}
	*zp = 0;
	*lp++ = '/';
	*lp++ = '.';
	*lp = 0;
	pp = parentbuf;
	if (*pp == 0) pp = ".";
	if (stat(pp, &statb) < 0) {
		perror(pp);
		continue;
	}
	ruid = getruid();
	if (ruid != IOWNER(statb)) statb.i_mode =<< 6;
	if (ruid != 0 && (statb.i_mode&(IWRITE|IEXEC)) != (IWRITE|IEXEC)) {
		errno = EACCES;
		perror(pp);
		continue;
	}
	cp = v[i];
	if ((fh = open(cp, 0)) < 0) {
		perror(cp);
		continue;
	}
	fstat(fh, &statb);
	if ((statb.i_mode&IFMT) != IFDIR) {
		errno = ENOTDIR;
		perror(cp);
		continue;
	}
	if (ruid != IOWNER(statb)) statb.i_mode =<< 6;
	if (ruid != 0 && (statb.i_mode&(IWRITE|IEXEC)) != (IWRITE|IEXEC)) {
		errno = EACCES;
		perror(cp);
		continue;
	}
	while (read(fh, &dir, sizeof dir) == sizeof dir) {
		if (dir.d_ino == 0) continue;
		if (dir.d_name[0] == '.' && (dir.d_name[1] == 0 ||
		    dir.d_name[1] == '.' && dir.d_name[2] == 0))
			continue;
		close(fh);
		errno = EINVAL;
		printf("%s: not empty\n", cp);
		goto cont2;
	}
	close(fh);
	if (unlink(linkbuf) < 0) {
		perror(linkbuf);
	}
	*lp++ = '.';
	*lp = 0;
	if (unlink(linkbuf) < 0) {
		perror(linkbuf);
	}
	if (unlink(cp) < 0) {
		perror(cp);
		continue;
	}
cont2:	;
    }
	exit(errno);
}
