#include "/h/stat.h"
#include "/h/errors.h"
main(c,v)
char **v;
{
	register char *cp, *lp, *pp;
	char *zp;
	int ruid;
	static struct inode statb;
	static char linkbuf[128], parentbuf[128];
	int i;

	errno = 0;	/* initialize error return value */
    for (i = 1; i < c; i++) {
	cp = v[i];
	lp = linkbuf;
	pp = parentbuf;
	zp = pp;
	while (*cp) {
		*pp++ = *cp;
		*lp++ = *cp;
		if (*cp++ == '/' && *cp != 0 && *cp != '/') zp = pp;
	}
	*zp = 0;
	*lp++ = '/';
	*lp++ = '.';
	*lp = 0;
	pp = parentbuf;
	if (*pp == 0) pp = ".";
	if (stat(pp, &statb) < 0) {
		perror(pp);
		continue;
	}
	ruid = getruid();
	if (ruid != IOWNER(statb)) statb.i_mode =<< 6;
	if (ruid != 0 && (statb.i_mode&(IWRITE|IEXEC)) != (IWRITE|IEXEC)) {
		errno = EACCES;
		perror(pp);
		continue;
	}
	cp = v[i];
	if (mknod(cp, 0140755, 0) < 0) {
		perror(cp);
		continue;
	}
	chown(cp, ruid);
	if (link(cp, linkbuf) < 0) {
		perror(linkbuf);
		continue;
	}
	*lp++ = '.';
	*lp = 0;
	if (link(pp, linkbuf) < 0) {
		perror(linkbuf);
		continue;
	}
    }
	exit(errno);
}
