#include "/h/libg.h"
#include "/h/times.h"
#include "/h/cinfo.h"
#include "/h/submit.h"
#include "/h/sgtty.h"
#include "/h/signals.h"
#include "/h/errors.h"

#define CNCT	5	/* cents per minute */
#define CPU	75	/* cents per minute */
#define SUBDISC 3	/* discount submit connect by this factor */
#define ALATIME	8	/* time between hangup-all and kill-all */

#define	SUID	1849	/* make sys be super uid */

/* bye		bsb dec 74
 *
 *	this pass simply gives the user his incurred
 *	expences, were the system billing for it.
 *
 *		update Feb 77
 */

struct	cinfo	infob;
int	id_father;

struct tbuffer timesb;

main(argc, argv)
char *argv[];
{
	register int j, i, uid;
	int submit;
	struct sgtty ttmode;
	long curtim, sysupt, cnctchrg, minutes, cpumins, cpuchrg;
	char status[2];
	extern killall();
	char *ttyname(), *timep;

	if((uid = getruid()) == 0) exit(0); /*ignore su's*/
	i = getcinfo(-1, &infob);
	if(getpid() != infob.c_pid)
		error("Not Father of Process Tree");
	submit = (*ttyname(i) == PTY_IND);

	kill(0, SIGHUP);	/* Hangup all children */
	signal(SIGALA, &killall);
	alarm(ALATIME);		/* Timeout for kill-all */
	do while ((i = wait(&status)) != -1) {
		type(1, "Process ");
		prndec(1, i);
		if ((status[0]&0177) == SIGKIL) type (1, " killed.\n");
		else type(1, " killed by hangup.\n");
	} while (errno != ECHILD);
	alarm(0);		/* Clear alarm. */

	time(&curtim);
	minutes = curtim - infob.c_ltime;
	if(minutes < 0)
		error("Negative Connect Time");
	minutes =* 100;
	minutes =/ 60;
	cnctchrg = (minutes * CNCT + 50) / 100;
	if(submit)	/* discount connect charge for submit */
		cnctchrg =/ SUBDISC;
	times(&timesb);
	cpumins = timesb.p_u_time + timesb.p_s_time +
		  timesb.c_u_time + timesb.c_s_time;
	cpumins =/ 36;
	cpuchrg = (cpumins * CPU + 50) / 100;

/*
 *		Have all the info... add into his record.
 */
	if(getubuf(uid) <= 0)
		error("Can't Read PERSONNE");
	u_buf.dol_used =+ cnctchrg+cpuchrg;
	u_buf.cnct_used =+ minutes;
	u_buf.cpu_used =+ cpumins;
	u_buf.accs_date = curtim;
	if(putubuf() < 0)
		type(1, "Can't Update PERSONNE\n");
/*
 *		tell guy the damage.
 */
	prnmin(minutes);
	type(1, " cnct mins =$");
	prnmin(cnctchrg);
	type(1, " and ");
	prnmin(cpumins);
	type(1, " cpu mins =$");
	prnmin(cpuchrg);
	type(1, " - to date =$");
	prnmin(u_buf.dol_used);
	type(1, "\n");
	timep = ctime(&curtim);
	timep[16] = 0;
	type(1, timep);
	type(1, timep+19);
	if(!submit) {
		gtty(1, &ttmode);
		sleep(6 - ttmode.sg_ospd/3);
		/* force hangup on dial up lines */
/* ##stt hold off on this...
/*		ttmode.sg_ispd = ttmode.sg_ospd = 0;
/*		stty(1, &ttmode);
 */
	}
}

prnmin(m)
long m;
{
	register int i,j;

	i = m%100;
	j = m/100;
	prndec(1, j);
	type(1, ".");
	if(i < 10) type(1, "0");
	prndec(1, i);
}

killall()
{
	/* Kill with SIGKIL if the alarm goes off */
	kill(0, SIGKIL);
}
