#

	/*
	 * ps ... taken to harvard version by jrs
	 * modified by FH 2.15.76 for increased speed
	 * Further mods for symbolic type out Forrest Howard, 3/15/76
	 *  much help from BSB
	 * Further speed improvements 4/12/76 by Peter Langston
	 *  much help from STT
	 *
	 * compile...
	 *	cc -O -n ps.c -lg -lh
	 * must live as a setuid program 
	 */

#include "/h/param.h"
#include "/h/proc.h"		/* defines proc[nproc] */
#include "/h/tty.h"		/* for wait addr on tty's */
char partab[1];			/* avoid undefined error on load */
#define NPGRP 1			/* avoid wasting space */
#include "/h/pgrp.h"		/* for pgrp stuff */

#define	p_bro	p_sig		/* usurp space for genetics */
#define	p_son	p_time
#define	p_list	p_cpu
#define NTTY	50
#define BUFSIZE 24		/* sizeof buffer */
#define FILSIZ 8		/* decimal */
#define INOSIZ 24		/* ditto -- save reading the "h"'s */

char	*stat	"?SWRIZP";
struct	proc	*maxproc;	/* the obvious */
struct	tty	*jttyp;
#define PROCSIZE (sizeof *maxproc)
#define TTYSIZE	(sizeof *jttyp)

struct {
	char n_name[8];
	int n_type, n_val;
} nl[] {
	"_proc",0,0, 	
	"_maxproc",0,0, 
	"_nswap",0,0, 		/* first three are always needed */
	"_buf",0,0,	
	"_kl11",0,0,	
	"_dh11",0,0,	
	"_bfreeli",0,0,
	"_lbolt",0,0,	
	"_lp11",0,0,	
	"_pc11",0,0,	
	"_tout",0,0,	
	"_execnt",0,0,
	"_runin",0,0,	
	"_runout",0,0,	
	"_ipc",0,0,
	"_file",0,0,
	"_inode",0,0,
	"_pgrps",0,0,
	"_log_q",0,0,
	0
};
#define PROC nl[0].n_val
#define MAXPROC nl[1].n_val
#define NSWAP nl[2].n_val
#define NOMORE nl[3].n_name[0]
#define BUF nl[3].n_val
#define KL11 nl[4].n_val
#define DH11 nl[5].n_val
#define BFREELIST nl[6].n_val
#define LBOLT nl[7].n_val
#define LP11 nl[8].n_val
#define PC11I nl[9].n_val+1
#define PC11O  nl[9].n_val+8
#define TOUT nl[10].n_val
#define EXECNT nl[11].n_val
#define RUNIN nl[12].n_val
#define RUNOUT nl[13].n_val
#define IPC nl[14].n_val
#define FILE nl[15].n_val
#define INODE nl[16].n_val
#define PGRPS nl[17].n_val
#define	LOG_Q	nl[18].n_val

char	aflg,lflg,mflg,nflg,oflg,pflg,qflg,rflg,uflg,vflg,wflg,xflg;
struct listel {
	char *l_ptr;
	int l_val;
	int l_seen;
};
struct listel lists[3][20];
int listsiz[3];
#define TERM 0
#define USER 1
#define PID 2
char	queue[NTTY+1];
int	maxqx;
char	lnamb[16];
char	*lnam;
/* the /dev/dat is a faster mem device, but limited to */
/* accessing the data space of the monitor */
/* addressing is identical to /dev/mem */
char	*datf	"/dev/dat";
char	*memf	"/dev/mem";
char	*depth	"               *                ";
char	 *ltims;
int	fh,maxpno,swap,dat,mem,mx,nswap,lowpri 10,hipri 40;
char	*nlogname;
char	*unix	"/unix";
int	mynumber;		/* will have pid */
/**/
main(argc,argv)
char *argv[];
{
	extern fout;
	register int	i;
	register struct proc *pp;
	register char *ap;
	int ln;

	for (i = 0; i <= NTTY; i++) {
		queue[i] = -1;
	}
	mynumber = getpid();
	fout= dup(1);
	ln = TERM;	/* initially collecting terminal names */
	argv++;
	while (--argc > 0){
		ap = *argv++;
		if (*ap++ == '-')
			while (*ap) switch(*ap++) {
			case 'a':	/* all attached to ttys */
				aflg++;
				mflg++;
				break;
			case 'k':	/* use desig core file */
				datf = memf = *argv++;
				argc--;
				break;
			case 'l':	/* long form */
				lflg++;
				break;
			case 'n':	/* specific user name */
				ln = USER;
				break;
			case 'N':	/* use desig namelist */
				unix = *argv++;
				argc--;
				break;
			case 'o':
				/* specify terminals */
				ln = TERM;
				break;
			case 'p':	/* only desig proc */
				ln = PID;
				uflg++;
				break;
			case 'q':	/* ignore maxproc (set to NPROC) */
				qflg++;
				break;
			case 'r':	/* use desig prio limits */
				uflg++;
				rflg++;
				mflg++;
				break;
			case 's':
				error("Flag 's' not implemented");
				break;
			case 'u':	/* show proc owners */
				uflg++;
				break;
			case 'v':	/* print maxproc */
				vflg++;
				break;
			case 'w':	/* w i d e  output */
				wflg++;
				lflg++;
				break;
			case 'x':	/* include tty-less procs */
				xflg++;
				mflg++;
				break;
			default :
				printf("\"%c\" ",*--ap);
				error("Unknown switch");
			}
		else {
			lists[ln][listsiz[ln]++].l_ptr = --ap;
			mflg++;
		}
	}
	/* if mflag off, include self on list of terms */
	if (!mflg) lists[TERM][listsiz[TERM]++].l_ptr = "tty";
	for (i = 0; i < listsiz[TERM]; i++) {
		lists[TERM][i].l_val = equal(lists[TERM][i].l_ptr, "sys")?
			0: ttynum(lists[TERM][i].l_ptr)+1;
	}
	for (i = 0; i < listsiz[USER]; i++)
		lists[USER][i].l_val = getunum(lists[USER][i].l_ptr);
	for (i = 0; i < listsiz[PID]; i++)
		lists[PID][i].l_val = atoi(lists[PID][i].l_ptr);
	if (wflg==0)
		NOMORE = 0;
	nlist(unix,nl);
	if (PROC == 0)
			error("No namelist");
	if ((mem = open(memf,0)) < 0)  
			error("No mem");
	if ((dat = open(datf,0)) < 0)  
			error("No dat");
	if ((swap = open("/dev/swp",0)) < 0)
			error("No swp");
	mx = datword(MAXPROC);
	nswap = datword(NSWAP);
	maxpno = ((mx - PROC) /(PROCSIZE)) + 1;
	seek(dat,PROC,0);
	if (vflg) printf("Maxproc = %d\n",maxpno);
	if (qflg) maxpno = NPROC;
	/* nice(-10)  { or spl7(), if you prefer } */
	read(dat,proc,maxpno*(PROCSIZE));
	maxproc = &proc[maxpno];
	for (i=0; i<=maxpno; i++)
		if (needed(i)) prcom(i);
	/* nice(+10)  { or spl0(), if you prefer } */
	mqueue();
	for (i = 0; i <= maxqx;i++) 
		action(queue[i],0,i);
	listerrs();
	flush();
	exit(0);
}
/**/
needed(pno)
{
	register char *tp;
	register int i;
	register struct proc *pp;
	struct { char *unsigned; };

	pp = &proc[pno];
	if (pp->p_stat == 0) return(0);
	i = pp->p_grp;
	if (i) i = (i - PGRPS)/(sizeof pgrps[0]) + 1;
	if (i.unsigned >= NTTY)
		error("pgrps out of wack");
	/* use '|' instead of '||' to get each sub called */
	/* otherwise will get spurious "ttyx: no processes" messages */
	if (in(pp->p_pid, PID)|in(i, TERM)|nuidchk(pp)) goto okay;
	if (rflg && (pp->p_pri<lowpri || pp->p_pri>hipri))
		goto okay;
	if (aflg && i!=0) goto okay;
	if (xflg && i==0) goto okay;
	return(0);

okay:
	if (i > maxqx) maxqx = i;
	tp = &queue[i];
	if (*tp != -1 && pp->p_ppid >= proc[*tp].p_ppid)
		tp = &(proc[*tp].p_list);
	pp->p_list = *tp;
	*tp = pno;
	pp->p_son = pp->p_bro = -1;
	return(1);
}

action(t,mode,tn)
{
	register char f,i;
	if (t == -1)
		return;
	i = mode;
	out(t, i, tn);
	action(proc[t].p_son,i + 1,tn);
	action(proc[t].p_bro,i,tn);
}

nuidchk(app)
struct proc *app;
{
	register struct proc *pp;
	register char *dadpid;		/* to force unsigned comparison */

	if (listsiz[USER] == 0) return(0);
	pp = app;
    recurs:
	if (in (pp->p_uid, USER)) return(1);
	if ((dadpid = pp->p_ppid) <= 1) return (0);
	for (pp = proc; pp < maxproc; pp++)
		if (pp->p_pid == dadpid) goto recurs;
	return (0);
}

mqueue()
{
	register int scan, next;
	int qi, i, dad, dad1;
	register struct proc *pp;

	for (i=0; i<=maxqx; i++) {
		if ((next = qi = queue[i]) < 0) continue;
		dad1 = proc[next].p_ppid;
		while ((next = proc[next].p_list) >= 0) {
			if ((dad=proc[next].p_ppid) != dad1) {
				for (scan=qi; scan>=0; scan=pp->p_list) {
					pp = &proc[scan];
					if (pp->p_pid != dad) continue;
					proc[next].p_bro = pp->p_son;
					pp->p_son = next;
					break;
				}
				if (scan >= 0) continue;
			}
			/* put on top-level bro list */
			proc[next].p_bro = proc[qi].p_bro;
			proc[qi].p_bro = next;
		}
	}
}

prcom(pno)
{
	int  laddr, mf;
	char *baddr;
	register char *ip, c;
	int	i;
	register struct proc *pp;
	char stbuf[514];

	pp = &proc[pno];
	if ((c = pp->p_flag)&SSYS) {
		pp->p_addr = "Sched";
		return;
	}
	if (pp->p_pid==mynumber){
		pp->p_addr= "***Systat***";
		return;
	}
	if (pp->p_stat==SZOMB) {
		pp->p_addr = "***zombie***";
		return;
	}
	baddr = 0;
	laddr = 0;
	if (c & SLOAD) {
		laddr = pp->p_addr;
		mf = mem;
	} else {
		baddr = pp->p_addr;
		mf = swap;
	}
	laddr =+ pp->p_size - 8;
	baddr =+ laddr>>3;
	laddr = (laddr&07)<<6;
	if (!(c&SLOAD))
		if (baddr > nswap) {
			pp->p_addr = "***addr err***";
			return;
		}
	seek(mf, baddr, 3);
	seek(mf, laddr, 1);
	pp->p_addr = "***oops***";
	if (read(mf, stbuf, 512) != 512)
		return;
	stbuf[512] = 0;
	i = 0;
	for (ip = &stbuf[512]; (c = *--ip) != -1; ) {
		if (ip <= stbuf) return;	/* oops! */
		if (c == 0) *ip = ' ';
		else if (c < ' ' || c > 0176) {
			i++;
			*ip = '?';
		}
	}
	ip++;
	if ((laddr = &stbuf[512] - ip) > i*8) {
		if (!wflg && laddr>32) {
			laddr = 32;
			ip[32] = 0;
		}
		pp->p_addr = getcore(laddr+1);
		copy (ip, pp->p_addr);
	} else
		pp->p_addr = "***garbage***";
	return;
}

getcore(size)
{
	static int core;
	static char *corep;
	register char *cp;
	register int more;

	if (corep == 0) corep = sbrk(0);
	if (size > core) {
		more = (size & ~1023) + 1024;
		sbrk(more);
		core =+ more;
	}
	cp = corep;
	corep =+ size;
	core =- size;
	return(cp);
}

copy(from_p,to_p)
char *from_p, *to_p;
{
	register char *cp1, *cp2;

	cp1 = from_p; cp2 = to_p;
	while (*cp2++ = *cp1++);
	return(cp2);
}


error(sstring)
char	*sstring;
{
	register char *cp, *string;

	flush();
	cp=string=sstring;
	while (*cp++);
	if ((--cp)!=string) {
		*cp++ = '\n';
		write(2,string,cp-string);
	}
	exit(1);
}

out(p,mode,tn)
{
	char *cp, t;
	register int size1,size2;
	register struct proc *pp;

	pp = &proc[p];
	if (vflg) printf("%-3d ",p);
	/* simulate extra level */
	if (pp->p_grp == 0 && pp->p_pid != 0) mode++;
	if (mode == 0 || uflg) lnam = getlogn(pp->p_uid);
	else lnam = &depth[mode>16 ? 0 : 16-mode];
	printf("%-6s", mode? "": tn==0? "sys":
	    ttyname(tn-1));
	printf((uflg|wflg)?" %-16.16s": " %-8.8s", lnam);
	if (lflg) {
		pp->p_flag =& ~SSYS;	/* remove sys bit, only proc0 has it */
		if (pp->p_flag& ~SLOAD)
			printf("%3o",pp->p_flag& ~SLOAD);
		else
			if(superpop(pp))
				printf("  +");
			else
				printf("   ");
		printf("%c",pp->p_flag&SLOAD?'*':' ');
		printf("%c",stat[pp->p_stat]);

		printf("%5d",pp->p_pri);
		size1 = pp->p_size >>5;
		size2 = ((pp->p_size%32)*10)/32;
		printf("%3d.%1dk",size1,size2);
	}
	if (wflg) {
		cp = outwait(pp->p_wchan);
		if (cp) printf(" %-6.6s",cp);
		else printf(" %6o",pp->p_wchan);
	}
	printf("%6.l",pp->p_pid);
	printf(wflg ? " %s\n" : " %.32s\n", pp->p_addr);
}

outwait(ww,pp)
char	*ww;
struct proc *pp;
{

	register char *a,*w;
	register char *i;

	a=0;		/* a will be set to string if it exists */
	if ((w=ww) == 0) return("       ");
			/* n.b. sizeof proc = nproc*PROCSIZE */
	if (w >= PROC && w < (PROC+sizeof proc)) return("child ");
	if (w >= BUF && w < (NBUF*BUFSIZE)+BUF) return("buffer");
	if (w >= FILE && w < FILE+(FILSIZ*NFILE)) return("file  ");
	if (w >= INODE && w < INODE+(INOSIZ*NINODE)) return("inode ");
	if (w >= KL11 && w < KL11+TTYSIZE) w =+ (DH11-KL11);
	if (w >=DH11 && w < DH11+(TTYSIZE*NTTY)) {
		if ((i=(w-DH11)%TTYSIZE) == &0->t_delct) return("ttyin ");
		if (i == &0->t_outq) return("ttyout");
		if (i == &0->t_rawq) return("ttyslp");
		return("tty???");
	}
	if (w == PC11O) return("ptp   ");
	if (w == PC11I) return("ptr   ");
	if (w == LBOLT) return("lbolt ");
	if (w == RUNIN) return("runin ");
	if (w == RUNOUT) return("runout");
	if (w == TOUT) return("sleep ");
	if (w == LP11) return("lpt   ");
	if (w == IPC) return("ptrace");
	if (w == BFREELIST) return("bfree ");
	if (w == EXECNT) return("exec  ");
	if(w == LOG_Q) return("log_q ");
	return(0);
}

in(val, ln)
{
	register i;
	register struct listel *lp;

	lp = lists[ln];
	for (i = listsiz[ln]; --i >= 0; lp++) {
		if (val == lp->l_val) {
			lp->l_seen++;
			return(1);
		}
	}
	return (0);
}

listerrs()
{
	register i, j;
	register struct listel *lp;

	for (i = TERM; i <= PID; i++) {
		lp = lists[i];
		for (j = listsiz[i]; --j >= 0; lp++) {
			if (lp->l_val == -1) switch(i) {
			case TERM:
				printf("%s: no such terminal\n",lp->l_ptr);
				break;
			case USER:
				printf("%s: no such user\n",lp->l_ptr);
				break;
			}
			else if (lp->l_seen == 0) switch(i) {
			case TERM:
			case USER:
				printf("%s: no processes\n",lp->l_ptr);
				break;
			case PID:
				printf("pid %d: not found\n",lp->l_val);
				break;
			}
		}
	}
}

datword(addr)
{
	static int w;

	seek(dat,addr,0);
	read(dat,&w,2);
	return(w);
}

superpop(ap)
struct proc *ap;
{
	char spid;
	register struct pgrp *g;

	g = ap->p_grp;
	if (g) {
		seek(dat, &g->pg_pid, 0);
		read(dat, &spid, 1);
		if (spid == ap->p_pid) return(1);
	}
	return(0);
}
