#define SVLEN 64
#define SVFILE "/save.txt"
#define SBLEN 20	/* enough to get uid */
#define SVMOD 0666	/* read/write from anywhere */
#define SVKILL '-'	/* indicates delete */

main(argc,argv)
char **argv;
{
	register char c, *cp, *svcp;
	char buf[SVLEN];
	static int svfh, svcnt;

	if (argc == 2 || argc > 3)
		error("use: save <string> <char> (see help save)");
	svcp = cat(getpath(getluid()),SVFILE);
	/* if no args, display saved macros */
	if (argc == 1) goto displsave;
	if ((svfh=open(svcp,1))<0 && (svfh=creat(svcp,SVMOD))<0)
		error ("can't open/create macro save file");
	argv++;
	cp = *argv++;
	svcp = cp;
	while(*cp++);	/* count length of string */
	svcnt = cp-svcp;	/* length includes null at end */
	if (svcnt > SVLEN) error("save string limited to 63 chars");
	/* a single '-' means delete current def of macro */
	if(svcnt == 2 && *svcp == SVKILL) *svcp = 0;
	cp = *argv++;
	while (c = *cp++) {
		/* if not doing a delete, only one letter allowed */
		if (*svcp != 0 && *cp != 0)
			error("macro name must be single letter");
		if (c == '-') continue;
		do {
			if (c < 'a' || c > 'z')
				error("macro names must be alphabetic");
			seek(svfh, (c-'a')*SVLEN, 0);
			write(svfh, svcp, svcnt);
		/* allows construction "a-z" on delete */
		} while (cp[0] == '-' && ++c < cp[1]);
	}
	exit(0);

displsave:
	if ((svfh=open(svcp,0))<0)
		error("no macro save file");
	for (c = 'a'; c <= 'z' && read(svfh, buf, SVLEN) > 0; c++) {
		if (buf[0] != 0) {
			printf("$%c	%s\n",c,buf);
			svcnt++;
		}
	}
	printf("%d saved shell macro%s.\n",svcnt, svcnt==1?"":"s");
	exit(0);
}
