#
/*#define MONITOR 2	*/
#define	SBSIZE	2000
char	sbf[SBSIZE];		/* string storage for defines */
/* C command */

#define TMPFILE "ctm0a"
#define TMPLEN 5	/* length of tmpfile name */
char *tmp0;		/* used to find first open file slot */
char *tmp1;		/* immediate code from c0 */
char *tmp2;		/* string storage from c0 */
char *tmp3;		/* code from c1 */
char *tmp4;		/* output from preprocesser */
char *tmp5;		/* output from optimizer */

char ts[512];		/* monitor buffer */
char *tsp ts;

char *av[50];		/* arg storage for callsys */
char *clist[50];		/* storage for '.c' filenames */
char *llist[50];		/* storage for loader args */
char tmpbuf[50];		/* buf for macro argument */
int instring;		/* flag for strings */
char pflag;		/* macro prepass flag */
char sflag;		/* assembler pass flag (cflag++ also) -- no load */
char cflag;		/* compiler pass 0/1 -- no load */
char oflag;		/* optimzer pass c2 */
char mflag;		/* produce macro output */
char m1flag;		/* special optimized macro output */
char tflag;		/* save temps */
char fflag;		/* produce output as file ??? */
char vflag;		/* verbose mode */
char proflag;		/* profiler load */
char errflg;		/* non-zero --> exit(-1) */
int depth;		/* define recursion depth */
int *ibuf;		/* current input buffer via getc() */
int *ibuf1;		/* input file buffer -- level 1 */
int *ibuf2;		/* input file buffer -- level 2 */
int *obuf;		/* current output file buffer via putc() */
char *lp;
char *line;
int lineno;		/* line number within file from inbuf1 */
int exfail;		/* number of errors */
struct symtab {
	char name[8];
	char *value;
} *symtab;
int symsiz 500;		/* symbol table size..change c0.h also */
#define SYMSIZ 500
struct symtab *defloc;	/* define symbol */
struct symtab *incloc;	/* include symbol */
struct symtab *eifloc;	/* if symbol */
struct symtab *ifdloc;	/* ifdef symbol */
struct symtab *ifnloc;	/* ifndef symbol */
struct symtab *unxloc;	/* unix symbol */
int	trulvl;		/* true level to conditional if's */
int	flslvl;		/* false level to conditional if's */
char *stringbuf;
char *pass0 "/sys/c/v6_comp/c0";
char *pass1 "/sys/c/v6_comp/c1";
char *pass2 "/sys/c/v6_comp/c2";
char *passm2 "/sys/c/bin/v6mc2";	/* macro output */
					/* with 11/little hook of
					   ashn and ashcn */
char *pref "/sys/c/v6_comp/crt0.o";
#define LIBC "/lib/nlibc.a"
#define LIBA "/lib/nliba.a"
#define MCRT "/sys/c/bin/v6mcrt0.o"
#define AS "/bin/v6as"
#define LD "/bin/ld"
/* prefix for 'h' switch, and loc of 'x' in string */
#define SPCLPRFX "/lib/xcrt0.o"
#define SPFX 5

/* define types of subroutines */
char *expand();struct symtab *lookup();
char *setsuf();char *copy();

main(argc, argv)
char *argv[]; {
	register char *t;
	int i, nc;
	int  nl, j, c, nxo, monf, tvec[2], nbytes, tf;
	int dexit();
	register char *cp,*cp1;

	i = nc = nl = nxo = 0;
/*	if(getperm(getuid() & 0377) & MONITOR)
		monf = open("/usr/adm/.cmon",1);
	else monf = 0;
*/
	while(++i < argc) {
		t = argv[i];
		if(*t == '-')
			switch (t[1]) {
				default:
					goto passa;	/* add to load list */

				case 'T':	/* save temps */
					tflag++;
					break;

				case 'V':	/* verbose */
					vflag++;
					break;
				case 'Q':	/* run one pass only */
					if(t[2] != ':') {
						printf("q flag error\n");
						exit(-1);
					}
					exit(callsys(&t[3],&argv[i]));
					break;

				case 'M':	/* macro output--upper case */
					if(t[2] == '1') 
						m1flag++;
					else mflag++;	/* do macro */
					oflag++;	/* call pass 2 */
					cflag++;	/* no load */
					break;

				case 'S':		/* assembler output */
					sflag++;
					cflag++;
					break;
				case 'O':	/* optimize output */
					oflag++;
					break;
				case 'p':	/* profile */
					proflag++;
					pref = MCRT;
					break;
				case 'P':	/* prepass only */
					pflag++;
				case 'c':	/* compiler output only */
					cflag++;
					break;

				case 'f':	/* output to given file */
					if(t[2] != ':') {
						printf("f switch error\n");
						exit(-1);
					}
					llist[nl++] = t;
					fflag++;
					break;
				case 'h':	/* specify run-time header */
					if (t[2] != '\0') {
						pref = copy(SPCLPRFX);
						pref[SPFX] = t[2];
					} else {
						/* whole name specified */
						pref = argv[++i];
					}
					break;
			}
		else {
			c = getsuf(t);
			if (c == 'c') {
/*				if(monf) {
					seek(monf,0,2);
					write(monf,t,len(t));
					write(monf," ",1);
					time(tvec);
					write(monf,ctime(tvec),25);
					tf = open(t,0);
					while(nbytes = read(tf,ts,512))
						write(monf,ts,nbytes);
					close(tf);
					write(monf,"N",1);
				}
*/
				clist[nc++] = t;
				if(vflag)
					printf("clist[%d] : %s\n",nc-1,t);
				t = setsuf(t, 'o');
				c = 'o';
				nxo++;
			} else if (c == 'o') {
				nxo++;
			}
			if (c != 'o' || nodup(llist, t)) {
			passa:
				llist[nl++] = t;
				if(vflag) printf("llist[%d] : %s\n",nl-1,t);
			}
		}
	}
	if(nc==0)
		goto nocom;
	if (pflag==0) {
		tmp0 = copy(TMPFILE);
		while((c=open(tmp0, 0))>=0) {
			close(c);
			tmp0[TMPLEN-1]++;
		}
		if((c = creat(tmp0, 0400))<0) {
			printf("can't creat temp file\n");
			exit(-1);
		}
		close(c);
	}
	if ((signal(2, 1) & 01) == 0)
		signal(2, &dexit);
	(tmp1 = copy(tmp0))[TMPLEN-2] = '1';
	(tmp2 = copy(tmp0))[TMPLEN-2] = '2';
	(tmp3 = copy(tmp0))[TMPLEN-2] = '3';
	if (oflag)
		(tmp5 = copy(tmp0))[TMPLEN-2] = '5';
	if (pflag==0)
		(tmp4 = copy(tmp0))[TMPLEN-2] = '4';
	errflg = 0;
	for (i=0; i<nc; i++) {
		if(nc > 1)
			printf("%s:\n", clist[i]);
		av[0] = "c0";
		if (pflag)
			tmp4 = setsuf(clist[i], 'i');
		av[1] = expand(clist[i]);
		if (exfail || av[1] == 0) {
			errflg++;
			continue;
		}
		if (pflag)
			continue;
		av[2] = tmp1;
		av[3] = tmp2;
		if (proflag) {
			av[4] = "-P";
			av[5] = 0;
		} else
			av[4] = 0;
		if(vflag) printf("c0 : %s %s %s %s\n",
		 av[1],av[2],av[3],av[4]?"profile\n":"\n");
		if (callsys(pass0, av)) {
			errflg++;
			continue;
		}
		av[0] = "c1";
		av[1] = tmp1;
		av[2] = tmp2;
		if (sflag)
			tmp3 = setsuf(clist[i], 's');
		av[3] = tmp3;
		if (oflag)
			av[3] = tmp5;
		av[4] = 0;
		if(vflag) printf("c1 : %s %s %s\n",av[1],av[2],av[3]);
		if(callsys(pass1, av)) {
			errflg++;
			continue;
		}
		if (mflag) {		/* macro pass */
			cp1 = clist[i];
			cp = tmpbuf;
			while(*cp = *cp1++) if (*cp++ == '.') break;
			--cp;
			for(cp1 = ".m11"; *cp++ = *cp1++; );
			t = tmpbuf;
			cunlink(t);
			av[0] = "mc2";
			av[1] = tmp5;
			av[2] = t;
			av[3] = 0;
			if(vflag) printf("mc2 : %s %s\n",av[1],av[2]);
			callsys(passm2,av);
			unlink(tmp5);
			continue;
		}
		if (oflag) { 
			av[0] = "c2";
			av[1] = tmp5;
			av[2] = tmp3;
			if(m1flag) {
				av[3] = "-m1";
				av[4] = 0;
			}
			else	av[3] = 0;
			if(vflag) printf("c2 : %s %s\n",av[1],av[2]);
			callsys(pass2, av);
			unlink(tmp5);
		}
		if (sflag)
			continue;
		cp = tmpbuf;
		for(cp1="-f:"; *cp++ = *cp1++; );
		cp--;
		t = cp1 = setsuf(clist[i], 'o');
		while(*cp++ = *cp1++);
		av[0] = "as";
		av[1] = tmpbuf;
		av[2] = "-";
		av[3] = tmp3;
		av[4] = 0;
		cunlink(tmp1);
		cunlink(tmp2);
		cunlink(tmp4);
		cunlink(t);
		if(vflag) printf("as : %s %s\n",av[1],av[3]);
		callsys(AS, av);
	}
nocom:
	if (errflg == 0 && cflag==0 && nl!=0) {
		av[0] = "ld";
		av[1] = "-X";
		av[2] = pref;
		j = 3;
		printf("[loading]\n");
		if(fflag == 0) {
			cp = tmpbuf;
			for(cp1 = "-f:"; *cp++ = *cp1++; );
			cp--;
			if(nc) cp1 = clist[0];
			else {
				for (i = 0; *(cp1 = llist[i]) == '-'; i++);
			}
			while (*cp = *cp1++) if (*cp++ == '.') break;
			--cp;
			for(cp1 = ".out"; *cp++ = *cp1++; );
			j = 4;
			av[3] = tmpbuf;
		}
		for (i = 0; i < nl; i++) {
			av[j] = llist[i];
			if(vflag) printf("%s ",av[j]);
			j++;
		}
		av[j++] = LIBC;
		av[j++] = LIBA;
		if(vflag) printf("%s %s\n",av[j-2],av[j-1]);
		av[j++] = 0;
		if (callsys(LD, av) != 0) errflg++;
		else if (nc == 1 && nxo == 1)
			cunlink(setsuf(clist[0], 'o'));
	}
	dexit();
}

dexit()
{
	if (!pflag && !tflag) {
		cunlink(tmp1);
		cunlink(tmp2);
		if (sflag==0)
			cunlink(tmp3);
		cunlink(tmp4);
		cunlink(tmp5);
		cunlink(tmp0);
	}
	exit(errflg? -1: 0);
}

char *
expand(file)
char *file;
{
	int ib1[259], ib2[259], ob[259];
	struct symtab stab[SYMSIZ];
	char ln[196];
	register int c;
	register char *rlp;

	exfail = 0;
	ibuf = ibuf1 = ib1;
	ibuf2 = ib2;
	if (fopen(file, ibuf1)<0)
		return(file);
	if (getc(ibuf1) != '#') {
		close(ibuf1[0]);
		return(file);
	}
	ibuf1[1]++;
	ibuf1[2]--;
	obuf = ob;
	symtab = stab;
	for (c=0; c<symsiz; c++) {
		stab[c].name[0] = '\0';
		stab[c].value = 0;
	}
	insym(&defloc, "define");
	insym(&incloc, "include");
	insym(&eifloc, "endif");
	insym(&ifdloc, "ifdef");
	insym(&ifnloc, "ifndef");
	insym(&unxloc, "unix");
	stringbuf = sbf;
	trulvl = 0;
	flslvl = 0;
	line  = ln;
	lineno = 0;
	if (fcreat(tmp4, obuf) < 0) {
		printf("Can't creat %s\n", tmp4);
		dexit();
	}
	while(getline()) {
		if (ibuf==ibuf2 && pflag==0)
			putc(001, obuf);	/*SOH: insert */
		if (ln[0] != '#' && flslvl==0)
			for (rlp = line; c = *rlp++;)
				putc(c, obuf);
		putc('\n', obuf);
	}
	for(rlp=line; c = *rlp++;)
			putc(c,obuf);
	fflush(obuf);
	close(obuf[0]);
	close(ibuf1[0]);
	return(tmp4);
}

getline()
{
	register int c, sc, state;
	struct symtab *np;
	char *namep, *filname;

	if (ibuf==ibuf1)
		lineno++;
	lp = line;
	*lp = '\0';
	state = 0;
	if ((c=getch()) == '#')
		state = 1;
	while (c!='\n' && c!='\0') {
		if ('a'<=c && c<='z' || 'A'<=c && c<='Z' || c=='_') {
			namep = lp;
			sch(c);
			while ('a'<=(c=getch()) && c<='z'
			      ||'A'<=c && c<='Z'
			      ||'0'<=c && c<='9' 
			      ||c=='_')
				sch(c);
			sch('\0');
			lp--;
			if (state>3) {
				if (flslvl==0 &&(state+!lookup(namep,-1)->name[0])==5)
					trulvl++;
				else
					flslvl++;
		out:
				while (c!='\n' && c!= '\0')
					c = getch();
				return(c);
			}
			if (state!=2 || flslvl==0)
				{
				ungetc(c);
				np = lookup(namep, state);
				c = getch();
				}
			if (state==1) {
				if (np==defloc)
					state = 2;
				else if (np==incloc)
					state = 3;
				else if (np==ifnloc)
					state = 4;
				else if (np==ifdloc)
					state = 5;
				else if (np==eifloc) {
					if (flslvl)
						--flslvl;
					else if (trulvl)
						--trulvl;
					else error("If-less endif");
					goto out;
				}
				else {
					error("Undefined control");
					while (c!='\n' && c!='\0')
						c = getch();
					return(c);
				}
			} else if (state==2) {
				if (flslvl)
					goto out;
				np->value = stringbuf;
				savch(c);
				while ((c=getch())!='\n' && c!='\0')
					savch(c);
				savch('\0');
				return(1);
			}
			continue;
		} else if ((sc=c)=='\'' || sc=='"') {
			sch(sc);
			filname = lp;
			instring++;
			while ((c=getch())!=sc && c!='\n' && c!='\0') {
				sch(c);
				if (c=='\\')
					sch(getch());
			}
			instring = 0;
			if (flslvl)
				goto out;
			if (state==3) {
				if (flslvl)
					goto out;
				*lp = '\0';
				while ((c=getch())!='\n' && c!='\0');
				if (ibuf==ibuf2)
					error("Nested 'include'");
				if (fopen(filname, ibuf2)<0)
					error("Missing file %s", filname);
				else
					ibuf = ibuf2;
				return(c);
			}
		}
		sch(c);
		c = getch();
	}
	sch('\0');
	if (state>1)
		error("Control syntax");
	return(c);
}

insym(sp, namep)
struct symtab **sp;
char *namep;
{
	register struct symtab *np;

	*sp = np = lookup(namep, 1);
	np->value = np->name;
}

error(s, x)
{
	printf("%d: ", lineno);
	printf(s, x);
	putchar('\n');
	exfail++;
	cflag++;
}

sch(c)
{
	register char *rlp;

	rlp = lp;
	if (rlp==line+194)
		error("Line overflow");
	*rlp++ = c;
	if (rlp>line+195)
		rlp = line+195;
	lp = rlp;
}

savch(c)
{
	*stringbuf++ = c;
	if (stringbuf-sbf < SBSIZE)
		return;
	error("Too much defining");
	dexit();
}

getch()
{
	register int c;

loop:
	if ((c=getc1())=='/' && !instring) {
		if ((c=getc1())!='*')
			{
			ungetc(c);
			return('/');
			}
		for(;;) {
			c = getc1();
		cloop:
			switch (c) {

			case '\0':
				return('\0');

			case '*':
				if ((c=getc1())=='/')
					goto loop;
				goto cloop;

			case '\n':
				if (ibuf==ibuf1) {
					putc('\n', obuf);
					lineno++;
				}
				continue;
			}
		}
	}
	return(c);
}
char pushbuff[300];
char *pushp pushbuff;
ungetc(c)
	{
	*++pushp = c;
	}

getc1()
{
	register c;

	if (*pushp !=0)
		return(*pushp--);
	depth=0;
	if ((c = getc(ibuf)) < 0 && ibuf==ibuf2) {
		close(ibuf2[0]);
		ibuf = ibuf1;
		putc('\n', obuf);
		lineno++;
		c = getc1();
	}
	if (c<0)
		return(0);
	return(c);
}

struct symtab *
lookup(namep, enterf)
char *namep;
{
	register char *np, *snp;
	register struct symtab *sp;
	int i, c, around;
	np = namep;
	around = i = 0;
	while (c = *np++)
		i =+ c;
	i =% symsiz;
	sp = &symtab[i];
	while (sp->name[0]) {
		snp = sp;
		np = namep;
		while (*snp++ == *np)
			if (*np++ == '\0' || np==namep+8) {
				if (!enterf)
					subst(namep, sp);
				return(sp);
			}
		if (++sp >= &symtab[symsiz])
			if (around++)
				{
				error("too many defines");
				dexit();
				}
			else
			sp = symtab;
	}
	if (enterf>0) {
		snp = namep;
		for (np = &sp->name[0]; np < &sp->name[8];)
			if (*np++ = *snp)
				snp++;
	}
	return(sp);
}
char revbuff[200];
char	*bp;
backsch(c)
	{
	if (bp-revbuff > 200)
		error("Excessive define looping", bp--);
	*bp++ = c;
	}

subst(np, sp)
char *np;
struct symtab *sp;
{
	register char *vp;

	lp = np;
	bp = revbuff;
	if (depth++>100)
		{
		error("define recursion loop\n");
		return;
		}
	if ((vp = sp->value) == 0)
		return;
	/* arrange that define unix unix still
	has no effect, avoiding rescanning */
	if (streq(sp->name,sp->value))
		{
		while (*vp)
			sch(*vp++);
		return;
		}
	backsch(' ');
	if (*vp == '(')
		expdef(vp);
	else
	while (*vp)
		backsch(*vp++);
	backsch(' ');
	while (bp>revbuff)
		ungetc(*--bp);
}

getsuf(as)
char as[];
{
	register int c;
	register char *s;
	register char t;

	s = as;
	c = 0;
	while(t = *s++)
		if (t=='/')
			c = 0;
		else
			c++;
	s =- 3;
	if (c<=14 && c>2 && *s++=='.')
		return(*s);
	return(0);
}

char *
setsuf(as, ch)
char as[];
{
	register char *s, *s1;

	s = s1 = copy(as);
	while(*s)
		if (*s++ == '/')
			s1 = s;
	*--s = ch;
	return(s1);
}

callsys(f, v)
char f[], *v[]; {
	int t, status;

	if ((t=fork())==0) {
		execv(f, v);
		printf("Can't find %s\n", f);
		exit(1);
	} else
		if (t == -1) {
			printf("Fork failure on %s : Try again\n",f);
			return(1);
		}
	while(t!=wait(&status));
	if ((t=(status&0377)) != 0 && t!=14) {
		if (t!=2)		/* interrupt */
			printf("Fatal error in %s\n", f);
		dexit();
	}
	return((status>>8) & 0377);
}

char *
copy(as)
char as[];
{
	register char *otsp, *s, *rtsp;

	otsp = tsp;
	rtsp = otsp;
	s = as;
	while(*rtsp++ = *s++);
	tsp = rtsp;
	return(otsp);
}

nodup(al, os)
char **al, *os;
{
	register char *t, *s;
	register char **l;

	if (getsuf(os) != 'o')
		return(1);
	for (l = al; t = *l++; ) {
		for (s = os; *s++ == *t; )
			if (*t++ == '\0') return (0);
	}
	return(1);
}

cunlink(f)
char *f;
{
	if (f==0)
		return(0);
	return(unlink(f));
}

expdef(proto)
  char *proto;
{
	char buffer[100], *parg[20], *pval[20], name[20], *cspace, *wp;
	char protcop[100], *pr;
	int narg, k, i, c;
	pr = protcop;
	while (*pr++ = *proto++);
	proto= protcop;
	for (narg=0; (parg[narg] = token(&proto)) != 0; narg++)
		;
	/* now scan input */
	cspace = buffer;
	while ((c=getch()) == ' ');
	if (c != '(')
		{
		error("defined function requires arguments");
		return;
		}
	ungetc(c);
	for(k=0; pval[k] = coptok(&cspace); k++);
	if (k!=narg)
	 {
	  error("define argument mismatch");
	  return;
	 }
	while (c= *proto++)
	   {
	   if (!letter(c))
	      backsch(c);
	   else
	      {
	      wp = name;
	      *wp++ = c;
	      while (letnum(*proto))
	        *wp++ = *proto++;
	      *wp = 0;
	      for (k=0; k<narg; k++)
	      if(streq(name,parg[k]))
	        break;
	      wp = k <narg ? pval[k] : name;
	      while (*wp) backsch(*wp++);
	      }
	   }
}

token(cpp) char **cpp;
{
	char *val;
	int stc;
	stc = **cpp;
	*(*cpp)++ = '\0';
	if (stc==')') return(0);
	while (**cpp == ' ') (*cpp)++;
	for (val = *cpp; (stc= **cpp) != ',' && stc!= ')'; (*cpp)++)
	  {
	  if (!letnum(stc) || (val == *cpp && !letter(stc)))
	    {
	    error("define prototype argument error");
	    break;
	    }
	  }
	return(val);
}

coptok (cpp) char **cpp; {
	char *val;
	int stc, stop,paren;
	paren = 0;
	val = *cpp;
	if (getch() == ')')
	  return(0);
	while (((stc = getch()) != ',' && stc != ')') || paren > 0)
	  {
	  if (stc == '"' || stc == '\'')
	    {
	    stop = stc;
	    if (stop == '\'')
	      *(*cpp)++ = '\'';
	    while ( (stc = getch()) != stop)
	      {
	      if (stc == '\n')
	        {
	        error ("non-terminated string");
	        break;
	        }
	      if (stc == '\\')
	        if ((stc= getch()) != stop && stc != '\\')
	          *(*cpp)++ = '\\';
	      *(*cpp)++ = stc;
	      }
	    if (stop == '\'') 
	      *(*cpp)++ = '\'';
	    }
	  else if (stc == '\\')
	      {
	      stc = getch();
	      if (stc != '"' && stc != '\\')
	        *(*cpp)++ = '\\';
	      *(*cpp)++ = stc;
	      }
	  else
	    {
	    *(*cpp)++ = stc;
	    if (stc == '(')
	        paren++;
	    if (stc == ')')
	        paren--;
	    }
	  }
	*(*cpp)++ = 0;
	ungetc(stc);
	return(val);
}

letter(c)
{
	if ((c >= 'a' && c <= 'z') ||
	    (c >= 'A' && c <= 'Z') ||
	    (c == '_'))
	    return (1);
	else
	    return(0);
}

letnum(c)
{
	if (letter(c) || (c >= '0' && c <= '9'))
	  return(1);
	else
	  return(0);
}

streq(s,t) char *s, *t;
{
	register char *rs, *rt;

	rs = s; rt = t;
	while (*rs++ == *rt)
		if (*rt++ == 0) return(1);
	return(0);
}
