#

/*
 * Editor
 */

#define	SIGHUP	1
#define	SIGINTR	2
#define	SIGQUIT	3
#define	FNSIZE	64
#define	LBSIZE	512
#define	ESIZE	128
#define	GBSIZE	256
#define	NBRA	5
#define	EOF	-1
#define	CBRA	1
#define	CCHR	2
#define	CDOT	4
#define	CCL	6
#define	NCCL	8
#define	CDOL	10
#define	CEOF	11
#define	CKET	12
#define	CMIN	14
#define	STAR	01
#define	error	goto errlab
#define	READ	0
#define	WRITE	1

int	alt	0;	/* alternate command input file */
int	*deleted    0;    /* pointer to deleted line pointers */
int	ndeleted    0;    /* number of lines */
int	peekc;
int	lastc;
char	savedfile[FNSIZE];
char	tempfile[FNSIZE];
char	altfile[FNSIZE];
char	file[FNSIZE];
char	linebuf[LBSIZE];
char	agbuf[LBSIZE];	/* save area for "again" command */
char	rhsbuf[LBSIZE/2];
char	expbuf[ESIZE+4];
char	line[70];
char	*linp	line;
int	circfl;
int	*zero;
int	*dot;
int	*dol;
int	brcount	1; /* number of lines to output on "newline" command */
int	num;
int	*endcore;
int	*fendcore;
int	line_num;	/* integer for line number on output */
char	*fmtlno	" %6l="; /* format for line-number output */
char	*hupcom "w ned.saves\n";  /* command executed on hangup */
int	*addr1;
int	*addr2;
char	genbuf[LBSIZE];
int	count[2];
char	*e_prompt ">";	/* editor command prompt */
int	prompt1	 1;/*flag--enable or disable line-num prompts */
int	prompt2  1;  /* flag--enable or disable ALL prompting */
int	text_modified  0; /* flag--on if text was modified */
int	globf2  0;	/* kludge for "-f"  */
int	num_reads  0;	/* indicator to aid text_modified--   */
				/* first read isn't really a modify */
char	*nextip;
char	*linebp;
int	ninbuf;
int	io;
int	doc  0;  /* kludge for "help"  */
int	pflag;
int	eflg;	/* echo input flag */
int	eflg2;	/* another kludge */
int	sav_prompt2;	/* and once more ... */
int	fflg;	/* "file" flag */
int	aflg;	/* "apl mode" flag */
int	tflg;	/* tracing flag */
int	bflg;	/* "back-up" flag -- Generate back-up file */
int	bflg2;	/* Secondary "back-up" flag */
int	iflg;	/* Emergency exit on interrupt flag */
int	vflg  1;	/* Verify flag */
int	reading 0;	/* waiting on read */
int	hupflag 0;
int	onhup;
int	onquit;
int	listf;
int	col;
char	*globp;		/* global command pointer */
char	*agp  0;	/* "again" command pointer */
int	agf  0;		/* "again" flag  (executing the command) */
char	eol	0;	/* "end-of-line" char for multiple commands */
			/*   per line */
int	tfile	-1;
int	tline;
char	tfname[]  "/tmp/exxxxx";
char	*loc1;
char	*loc2;
char	*locs;
int	s_cnt   0;	/* counter for "s/str1/str2/nn" */
int	s_tmp   0;	/* scratch var for same */
char	ibuff[512];
int	iblock	-1;
char	obuff[512];
int	oblock	-1;
int	ichanged;
int	nleft;
int	errfunc();
int	*errlab	errfunc;
char	TMPERR[] "TMP";
int	names[26];
char	*braslist[NBRA];
char	*braelist[NBRA];

main(argc, argv)
char **argv;
{
	register char *p1, *p2;
	extern int onintr(), hangup();
	int n;

	onquit = signal(SIGQUIT, 1);
	onhup = signal(SIGHUP, hangup);
	prompt2 = istty(0);
	printf("XED V2.71\ntype \"help\" for info\n");
	while (--argc) {
		argv++;
		if(**argv == '-'){
			while (*++*argv) {
				switch (**argv) {
				case 'q':
					signal(SIGQUIT,0);
					break;
				case 'e':
					eflg++;
					break;
				case 's':
					prompt2 = 0;
					break;
				case 'a':	/* apl mode */
					aflg++;
					fmtlno = " [ %d ]\t";
					break;
				case 'f':
					fflg++;
					break;
				case 'n':
					prompt1 = 0;
					break;
				case 't':
					tflg++;
					break;
				case 'b':
					bflg++;
					bflg2++;
					break;
				case 'i':
					iflg++;
					break;
				default:
					printf("bad flag: -%c\n",
						**argv);
					exit(-1);
				}
			}
		}
		else {
			p1 = *argv;
			p2 = savedfile;
			while (*p2++ = *p1++);
			if (fflg) {
				globp = "a\n";
				globf2 = 1;
			}
			else
				globp = "r";
			break;
		}
	}

	if (!istty(1) && !eflg)
		prompt2 = 0;
	fendcore = sbrk(0);
	n = getpid();
	for (num = 10;num > 5;num--) {
		tfname[num] = (n & 07) + '0';
		n =>> 3;
	}
	init();
	if ((signal(SIGINTR, 1) & 01) == 0)
		signal(SIGINTR, onintr);
	setexit();
	addr1 = addr2 = 0;	/* addrs cleared on ints */
	do
		commands();
	while(are_you_sure());
	if (fflg && text_modified) {
		globp = "w\n";
		commands();
	}
	unlink(tfname);
}

commands() {
	int getfile(), gettty();
	register *a1, c;
	register char *p;
	int *old_a1, *old_a2;	/* previous address bounds */
	int r;

	for (;;) {
	if (agp) {
		*agp++ = '\n';
		*agp = 0;
	}
	agf = agp = 0;
	if(hupflag && !globp){
		globp = hupcom;
		peekc = 0;
		hupflag = 0;
		commands();
		unlink(tfname);
		exit();
	}
	if (pflag) {
		pflag = 0;
		addr1 = addr2 = dot;
		goto print;
	}
	if(!globp){
		if(prompt2 && !eflg2)
			puts2(e_prompt);
	}
	addr1 = 0;
	addr2 = 0;
	s_tmp = s_cnt = 0;
	if((peekc = getchar()) == '='){
		peekc = 0;
		addr1 = old_a1;
		addr2 = old_a2;
		if((c = peekc = getchar()) == '\n')
			c = 'p';
		else
			peekc = 0;
	} else {
		r = 1;
		do {
			addr1 = addr2;
			if ((a1 = address())==0) {
				c = getchar();
				break;
			}
			addr2 = a1;
			if ((c=getchar()) == ';') {
				c = ',';
				dot = a1;
			}
		} while (c==',' && r-- > 0);
	}
	if (addr1==0)
		addr1 = addr2;
	if(!globp){
		old_a1 = addr1;
		old_a2 = addr2;
	}
	line_num = (addr1? addr1 : dot) - zero;
	if (c == 01) {		/* "again" command  (^A)  */
		if (getchar() != '\n')
			errmsg(1294, "illegal command format");
		if (*agbuf == 0)
			errmsg(1270, "no command");
		if (agf)
			errmsg(1280, "recursive \"again\" command");
		agf++;
		agp = agbuf;
		c = *agp++;
		peekc = 0;
	}

	agp = agbuf;
	*agp++ = c;	/* first char not saved in "again" buffer */
	switch(c) {
	case 'a':
		setdot();
		line_num++;
		num = addr2;
	caseadd:
		if ((c = getchar()) == ' ') {
			r = 1;
		}
		else {
			if (c != '\n') {
				peekc = c;
				newline();
			}
			r = 0;
		}
		text_modified =+ append(gettty, num, r);
		continue;

	case 'b':
		num = 0;
		while ('0' <= (c = getchar()) && c <= '9')
			num = num * 10 + c - '0';
		peekc = c;
		newline();
		if (num > 0)
			brcount = num;
		else
			brcount = 1;
		continue;

	case 'c':
		if ((peekc = getchar()) == 'o') {
			peekc = 0;
			goto casecopy;
		}
		if (peekc != '\n')
			goto casesub;
		delete();
		r = append(gettty, addr1-1, 0);
		text_modified =+ r;
		continue;

	case 'd':
		delete();
		text_modified = 1;
		continue;

	case 'e':
		setnoaddr();
		if ((peekc = getchar()) != '\n') {
			if (peekc == '=') {
				peekc = 0;
				if ((c = getchar()) != '\n') {
					newline();
					eol = c;
					continue;
				}
				peekc = c;
				newline();
				eol = 0;
				continue;
			}
			if (fflg)
				errmsg(236, "can't change filename");
			if (peekc != ' ' && peekc != ',')
				errmsg(239,"illegal file name syntax");
			for (num = 0;tempfile[num] =
				savedfile[num];num++);
			savedfile[0] = 0;
			filename();
			if (text_modified && are_you_sure()) {
				for (num = 0;savedfile[num] =
					tempfile[num];num++);
				error;
			}
			peekc = '\n';
		}
		else {
			newline();
			if (text_modified && are_you_sure())
				error;
			peekc = '\n';
		}
		init();
		addr2 = zero;
		text_modified = 0;
		num_reads = 0;
		goto caseread;

	case 'f':
		setnoaddr();
		if ((c = getchar()) != '\n') {
			if(fflg)
				errmsg(254,"can't change file name");
			peekc = c;
			filename();
			for(c=0; c<FNSIZE; c++)
				savedfile[c] = file[c];
		}
		puts(savedfile);
		continue;

	case 'g':
		global(1);
		continue;

	case 'h':
		if ((peekc = getchar()) == 'e') {
			peekc = 0;
			while ((c = getchar()) && c != '\n');
			doc = open("/usr/tgi/src/xed.doc", 0);
			if (doc < 0)
				continue;
			while ((num = read(doc, linebuf, LBSIZE)) != 0)
				write(1, linebuf, num);
			close(doc);
			doc = 0;
			continue;
		}
		header();
		continue;

	case 'i':
		setdot();
		nonzero();
		num = addr2 - 1;
		goto caseadd;

	case 'k':
		if ((c = getchar()) < 'a' || c > 'z')
			errmsg(276,"syntax is k[a-z]");
		newline();
		setdot();
		nonzero();
		names[c-'a'] = *addr2 | 01;
		continue;

	case 'm':
		if ((peekc = getchar()) == 'o')
			peekc = 0;
		move(0);
		text_modified = 1;
		continue;

	case 'n':
		newline();
		prompt1 = prompt1? 0 : 1;
		printf("%sline numbers\n",(prompt1? "" : "no "));
		continue;

	case '\n':
		if (globp || addr2 > dol)
			continue;
		if (addr2==0) {
			addr2 = dot+1;
			if (addr2 <= dol)
				line_num++;
			addr1 = addr2;
			if(brcount != 1) {
				addr2 = dot + brcount;
				if(addr2 < zero)
					addr2 = zero;
			}
		}
		if(addr2 <= dol) {
			pflag = 0;
			goto print;
		}
		continue;

	case 'l':
		listf++;
	case 'p':
		if ((peekc = getchar()) == 'a') {
			if (addr1 == 0) {
				addr1 = dot + 1;
				if (addr1 > dol)
					addr1 = dol;
				line_num++;
			}
			addr2 = addr1 + 21;
			if (addr2 > dol)
				addr2 = dol;
			if (addr2 < zero)
				addr2 = zero;
			while ((c = getchar()) && c != '\n');
			peekc = '\n';
		}
		else {
			if ((c = getchar()) == 'p' || c == 'l') {
				addr1 = zero+1;
				addr2 = dol;
			}
			else
				peekc = c;
		}
		newline();
	print:
		setdot();
		nonzero();
		a1 = addr1;
		do  {
			if(prompt1 && prompt2) {
				col = 0;
				line_num = a1 - zero;
				printf(fmtlno,line_num - aflg);
			}
			puts(getline(*a1++));
		} while (a1 <= addr2);
		dot = addr2;
		listf = 0;
		continue;

	case 'q':
		if ((peekc = getchar()) == 'i') {
			text_modified = 0;
			peekc = 0;
		}
	casequit:
		setnoaddr();
		newline();
		return;

	case 'r':
	caseread:
		filename();
		if ((io = open(file, 0)) < 0) {
			lastc = '\n';
			printf("can't read %s\n",file);
			error;
		}
		setall();
		ninbuf = 0;
		r = append(getfile, addr2, 0);
		printf("%l lines\n",r);
		exfile();
		if(num_reads++)
			text_modified =+ r;
		else
			text_modified = 0;
		if ((c == 'e' && bflg == 1) || bflg2 == 1) {
			bflg2 = 0;
			backup();
		}
		continue;

	case 's':
		if ((peekc = getchar()) == '\n')
			goto casequit;
	casesub:
		setdot();
		nonzero();
		substitute(globp);
		text_modified = 1;
		continue;

	case 't':
	casecopy:
		move(1);
		text_modified = 1;
		continue;

	case 'u':
		setnoaddr();
		if (alt)
			errmsg(1230, "recursive \"use\" command");
		if ((peekc = getchar()) == 'p')
			peekc = 0;
		else
			eflg2++;

		if ((peekc = getchar()) == '\n' && altfile[0]) {
			peekc = 0;
			goto altname;
		}
		if ((c = getchar()) != ' ' && c != ',') {
			eflg2 = 0;
			errmsg(1220, "illegal file name syntax");
		}
		while ((c = getchar()) == ' ');
		if (c == '\n')
			errmsg(1224, "null file name illegal");
		altfile[0] = c;
		num = 1;
		while ((altfile[num++] = getchar()) != '\n');
		altfile[--num] = 0;
	altname:
		if ((alt = open(altfile, 0)) < 0) {
			alt = 0;
			lastc = '\n';
			printf("can't read %s\n", altfile);
			eflg2 = 0;
			error;
		}
		continue;

	case 'v':
		if ((peekc = getchar()) == '\n') {
			vflg = vflg? 0 : 1;
			printf("verify %s\n", (vflg? "on" : "off"));
			newline();
			pflag = listf = 0;
			continue;
		}
		global(0);
		continue;

	case 'w':
		setall();
		filename();
		if ((io = creat(file, 0604)) < 0){
			printf("can't create %s\n",file); error; 
		}
		if(dol == zero){
			printf("[nothing written]\n");
			continue;
		}
		nonzero();
		putfile();
		exfile();
		if (addr1 == zero + 1 && addr2 == dol)
			text_modified = 0;
		continue;

	case 'x':
		newline();
		r = undelete();
		printf("%l lines\n", r);
		continue;

	case '!':
		unix();
		continue;

	case EOF:
		if (alt) {
			close(alt);
			alt = 0;
			eflg2 = 0;
			continue;
		}
		return;

	}
	illcmd:
		errmsg(396,"unrecognized command");
	}
}

address() {
	register *a1, minus, c;
	int n, relerr;

	minus = 0;
	a1 = 0;
	for (;;) {
		c = getchar();
		if ('0'<=c && c<='9') {
			n = 0;
			do {
				n =* 10;
				n =+ c - '0';
			} while ((c = getchar())>='0' && c<='9');
			peekc = c;
			if (a1==0){
				a1 = zero;
				n =+ aflg;
			}
			if (minus<0)
				n = -n;
			a1 =+ n;
			minus = 0;
			continue;
		}
		relerr = 0;
		if (a1 || minus)
			relerr++;
		switch(c) {
		case ' ':
		case '\t':
			continue;
	
		case '+':
			minus++;
			if (a1==0)
				a1 = dot;
			continue;

		case '-':
		case '^':
			minus--;
			if (a1==0)
				a1 = dot;
			continue;
	
		search:
		case '?':
			minus++;
		case '/':
			compile(c);
			a1 = dot;
			for (;;) {
				if(minus == 0){
					if (++a1 > dol)
						a1 = zero;
				} else {
					if (--a1 < zero)
						a1 = dol;
				}
				if (execute(0, a1)){
					minus = 0;
					relerr = 0;
					break;
				}
				if (a1==dot)
					errmsg(462,"string not found");
			}
			break;
	
		case '$':
			a1 = dol;
			break;
	
		case '.':
			a1 = dot;
			break;

		case '\'':
			if ((c = getchar()) < 'a' || c > 'z')
				errmsg(476,"  '  must be followed by [a-z]");
		casemark:
			for (a1=zero; a1<=dol; a1++)
				if (names[c-'a'] == (*a1|01))
					break;
			break;
	
		default:
			if ('A' <= c && c <= 'Z') {
				c =| 040;
				goto casemark;
			}
/*			if( c > ' ' && !alpha(c))
 *				goto search;
 */
			peekc = c;
			if (a1==0)
				return(0);
			a1 =+ minus;
			if(a1 < zero)
				a1 = zero;
			else if(a1 > dol)
				a1 = dol;
			return(a1);
		}
		if (relerr)
			errmsg(494, "address syntax error");
	}
}

/*
alpha(c)
char c;
{
	if((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z'))
		return(1);
	else
		return(0);
}
 */

setdot() {
	if (addr2 == 0)
		addr1 = addr2 = dot;
	if (addr1 > addr2)
		errmsg(503,"lower address bound > upper one");
}

setall() {
	if (addr2==0) {
		addr1 = zero+1;
		addr2 = dol;
		if (dol==zero)
			addr1 = zero;
	}
	setdot();
}

setnoaddr() {
	if (addr2)
		errmsg(520,"address illegal here");
}

nonzero() {
	if(addr1 <= zero)
		errmsg(532,"non-existant line number");
	if(addr2 > dol)
		errmsg(534,"bottom of file reached");
}

newline() {
	register c;

	if ((c = getchar()) == '\n')
		return;
	if (c=='p' || c=='l') {
		pflag++;
		if (c=='l')
			listf++;
		if (getchar() == '\n')
			return;
	}
	errmsg(542,"command syntax error");
}

filename() {
	register char *p1, *p2;
	register c;

	count[1] = 0;
	c = getchar();
	if (c=='\n' || c==EOF) {
		p1 = savedfile;
		if (*p1==0)
			errmsg(555,"null file name illegal");
		p2 = file;
		while (*p2++ = *p1++);
		return;
	}
	if (c != ' ' && c != ',')
		errmsg(561,"file name syntax");
	while ((c = getchar()) == ' ');
	if (c=='\n')
		errmsg(564,"null file name illegal");
	p1 = file;
	do {
		*p1++ = c;
	} while ((c = getchar()) != '\n');
	*p1++ = 0;
	if (savedfile[0]==0) {
		p1 = savedfile;
		p2 = file;
		while (*p1++ = *p2++);
	}
}

exfile() {
	close(io);
	io = -1;
}

onintr() {
	register char *p1, *p2;

	if (alt) {
		close(alt);
		alt = 0;
		eflg2 = 0;
	}
	if (doc) {
		close(doc);
		doc = 0;
	}

	if (iflg) {
		signal(SIGINTR, 1);
		p1 = savedfile;
		p2 = file;
		while (*p2++ = *p1++);
		p1 = ".dmp";
		*p2--;
		while (*p2++ = *p1++);
		if (io >= 0) close(io);
		addr2 = 0;
		setall();
		if ((io = creat(file,0604)) < 0){
			printf("Can't create emergency exit file\n");
			exit(1);
		}
		if (dol == zero){
			printf("[no exit file needed]\n");
			exit();
		}
		putfile();
		exfile();
		exit();
	}
	signal(SIGINTR, onintr);
	putchar(lastc = '\n');
	errmsg(588,"INTERRUPT!");
}

errfunc() {
	register c;

	listf = 0;
/*	puts("?");	*/
	count[0] = 0;
	seek(0, 0, 2);
	pflag = 0;
	if (globp)
		lastc = '\n';
	globp = 0;
	peekc = lastc;
	while ((c = getchar()) != '\n' && c != EOF);
	if (io > 0) {
		close(io);
		io = -1;
	}
	reset();
}

getchar() {
	if (lastc=peekc) {
		peekc = 0;
		return(lastc);
	}
	if (globp) {
		if (lastc = *globp++)
			return(lastc);
		globp = 0;
		if(globf2 == 0)
			return(EOF);
		globf2 = 0;
	}
	if (agf) {	/* "again" */
		if (lastc = *agp++)
			return(lastc);
		agp = 0;
	}
	reading++;
	if (read(alt, &lastc, 1) <= 0){
		reading = 0;
		return(lastc = EOF);
	}
	reading = 0;
	lastc =& 0177;
	if (eol && lastc == eol)
		lastc = '\n';
	return(echo(lastc));
}

echo(ch) {
	if (eflg || alt && !eflg2)
		putchar(ch);
	if (!agf && agp) {	/* save current command for "again" */
		if (agp >= agbuf + LBSIZE)
			agp = agbuf[0] = 0;
		else
			*agp++ = ch;
	}
	return(ch);
}

gettty(single) {
	register c, gf;
	register char *p;

	p = linebuf;
	gf = globp;
	if(prompt1 && prompt2 && !single) {
		printf(fmtlno,line_num++ - aflg);
		flush_buf();
	}
	while ((c = getchar()) != '\n') {
		if (c==EOF) {
			if (gf)
				peekc = c;
			return(c);
		}
		if ((c =& 0177) == 0)
			continue;
		*p++ = c;
		if (p >= &linebuf[LBSIZE-2])
			errmsg(660,"input line too long");
	}
	*p++ = 0;
	if (linebuf[0]=='.' && linebuf[1]==0)
		return(EOF);
	return(0);
}

getfile() {
	register c;
	register char *lp, *fp;

	lp = linebuf;
	fp = nextip;
	do {
		if (--ninbuf < 0) {
			if ((ninbuf = read(io, genbuf, LBSIZE)-1) < 0)
				return(EOF);
			fp = genbuf;
		}
		if (lp >= &linebuf[LBSIZE]) {
			lastc = '\n';
			errmsg(682,"line in file too long");
		}
		if ((*lp++ = c = *fp++ & 0177) == 0) {
			lp--;
			continue;
		}
		if (++count[1] == 0)
			++count[0];
	} while (c != '\n');
	*--lp = 0;
	nextip = fp;
	return(0);
}

putfile() {
	int *a1;
	register char *fp, *lp;
	register nib;

	nib = 512;
	fp = genbuf;
	a1 = addr1;
	do {
		lp = getline(*a1++);
		for (;;) {
			if (--nib < 0) {
				wte(io, genbuf, fp-genbuf);
				nib = 511;
				fp = genbuf;
			}
			if (++count[1] == 0)
				++count[0];
			if ((*fp++ = *lp++) == 0) {
				fp[-1] = '\n';
				break;
			}
		}
	} while (a1 <= addr2);
	wte(io, genbuf, fp-genbuf);
}

wte(fd, buf, len)
char *buf;
{
	if(write(fd, buf, len) != len)
		errmsg("I/O error--file not saved!\n");
}

append(f, a, single)
int (*f)();
{
	register *a1, *a2, *rdot;
	int nline, tl;
	struct { int integer; };

	nline = 0;
	dot = a;
	while ((*f)(single) == 0) {
		if (dol >= endcore) {
			if (sbrk(1024) == -1)
				errmsg(743,"file overflows available memory");
			endcore.integer =+ 1024;
		}
		tl = putline();
		nline++;
		a1 = ++dol;
		a2 = a1+1;
		rdot = ++dot;
		while (a1 > rdot)
			*--a2 = *--a1;
		*rdot = tl;
		if (single) break;
	}
	return(nline);
}

unix() {
	register savint, pid, rpid;
	int retcode;

	setnoaddr();
	if ((pid = fork()) == 0) {
		signal(SIGHUP, onhup);
		signal(SIGQUIT, onquit);
		execl("/etc/xsh", "xsh", "-t", 0);
		exit();
	}
	savint = signal(SIGINTR, 1);
	while ((rpid = wait(&retcode)) != pid && rpid != -1);
	signal(SIGINTR, savint);
	puts("!");
}

delete() {
	register *a1, *a2, *a3;

	setdot();
	newline();
	nonzero();
	a1 = addr1;
	a2 = addr2+1;
	saveline();
	a3 = dol;
	dol =- a2 - a1;
	do
		*a1++ = *a2++;
	while (a2 <= a3);
	a1 = addr1;
	if (a1 > dol)
		a1 = dol;
	dot = a1;
}

getline(tl) {
	register char *bp, *lp;
	register nl;

	if(tflg)
		printf("getline:\t %o\n", tl);
	lp = linebuf;
	bp = getblock(tl, READ);
	nl = nleft;
	tl =& ~0377;
	while (*lp++ = *bp++)
		if (--nl == 0) {
			bp = getblock(tl=+0400, READ);
			nl = nleft;
		}
	return(linebuf);
}

putline() {
	register char *bp, *lp;
	register nl;
	int tl;

	lp = linebuf;
	tl = tline;
	if(tflg)
		printf("putline:\t %o\n", tl);
	bp = getblock(tl, WRITE);
	nl = nleft;
	tl =& ~0377;
	while (*bp = *lp++) {
		if (*bp++ == '\n') {
			*--bp = 0;
			linebp = lp;
			break;
		}
		if (--nl == 0) {
			bp = getblock(tl=+0400, WRITE);
			nl = nleft;
		}
	}
	nl = tline;
	tline =+ (((lp-linebuf)+03)>>1)&077776;
	return(nl);
}

getblock(atl, iof) {
	extern read(), write();
	register bno, off;
	
	bno = (atl>>8)&0377;
	off = (atl<<1)&0774;
	if (bno >= 255) {
		errmsg(841,"file too large (TMPERR)");
	}
	nleft = 512 - off;
	if (bno==iblock) {
		ichanged =| iof;
		return(ibuff+off);
	}
	if (bno==oblock)
		return(obuff+off);
	if (iof==READ) {
		if (ichanged) {
			blkio(iblock, ibuff, write);
			ichanged = 0;
		}
		iblock = bno;
		blkio(bno, ibuff, read);
		return(ibuff+off);
	}
	if (oblock>=0)
		blkio(oblock, obuff, write);
	oblock = bno;
	return(obuff+off);
}

blkio(b, buf, iofcn)
int (*iofcn)();
{
	seek(tfile, b, 3);
	if ((*iofcn)(tfile, buf, 512) != 512) {
		errmsg(870,"I/O error on temp file");
	}
}

init() {
	register char *p;
	register pid;

	close(tfile);
	if (doc) {
		close(doc);
		doc = 0;
	}
	if (alt) {
		close(alt);
		alt = 0;
	}
	tline = 0;
	deleted = ndeleted = 0;
	iblock = -1;
	oblock = -1;
	ichanged = 0;
	close(creat(tfname, 0600));
	tfile = open(tfname, 2);
	brk(fendcore);
	dot = zero = dol = fendcore;
	endcore = fendcore - 2;
}

global(k) {
	register char *gp;
	register c;
	register int *a1;
	char globuf[GBSIZE];
	int globpf;

	if (globp)
		errmsg(905,"recursive global command");
	setall();
	nonzero();
	if ((c=getchar())=='\n')
		errmsg(909,"missing global pattern");
	compile(c);
	globpf = pflag;
	gp = globuf;
	while ((c = getchar()) != '\n') {
		if (c==EOF)
			errmsg(914,"missing global commands");
		if (c=='\\') {
			c = getchar();
			if (c!='\n')
				*gp++ = '\\';
		}
		*gp++ = c;
		if (gp >= &globuf[GBSIZE-2])
			errmsg(922,"global command list too long");
	}
	*gp++ = '\n';
	*gp++ = 0;
	for (a1=zero; a1<=dol; a1++) {
		*a1 =& ~01;
		if (a1>=addr1 && a1<=addr2 && execute(0, a1)==k)
			*a1 =| 01;
	}
	for (a1=zero; a1<=dol; a1++) {
		if (*a1 & 01) {
			*a1 =& ~01;
			dot = a1;
			globp = globuf;
			pflag = globpf;
			commands();
			a1 = zero;
		}
	}
}

substitute(inglob) {
	register *a1, nl, p;
	int gsubf;
	int getsub();

	gsubf = compsub();		/* 0 or 1 depending on 'g' */
	for (a1 = addr1; a1 <= addr2; a1++) {
		s_tmp = s_cnt;
		if (execute(0, a1)==0)
			continue;
		inglob =| 01;
		dosub();
		if (gsubf) {
			while (*loc2) {
				if (execute(1)==0)
					break;
				dosub();
			}
		}
		/* save "marks" on lines so marked */
		p = *a1;
		*a1 = putline();
		for (nl = 0;nl <= 'z' - 'a';nl++)
			if (names[nl] == (p | 01))
				names[nl] = *a1 | 01;
		nl = append(getsub, a1, 0);
		a1 =+ nl;
		addr2 =+ nl;
	}
	if (inglob==0)
		errmsg(974,"substitute pattern not found");
}

compsub() {
	register seof, c;
	register char *p;

	if ((seof = getchar()) == '\n')
		errmsg(976,"missing sub string");
	compile(seof);
	p = rhsbuf;
	for (;;) {
		c = getchar();
		if (c=='\\')
			c = getchar() | 0200;
		if (c=='\n') {
			*p++ = 0;
			peekc = 0;
			if (vflg)
				pflag++;
			return(0);
		}
		if (c==seof)
			break;
		*p++ = c;
		if (p >= &rhsbuf[LBSIZE/2])
			errmsg(989,"string2 too long");
	}
	*p = 0;
	p = 0;
	if ((peekc = getchar()) == 'g') {	/* if in 'glob' */
		peekc = 0;
		p = 1;
	}
	else if ('0' <= peekc && peekc <= '9') {
		while ('0' <= (c = getchar()) && c <= '9')
			s_cnt = s_cnt * 10 + c - '0';
		if (s_cnt < 0)
			s_cnt = 0;
		peekc = c;
	}
	newline();
	return(p);
}

getsub() {
	register char *p1, *p2;

	p1 = linebuf;
	if ((p2 = linebp) == 0)
		return(EOF);
	while (*p1++ = *p2++);
	linebp = 0;
	return(0);
}

dosub() {
	register char *lp, *sp, *rp;
	int c;

	lp = linebuf;
	sp = genbuf;
	rp = rhsbuf;
	while (lp < loc1)
		*sp++ = *lp++;
	while (c = *rp++) {
		if (c=='&') {
			sp = place(sp, loc1, loc2);
			continue;
		} else if (c<0 && (c =& 0177) >='1' && c < NBRA+'1') {
			sp = place(sp, braslist[c-'1'], braelist[c-'1']);
			continue;
		}
		*sp++ = c&0177;
		if (sp >= &genbuf[LBSIZE])
			errmsg(1033,"sub string too long");
	}
	lp = loc2;
	loc2 = sp + linebuf - genbuf;
	while (*sp++ = *lp++)
		if (sp >= &genbuf[LBSIZE])
			errmsg(1039,"substituted string too big");
	lp = linebuf;
	sp = genbuf;
	while (*lp++ = *sp++);
}

place(asp, al1, al2) {
	register char *sp, *l1, *l2;

	sp = asp;
	l1 = al1;
	l2 = al2;
	while (l1 < l2) {
		*sp++ = *l1++;
		if (sp >= &genbuf[LBSIZE])
			errmsg(1055,"sub string too long");
	}
	return(sp);
}

move(cflag) {
	register int *adt, *ad1, *ad2;
	int getcopy();

	setdot();
	nonzero();
	if ((adt = address())==0)
		errmsg(1068,"missing move destination address");
	newline();
	ad1 = addr1;
	ad2 = addr2;
	if (cflag) {
		ad1 = dol;
		append(getcopy, ad1++, 0);
		ad2 = dol;
	}
	ad2++;
	if (adt<ad1) {
		dot = adt + (ad2-ad1);
		if ((++adt)==ad1)
			return;
		reverse(adt, ad1);
		reverse(ad1, ad2);
		reverse(adt, ad2);
	} else if (adt >= ad2) {
		dot = adt++;
		reverse(ad1, ad2);
		reverse(ad2, adt);
		reverse(ad1, adt);
	} else
		errmsg(1091,"move destination not found");
}

reverse(aa1, aa2) {
	register int *a1, *a2, t;

	a1 = aa1;
	a2 = aa2;
	for (;;) {
		t = *--a2;
		if (a2 <= a1)
			return;
		*a2 = *a1;
		*a1++ = t;
	}
}

getcopy() {
	if (addr1 > addr2)
		return(EOF);
	getline(*addr1++);
	return(0);
}

compile(aeof) {
	register eof, c;
	register char *ep;
	char *lastep;
	char bracket[NBRA], *bracketp;
	int nbra;
	int cclcnt;

	ep = expbuf;
	eof = aeof;
	bracketp = bracket;
	nbra = 0;
	if ((c = getchar()) == eof) {
		if (*ep==0)
			errmsg(1132,"null string illegal");
		return;
	}
	circfl = 0;
	if (c=='^') {
		c = getchar();
		circfl++;
	}
	if (c=='*') {		/* if first = *, then quote it */
		*ep++ = CCHR;
		*ep++ = c;
		c = 0;
	}
	peekc = c;
	for (;;) {
		if (ep >= &expbuf[ESIZE])
			goto cerror;
		c = getchar();
		if (c==eof) {
			*ep++ = CEOF;
			return;
		}
		if (c == '\n') {
			*ep++ = CEOF;
			if (vflg)
				pflag++;
			peekc = c;
			return;
		}
		if (c!='*')
			lastep = ep;
		switch (c) {

		case '\\':
			if ((c = getchar())=='(') {
				if (nbra >= NBRA){
					printf("too many  \(");
					goto cerror;
				}
				*bracketp++ = nbra;
				*ep++ = CBRA;
				*ep++ = nbra++;
				continue;
			}
			if (c == ')') {
				if (bracketp <= bracket){
					printf("unbalanced  (");
					goto cerror;
				}
				*ep++ = CKET;
				*ep++ = *--bracketp;
				continue;
			}
			*ep++ = CCHR;
			if (c=='\n'){
				printf("\\n illegal in pattern");
				goto cerror;
			}
			*ep++ = c;
			continue;

		case '.':
			*ep++ = CDOT;
			continue;

		case '*':
			if (*lastep==CBRA || *lastep==CKET){
				printf("illegal use of  *");
				goto cerror;
			}
			*lastep =| STAR;
			continue;

		case '$':
			if ((peekc = getchar()) != eof && peekc != '\n')
				goto defchar;
			*ep++ = CDOL;
			continue;

		case '[':
			*ep++ = CCL;
			*ep++ = 0;
			cclcnt = 1;
			if ((c=getchar()) == '^') {
				c = getchar();
				ep[-2] = NCCL;
			}
			do {
				if (c=='\n'){
					printf("missing  ]");
					goto cerror;
				}
				*ep++ = c;
				cclcnt++;
				if (ep >= &expbuf[ESIZE]){
					printf("pattern too complicated");
					goto cerror;
				}
			} while ((c = getchar()) != ']');
			lastep[1] = cclcnt;
			continue;

		defchar:
		default:
			*ep++ = CCHR;
			*ep++ = c;
		}
	}
   cerror:
	expbuf[0] = 0;
	putchar('\n');
	error;
}

execute(gf, addr)
int *addr;
{
	register char *p1, *p2, c;

	if (gf) {
		if (circfl)
			return(0);
		p1 = linebuf;
		p2 = genbuf;
		while (*p1++ = *p2++);
		locs = p1 = loc2;
	} else {
		if (addr==zero)
			return(0);
		p1 = getline(*addr);
		locs = 0;
	}
	p2 = expbuf;
	if (circfl) {
		loc1 = p1;
		return(advance(p1, p2));
	}
	/* fast check for first character */
	if (*p2==CCHR) {
		c = p2[1];
		do {
			if (*p1!=c)
				continue;
			if (advance(p1, p2)) {
				loc1 = p1;
				return(1);
			}
		} while (*p1++);
		return(0);
	}
	/* regular algorithm */
	do {
		if (advance(p1, p2)) {
			loc1 = p1;
			return(1);
		}
	} while (*p1++);
	return(0);
}

advance(alp, aep) {
	register char *lp, *ep, *curlp;
	char *nextep;

	lp = alp;
	ep = aep;
	for (;;) switch (*ep++) {

	case CCHR:
		if (*ep++ == *lp++)
			continue;
		return(0);

	case CDOT:
		if (*lp++)
			continue;
		return(0);

	case CDOL:
		if (*lp==0)
			continue;
		return(0);

	case CEOF:
		loc2 = lp;
		if (--s_tmp > 0)
			return(0);
		return(1);

	case CCL:
		if (cclass(ep, *lp++, 1)) {
			ep =+ *ep;
			continue;
		}
		return(0);

	case NCCL:
		if (cclass(ep, *lp++, 0)) {
			ep =+ *ep;
			continue;
		}
		return(0);

	case CBRA:
		braslist[*ep++] = lp;
		continue;

	case CKET:
		braelist[*ep++] = lp;
		continue;

	case CDOT|STAR:
		curlp = lp;
		while (*lp++);
		goto star;

	case CCHR|STAR:
		curlp = lp;
		while (*lp++ == *ep);
		ep++;
		goto star;

	case CCL|STAR:
	case NCCL|STAR:
		curlp = lp;
		while (cclass(ep, *lp++, ep[-1]==(CCL|STAR)));
		ep =+ *ep;
		goto star;

	star:
		do {
			lp--;
			if (lp==locs)
				break;
			if (advance(lp, ep))
				return(1);
		} while (lp > curlp);
		return(0);

	default:
		errmsg(-1376,"\"advance\" error (?)");
	}
}

cclass(aset, ac, af) {
	register char *set, c;
	register n;

	set = aset;
	if ((c = ac) == 0)
		return(0);
	n = *set++;
	while (--n){
		if(set[1] == '-'){
			c = min(set[0], set[2]);
			do{
				if(c ==  ac)
					return(af);
				c++;
			} while( c != max(set[0], set[2]));
			set =+ 2;
			c = ac;
		} else
			if (*set++ == c)
				return(af);
	}
	return(!af);
}

flush_buf() {
	if(linp>line) {
		write(1,line,linp-line);
		linp = line;
	}
}

puts2(as) {
	register char *sp;

	sp = as;
	col = 0;
	while (*sp)
		putchar(*sp++);
	flush_buf();
}

puts(as) {
	register char *sp;

	sp = as;
	col = 0;
	while (*sp)
		putchar(*sp++);
	putchar('\n');
}

putchar(ac) {
	register char *lp;
	register c;

	lp = linp;
	c = ac;
	if (listf) {
		col++;
		if (col >= 72) {
			col = 0;
			*lp++ = '\\';
			*lp++ = '\n';
		}
		if (c=='\t') {
			c = '>';
			goto esc;
		}
		if (c=='\b') {
			c = '<';
		esc:
			*lp++ = '-';
			*lp++ = '\b';
			*lp++ = c;
			goto out;
		}
		if (c<' ' && c!= '\n') {
			*lp++ = '\\';
			*lp++ = (c>>3)+'0';
			*lp++ = (c&07)+'0';
			col =+ 2;
			goto out;
		}
	}
	*lp++ = c;
out:
	if(c == '\n' || lp >= &line[64]) {
		linp = line;
		write(1, line, lp-line);
		return;
	}
	linp = lp;
}

are_you_sure() {
	register int c, n;

	if (alt)
		return(1);
	if (!text_modified || fflg)
		return(0);
	while(1) {
		printf("\ndid you forget to save your text? ");
		for(n=0; n<5; n++) {
		flush_buf();
			if((c=getchar())<=0)
				return(0);
			if(c != '\n')
				skip_rest();
			else
				return(1);
			switch(c) {
				case 'y': return(1);
				case 'n': return(0);
			}
			printf("yes or no? ");
		}
	}
}

skip_rest() {
	register int c;

	while((c=getchar())>0 && c != '\n');
}

errmsg(n,s)
char *s;
{
	if(n > 0)
		printf("%s\n", s);
	else
		printf("%4d: %s\n", -n, s);
	goto errlab;
}

istty(fd) {
	int buf[18];

	fstat(fd, buf);
	if((buf[2]&060000) == 020000)
		return(1);
	else
		return(0);
}

hangup() {
	onhup = signal(SIGHUP, hangup);
	puts2("\nHANGUP!\n");
	if (doc) {
		close(doc);
		doc = 0;
	}
	if (alt) {
		close(alt);
		alt = 0;
		eflg2 = 0;
	}
	if(reading){
		globp = hupcom;
		commands();
		unlink(tfname);
		exit();
	}
	hupflag++;
}

min(a,b) {
	return(a>b? b : a);
}

max(a,b) {
	return(a>b? a : b);
}

backup() {
	register char *p1, *p2;

	addr2=0;
	setall();
	p1 = savedfile;
	p2 = file;
	while (*p2++ = *p1++);
	*p2--;
	p1 = ".bak";
	while (*p2++ = *p1++);
	if ((io=creat(file,0604)) < 0){
		printf("Can't create %s\n",file); error; }
	if (dol == zero) printf("[Nothing written]\n");
	else {
		nonzero();
		putfile();
		exfile(); 
	}
}

header() {
	register int colnum, number;
	register char c;

	number = 0;
	if ((peekc = c = getchar()) != '\n') {
		while ((c = getchar()) == ' ' || c == '\t');
		peekc = c;
		while ((c = getchar()) >= '0' && c <= '9')
			number = number * 10 + c - '0';
	}
	if (!number)
		number = 71;
	peekc = c;
	newline();
	putchar('\t');
	for (colnum = 1;colnum <= number;colnum++)
		putchar(colnum % 10 + '0');
	putchar('\n');
}

saveline() {
	register int *bp;
	register int *a1, *a2;
	int nl, tl;

	a1 = addr1;
	a2 = addr2 + 1;
	ndeleted = a2 - a1;
	tl = tline;
	if (tflg)
		printf("saveline:\t %o\n", tl);
	bp = getblock(tl, WRITE);
	nl = nleft;
	tl =& ~0377;
	while (a1 < a2) {
		*bp++ = *a1++;
		if (--nl == 0) {
			bp = getblock(tl=+0400, WRITE);
			nl = nleft / 2;
		}
	}
	deleted = tline;
	tline =+ (a2 - addr1) & 077776;
}

undelete() {
	register int *a1, *a2, *bp;
	int tl, nl;
	struct { int integer; };

	if (!(tl = deleted))
		errmsg(1210, "no lines");
	if (tflg)
		printf("undelete:\t %o\n", tl);
	setdot();
	a1 = dol + 1;
	a2 = a1 + ndeleted;
	bp = addr2 + 1;
	if (dol + ndeleted > endcore) {
		num = ((ndeleted + 1023) / 1024) * 1024;
		if (sbrk(num) == -1)
			errmsg(1240,"file overflows available memory");
		endcore.integer =+ num;
	}
	dol =+ ndeleted;
	while (a1 > bp)
		*--a2 = *--a1;
	a1 = addr2 + 1;
	a2 = a1 + ndeleted;
	bp = getblock(tl, READ);
	nl = nleft;
	tl =& ~0377;
	while (a1 < a2) {
		*a1++ = *bp++;
		if (--nl == 0) {
			bp = getblock(tl =+ 0400, READ);
			nl = nleft;
		}
	}
	dot = a2 - 1;
	return(ndeleted);
}
