/*   February 7, 1977                                Dan Chernikoff
    This program reads a character from the standard input
     and returns a status of 0 if response was y, Y, or <CR>,
                            -1 if response was n, or N.
    If the response isn`t y, Y, n, N, or CR, a diagnostic message
    will be printed, and input accepted again.
      It is meant to be used with ECHO, to ask a question,
      and with IF, to execute a command if the response was yes.
      EXAMPLE   
            echo "Do you want to edit?( y or n )"
            if { query } xed data </dev/ttym
            echo "done"

    NOTE: File Descriptor 2 replaces File Descr. 0, so it will
    accept input from your tty when executed from a shell
    command file.
                                       */
char answer;
main()
{
	extern char answer;
	setupio();   /* set fd 2 to fd 0 ( allows I/O from shell file ) */
	while( 1 ) /* forever */
	{
	 rdline();  /*read input line, set answer = one character*/
	 switch ( answer ){
		case 'y': case 'Y':
			exit( 0 );  /* true status */
			break;
		case 'n': case 'N':
			exit( -1 );  /* false status */
			break;
		default:
			printf("Respond 'y', 'n', or <CR> only. -");
			break;
		}
	}
}
rdline(){
	char c;
	extern char answer;
	int i;
	answer = 'y';  /* CR defaults to yes */
	for( i=0; ( c=getchar() ) != '\n'; i++ )
		if( i == 0 ) answer = c;
			else answer = '\0'; /* i.e illegal input */
}
setupio()
{
	int stat;
	stat = close(0);
	stat = dup(2);
}
