#
/*  
	create a tp-compatible tape from a list of filenames
*/
# define MAXENT 496					/*  maximum number of directory entries  */
# define SIZENT 32					/*  size of directory entries in words  */
struct
{
    char    minor;
    char    major;
    int     inumber;
    int     flags;
    char    nlinks;
    char    iuid;
    char    igid;
    char    isize0;
    int     isize1;
    int     addr[8];
    int     iatime[2];
    int     imtime[2];
}       inode;
struct
{
    char    pathname[32];
    int     mode;
    char    uid;
    char    gid;
    int     size[2];
    int     mtime[2];
    int     tapadd;
    int     filler[8];
    int     chksum;
}       direct[MAXENT];
int     sum;
int	sumr, suml;
int      *psum;
int     i,
        i1,
        i2,
        i3,
        i4,
        i5,
        i6,
        i7,
        i8;
int     nentry;
int     ifdes;
char	*ifpname;
char    ifname[100];
char	c;
int     ofdes;
char   *ofname "/dev/mt0";
int     ofblk;
char    buf[512];
main ()
{
    extern  ldivr;
    nentry = 0;
    i = 0;
    ofblk = 63;
    if ((ofdes = open (ofname, 1)) < 0)
	{
	printf ("\ncant open output file %s", ofname);
	exit ();
	}
/*  start loop that gets filenames  */
	while (1)
	{
		ifpname = &ifname;
		while ((c=getchar()) !='\n') {
			if (c == '\0')
				goto out;
			*ifpname++ = c;
		}
		*ifpname++ = '\0';
/*  open file to be copied  */
	if ((ifdes = open (ifname, 0)) < 0)
	    {
	    printf ("\ncant open input file %s", ifname);
	    }
	else
	    {
/*  get information for directory  */
	    if (stat (ifname, &inode) < 0)
		{
		printf ("\ncant get status for %s", ifname);
		exit ();
		}
	    nentry++;
/*  fill in directory entry  */
	    for (i1 = 0; i1 < 31; i1++)
		{
		direct[i].pathname[i1] = ifname[i1];
		if (ifname[i1] == 0)
		    break;
		}
	    direct[i].pathname[31] = 0;
	    direct[i].mode = inode.flags;
	    direct[i].uid = inode.iuid;
	    direct[i].gid = inode.igid;
	    direct[i].size[0] = inode.isize0;
	    direct[i].size[1] = inode.isize1;
	    direct[i].mtime[0] = inode.imtime[0];
	    direct[i].mtime[1] = inode.imtime[1];
	    direct[i].tapadd = ofblk;
	    ofblk =+ ldiv (direct[i].size[0], direct[i].size[1], 512);
	    if (ldivr > 0)
		ofblk =+ 1;
	    i++;
	    close (ifdes);
	    }
	}
out:
    nentry = i;
    compsum ();
    putdir ();
    printf ("\ndirectory written - %d entries", nentry);
/*  write files to tape */
    for (i8 = 0; i8 < nentry; i8++)
	{
	if ((ifdes = open (direct[i8].pathname, 0)) < 0)
	    {
	    printf ("\ncant open %s to copy");
	    exit ();
	    }
	copyfil ();
	close (ifdes);
	}
    printf ("\n%d files saved", nentry);
}
/*  copy file to tape  */
copyfil ()
{
    while (i3 = read (ifdes, buf, 512))
	{
	if (write (ofdes, buf, 512) != 512)
	    {
	    printf ("\nwrite error during %s", direct[i8].pathname);
	    exit ();
	    }
	}
    if (i3 < 0)
	{
	printf ("\nread error during %s", direct[i8].pathname);
	exit ();
	}
}
/*  compute directory entry checksum  */
compsum ()
{
    for (i6 = 0; i6 < nentry; i6++)
	{
	sum = 0;
	suml = 0;
	sumr = 0;
	psum = &direct[i6];
	for (i7 = 0; i7 < 31; i7++)
	    {
		sumr =+ (*psum & 0377);
		suml =+ ((*psum++ >> 8) & 0377);
	    }
	sum = ((suml + ((sumr & 0177400) >> 8)) << 8) | (sumr & 0377);
	direct[i6].chksum =~ sum;
	direct[i6].chksum =+ 1;
	}
}
/*  find directory area on tape  */
putdir ()
{
    if (seek (ofdes, 1, 3) < 0)
	{
	printf ("\ncant seek 1");
	exit ();
	}
    for (i5 = 0; i5 < MAXENT; i5 =+ 8)
	{
	if (write (ofdes, &direct[i5], 512) < 0)
	    {
	    printf ("\ncant write directory");
	    exit ();
	    }
	}
}
printdir ()
{
    printf ("\npath %s", direct[i].pathname);
    printf ("\nmode %o", direct[i].mode);
    printf ("\nuid %o", direct[i].uid);
    printf ("\nsize 0-%o, 1-%o", direct[i].size[0], direct[i].size[1]);
    printf ("\nmtime 0-%o, 1-%o", direct[i].mtime[0], direct[i].mtime[1]);
    printf ("\ntapadd %o", direct[i].tapadd);
}
printsum ()
{
    for (i1 = 0; i1 < 3; i1++)
	{
	psum = &direct[i1];
	for (i3 = 0; i3 < SIZENT; i3++)
	    {
	    printf ("\n%o", *psum++);
	    }
	printf ("\n\n");
	}
}
