#include	"/mnt/muir/con-source/con.h"
/*
*	flag variables
*/
int     rflag;						/* record file flag		 */
int     nflag;						/* dial number in buffer flag	 */
int     srtflag;					/* line control, stop flag	 */
/*
*	misc declarations
*/
int     max;						/* maximum array length of pnum		 */
int     i;						/* for statement incrementor		 */
char    filename[BUFLEN];
char   *sp;
int     prid;						/* process id of the children		 */
char    lc;						/* one character buffer for line control pipe	 */
char    buf[BUFLEN];					/* the children's buffer		 */
char    fbuf[BUFLEN];					/* buffer for receive file, no carriage returns  */
int     l;						/* length of remote reads		 */
int     morkil ();					/* kill of front end child	 */
int     recvi ();					/* fire up the correct terminating code for receive  */
int     recvq ();					/* same as above		 */
int     writef ();					/* write string to file		 */
int     writef1 ();					/* write string to standard output   */
int     writenl ();					/* write newline on standard output    */
main (argc, argv)
int     argc;
char   *argv[];
{
    read (PIPER, &p, PSIZE);
    write (p.ctrl[1], &p, PSIZE);
    if ((prid = fork ()) == 0)
	{
	execl ("/usr/dpd/conf", "confront", 0);
	}
    if (p.pnum[0])
	nflag++;
    lc = STX;
    loop
    {
	signal (SIGINT, recvi);
	signal (SIGQIT, recvq);
	signal (SIGHUP, morkil);
	while ((l = read (p.comm[0], buf, BUFLEN)) > 0)
	    {
	    if (rflag)
		{
		max = 0;
		for (i = 0; i < l; i++)
		    {
		    if (buf[i] != CR && buf[i] != XON && buf[i] != NULL)
			fbuf[max++] = buf[i];
		    }
		write (p.flr, fbuf, max);
		}
	    if (nflag)
		{
		write (p.ldcon[1], buf, l);
		continue;
		}
	    if (p.stop && p.start)
		{
		for (i = 0; i < l; i++)
		    if (buf[i] == p.start)
			srtflag++;
		if (srtflag)
		    {
		    write (p.ldcon[1], &lc, 1);
		    srtflag = 0;
		    }
		}
	    write (p.flo, buf, l);
	    }
    }
    exit ();
}
/*
Name:
	gather
Function:
	Read a single line of console input into the user specified
	buffer.  Standard unix editing is in effect.
Algorithm:
	Read a character:
	If it is an unescaped new line, null terminate the buffer and return.
	Otherwise, stash the character into the buffer.
	If the length of the buffer has been reached, echo a new line and
	return.
Parameters:
	*char	pointer to user buffer of length STRINGLEN
Returns:
	nothing
Globals:
	STRINGLEN
Calls:
	getchar
	slashc
Called by:
	main
	send
History:
	Recoded by Mark Kampe 11/22/75
	Rerecoded by R. B.
*/
gather (gsp, fds) char *gsp;
int     fds;
{
    register int    gc;
    register int    gi;
    register char  *ptr;
    ptr = gsp;
    for (gi = STRINGLEN + 1; --gi;)
	{
	gc = getchar (fds);
	if (gc < 0 || gc == '\n')
	    break;
	else
	    *ptr++ = gc == "\\" ? slashc (fds) : gc;
	}
    *ptr = '\0';
}
/*
Name:
	getchar
Function:
	To read a character from a specified file.
Algorithm:
	Do a read, and if we got an end of file, return a -1.
	CAVEAT	Input is unbuffered.
Parameters:
	int	file descriptor of file to be read from.
Returns:
	char	or -1
Globals:
Calls:
	read()
Called by:
X	lots of people
History:
	Someone at berkeley.
*/
char    getchar (cfd) int   cfd;
{
    char    bc;
    return read (cfd, &bc, 1) <= 0 ? IOERR : bc & 0177;
}
/*
Name:
	slashc
Function:
	Given that the last input character seen was a backslash, this
	routine returns the character that is being escaped.
Algorithm:
	If terminal is half ascii
		If next char is lower case, return its upper case counterpart.
		If it is the preimage of a non-half ascii character, return
			that character.
	Else, return the next character.
Parameters:
Returns:
	A character.
Globals:
	ttys	to check out the console modes.
Calls:
	getchar
Called by:
	input
History:
	Initial coding by someone at berkeley.
*/
slashc (sfd)
int     sfd;
{
    register char   sc;
    sc = getchar (sfd);
    if ((p.olstat[2]) & 04)				/* Half-ASCII */
	{
	if (sc >= 'a' && sc <= 'z')
	    return sc & not 040;			/* ascii dependent */
	else
	    switch (sc)
		{
		case '!': return '|';
		case '\'': return '`';
		case '^': return '~';
		case '(': return '{';
		case ')': return '}';
		default: return sc;
		}
	}
    else
	return sc;
}
recvi ()
{
    signal (SIGINT, recvi);
    recv (ZERO);
    return;
}
recvq ()
{
    signal (SIGQIT, recvq);
    recv (ONE);
    return;
}
morkil ()
{							/*  kill off children		 */
    kill (prid, SIGKIL);
    exit ();
}
recv (arg) int  arg;
{							/*  receive file module		 */
    char    eof;
    eof = '\n';
    if (arg == 0 || arg == 1)
	{
	if (rflag)
	    {
	    rflag = 0;
	    write (p.flr, &eof, 1);
	    close (p.flr);
	    writef1 ("Receive EOF\n\r");
	    }
	nflag = 0;
	if (arg == 0)
	    return;
	}
    if (arg == 1)
	{						/*  look at pipe filnm for filename or dialer flag  */
	sp = filename;
	rflag = 0;
	gather (filename, p.filnm[0]);
	if ((p.flr = creat (filename, FMODE)) < 0)
	    {
	    printf ("Cannot open: %s\n\r", filename);
	    return;
	    }
	rflag++;
	return;
	}
}
/*
Name:
	writef and writef1 and writeln
Function:
	Write a null terminated string without the terminator.  (Writef1 is
	a printf substitute which is adequate and faster when only strings are
	printed--as in this program).  (Writeln writes a new line on the
	standard output.)
Algorithm:
	Determine the length of the string.  Write it out. (Writef1 writes to standard output only.)
 CAVEAT	This call is not buffered, so use it carefully or pay the cost
	of high I/O expense.  It was writted to decrease subroutine linkage
	global variable referencing and module size.  But those gains can
	easily be lost if writef is consistantly called with small strings
	where buffered i/o would be possible.
Parameters:
	int	file descriptor of output file (not present in writef1 or writeln).
	*char	pointer to null terminated string (not present in writeln).
Returns:
	int	value returned by write.
Globals:
Calls:
	write()		(writef1 calls writef and writeln calls writef1)
Called by:
	lotsa people
History:
	Initially coded by Mark Kampe 11/22/75
	Writef1 and writenl written by Rick Balocca 8/1/76
*/
writef (afd, str) int   afd;
char   *str;
{
    register char  *r;
    register char  *s;
    s = str;
    r = s;
    while (*s++);
    return write (afd, r, --s - r);
}
writef1 (str) char *str;
{
    return writef (1, str);
}
writenl ()
{
    return writef1 ("\n");
}
