#include	"/mnt/muir/con-source/con.h"
/*
*	structures
*/
struct sgtty
{
    char    sgispd,
            sgospd;
    char    sgerase,
            sgkill;
    int     sgflag;
}               rstat;					/* remote tty status  */
struct tab
{
    int     tname;					/*  this table name      */
    int     nname;					/* sucessor table name	 */
    int     lyflags;					/* local forced yes flags	 */
    int     lnflags;					/* local forced no flags	 */
    int     ler;					/* local erase character	 */
    int     lkl;					/* local kill character		 */
    int     rflags;					/* remote flags		 */
    int     ispeed;					/* remote input speed	 */
    int     ospeed;					/* remote output speed	 */
    int     rlstop;					/* remote line control stop character	 */
    int     rlstart;					/* remote line control start character	 */
    char   *message;					/* startup message giving info about connection being
							   established	 */
}           itab[]
{
/*	table '0' half duplex, 300 baud, rawmode, line control		*/
                '0', '0',
                RAW, CRMOD + XTABS,
                ERASE1, KILL1,
                HUPCL + RAW + EVENP,
                B300, B300,
                CR, XON,
                "300 baud, half duplex, line control",
/*	table '1' 300 baud, full duplex, no parity			*/
                '1', '1',
                RAW, ECHO + CRMOD + XTABS,
                ERASE1, KILL1,
                HUPCL + RAW + ANYP + CR2,
                B300, B300,
                NULL, NULL,
                "300 baud, full duplex, no parity ",
/*	table '2' 300 baud, full duplex, no parity, line control	*/
                '2', '2',
                RAW, ECHO + CRMOD + XTABS,
                ERASE1, KILL1,
                HUPCL + RAW + ANYP + CR2,
                B300, B300,
                CR, CR,
                "300 baud, full duplex, no-parity, line control",
/*	table '3' 1200 baud, full duplex, no parity, line control	*/
                '3', '3',
                RAW, ECHO + CRMOD + XTABS,
                ERASE1, KILL1,
                HUPCL + RAW + ANYP + CR2,
                B1200, B1200,
                CR, CR,
                "1200 baud, full duplex, no parity, line control ",
/*	table '4' 300 baud, half duplex, evenp, line cont., gcos kill  */
                '4', '4',
                NULL, XTABS,
                ERASE4, KILL4,
                HUPCL + RAW + EVENP + CR2,
                B300, B300,
                CR, XON,
                "300 baud, half duplex, line control, gcos kill ",
/*	table '5' 300 baud, half duplex, line control, UNIX kill   */
                '5', '5',
                NULL, XTABS,
                ERASE1, KILL1,
                HUPCL + RAW + EVENP + CR2,
                B300, B300,
                CR, XON,
                "300 baud, half duplex, even parity, line, control UNIX kill ",
/*	table '6' 1200 baud, full-dup, no parity, line control, normal mode  */
                '6', '6',
                NULL, XTABS,
                ERASE1, KILL1,
                HUPCL + RAW + ANYP + CR1,
                B1200, B1200,
                CR, CR,
                "1200 baud, full-duplex, no parity, line control, normal mode ",
/*	table '7' 1200 baud, f-dup, nopa, line-c, all-normal		*/
                '7', '7',
                NULL, XTABS,
                ERASE1, KILL1,
                HUPCL + ANYP + CR3,
                B1200, B1200,
                CR, CR,
                "1200 baud, full-duplex, no parity, line control, normal I/O\n (I/O on newline) ",
/*	table '8' 300 baud, f-dup, nopa, line-c, normal I/O		*/
                '8', '8',
                NULL, XTABS,
                ERASE1, KILL1,
                HUPCL + ANYP + CR3,
                B300, B300,
                CR, CR,
                "300 baud, full-duplex, no parity, line control, normal I/O\n (I/O on newline) ",
/*	table '9' 1200 baud, even parity, half-duplex, line-c, UNIX kill 		*/
                '9', '9',
                NULL, XTABS,
                ERASE1, KILL1,
                HUPCL + RAW + EVENP + CR1,
                B1200, B1200,
                CR, XON,
                "1200 baud, half-duplex, even parity, line control, UNIX kill ",
};
#define	NITAB	sizeof itab/sizeof itab[0]
struct tab *tabp;
struct lgtty
{
    char    lispd,
            lospd;
    char    lerase,
            lkill;
    int     lflags;
}               lstat;					/* constructed local tty status		 */
/*
*	flag variables
*/
int     rflag;						/* record file flag		 */
int     nflag;						/* dial number in buffer flag	 */
int     sflag;						/* send file flag		 */
int     srtflag;					/* line control, stop flag	 */
/*
*	misc declarations
*/
int     argcnt;						/* arg count for help file		 */
int     i;						/* for statement incrementor		 */
int     max;						/*  buffer index */
char   *sp;						/*  string pointer used lots of places		 */
int     prid;						/* process id of the children		 */
char    c;						/* one character buffer for local input	 */
char    rdev[] "/dev/ttyx\0";				/* tty string to be completed when the real remote tty port is
							   found	 */
char    tdev[] "/dev/ttyx";				/* tty string to be completed when the real local tty port is
							   found	 */
char    rlock[] "/usr/dpd/lockx";			/* lock filename string to be completed by input
							   arguments	 */
char    filename[BUFLEN];				/* buffer for passing names 		 */
int     ask ();						/* ask a question of the local tty    */
int     catch ();					/* catch interupts to parent	 */
int     cleanup ();					/* close up files, kill children and stty */
int     writef ();					/* write string to file		 */
int     writef1 ();					/* write string to standard output   */
int     writenl ();					/* write newline on standard output    */
/*
*	main program
*/
main (argc, argv)
int     argc;
char   *argv[];
{
/*
*	function decalrations
*/
    nflag = rflag = sflag = srtflag = 0;
    argcnt = argc;
    if (argc > 2)
	{
	p.tabname = '0';
	p.tabname = argv[1][0];
	p.tty = argv[2][0];
	}
    else
	{
	writef1 ("Usage: con table route [phone number]\n");
	exit ();
	}
    max = 0;
    if (argc > 3)
	{
	for (i = 0; (c = argv[3][i]) != '\0'; i++)
	    {
	    p.pnum[max++] = c;
	    if (max > 20)
		{
		writef1 ("Number too large\n");
		exit ();
		}
	    }
	nflag++;
	}
    p.pnum[max] = '\0';
    if (argc > 4)
	{
	writef1 ("Additional arguments ignored\n");
	}
    p.fli = 0;
    p.flo = 1;
    loop
    {
	rdev[8] = p.tty;
	rlock[13] = p.tty;
	if ((p.lfds = creat (rlock, LMODE)) < 0)
	    {
	    printf ("Remote connection via tty%c is locked\n", p.tty);
	    if ((ask ("Alternate tty? (yes or no)")) <= 0)
		exit ();
	    writef1 ("\ntty? (one character please)-");
	    gather (filename, p.fli);
	    writenl ();
	    p.tty = filename[0];
	    }
	else
	    break;
    }
    if ((p.fri = open (rdev, 2)) < 0)
	{
	printf ("Unable to open %s\n", rdev);
	unlink (rlock);
	exit ();
	}
    p.fro = p.fri;
    gtty (p.fli, p.olstat);
    signal (SIGINT, cleanup);
    gtty (p.fli, &lstat);
    for (tabp = &itab[0]; tabp < &itab[NITAB]; tabp++)
	if (tabp -> tname == p.tabname)
	    break;
    lstat.lkill = tabp -> lkl;
    lstat.lflags =| (tabp -> lyflags);
    lstat.lflags =& not (tabp -> lnflags);
    lstat.lerase = tabp -> ler;
    rstat.sgflag = tabp -> rflags;
    rstat.sgispd = tabp -> ispeed;
    rstat.sgospd = tabp -> ospeed;
    p.stop = tabp -> rlstop;
    p.start = tabp -> rlstart;
    rstat.sgerase = NULL;
    rstat.sgkill = NULL;
    printf ("%s connection being established.\n", tabp -> message);
    if (argc > 3)
	printf ("Number = %s.\t", p.pnum);
    writef1 ("Key '?h' for help.\n");
    stty (p.fro, &rstat);
    stty (p.fli, &lstat);
    pipe (p.ctrl);
    pipe (p.comm);
    pipe (p.ldcon);
    pipe (p.filnm);
    write (p.ctrl[1], &p, PSIZE);
    execl ("/usr/dpd/conc", "con-control", 0);
}
/*
Name:
	writef and writef1 and writeln
Function:
	Write a null terminated string without the terminator.  (Writef1 is
	a printf substitute which is adequate and faster when only strings are
	printed--as in this program).  (Writeln writes a new line on the
	standard output.)
Algorithm:
	Determine the length of the string.  Write it out. (Writef1 writes to standard output only.)
 CAVEAT	This call is not buffered, so use it carefully or pay the cost
	of high I/O expense.  It was writted to decrease subroutine linkage
	global variable referencing and module size.  But those gains can
	easily be lost if writef is consistantly called with small strings
	where buffered i/o would be possible.
Parameters:
	int	file descriptor of output file (not present in writef1 or writeln).
	*char	pointer to null terminated string (not present in writeln).
Returns:
	int	value returned by write.
Globals:
Calls:
	write()		(writef1 calls writef and writeln calls writef1)
Called by:
	lotsa people
History:
	Initially coded by Mark Kampe 11/22/75
	Writef1 and writenl written by Rick Balocca 8/1/76
*/
writef (afd, str) int   afd;
char   *str;
{
    register char  *r;
    register char  *s;
    s = str;
    r = s;
    while (*s++);
    return write (afd, r, --s - r);
}
writef1 (str) char *str;
{
    return writef (1, str);
}
writenl ()
{
    return writef1 ("\n");
}
/*
Name:
	ask
Function:
	Collect an line from the terminal.  If the line starts with a 'y' or
	a 'Y', return true, otherwise return false;
Algorithm:
	Loop, getting characters until new line is encountered.  If a 'y' or a
	'Y' was encountered, set answer to true.
Parameters:
	str	char	* string to be printed before answer is collected.
Returns:
	The variable answer, set according to algorithm above.
Globals:
	none.
Calls:
	getchar
	writef1
is called by:
	main
	send
History:
	Written by Rick Balocca 7/30/76
*/
ask (str) char *str;
{
    register int    answer;
    writef1 (str);					/* 	ask the question	 */
    answer = FALSE;					/* 	assumed answer is false	 */
    loop
	switch (getchar (0))
	{
	case IOERR: 
	case '\n': return answer;
	case 'Y': 
	case 'y': answer = TRUE;
	}
    return answer;
}
/*
Name:
	gather
Function:
	Read a single line of console input into the user specified
	buffer.  Standard unix editing is in effect.
Algorithm:
	Read a character:
	If it is an unescaped new line, null terminate the buffer and return.
	Otherwise, stash the character into the buffer.
	If the length of the buffer has been reached, echo a new line and
	return.
Parameters:
	*char	pointer to user buffer of length STRINGLEN
Returns:
	nothing
Globals:
	STRINGLEN
Calls:
	getchar
	slashc
Called by:
	main
	send
History:
	Recoded by Mark Kampe 11/22/75
	Rerecoded by R. B.
*/
gather (gsp, fds) char *gsp;
int     fds;
{
    register int    gc;
    register int    gi;
    register char  *ptr;
    ptr = gsp;
    for (gi = STRINGLEN + 1; --gi;)
	{
	gc = getchar (fds);
	if (gc < 0 || gc == '\n')
	    break;
	else
	    *ptr++ = gc == "\\" ? slashc (fds) : gc;
	}
    *ptr = '\0';
}
/*
Name:
	getchar
Function:
	To read a character from a specified file.
Algorithm:
	Do a read, and if we got an end of file, return a -1.
	CAVEAT	Input is unbuffered.
Parameters:
	int	file descriptor of file to be read from.
Returns:
	char	or -1
Globals:
Calls:
	read()
Called by:
X	lots of people
History:
	Someone at berkeley.
*/
char    getchar (cfd) int   cfd;
{
    char    bc;
    return read (cfd, &bc, 1) <= 0 ? IOERR : bc & 0177;
}
/*
Name:
	slashc
Function:
	Given that the last input character seen was a backslash, this
	routine returns the character that is being escaped.
Algorithm:
	If terminal is half ascii
		If next char is lower case, return its upper case counterpart.
		If it is the preimage of a non-half ascii character, return
			that character.
	Else, return the next character.
Parameters:
Returns:
	A character.
Globals:
	ttys	to check out the console modes.
Calls:
	getchar
Called by:
	input
History:
	Initial coding by someone at berkeley.
*/
slashc (sfd)
int     sfd;
{
    register char   sc;
    sc = getchar (sfd);
    if ((lstat.lflags) & 04)				/* Half-ASCII */
	{
	if (sc >= 'a' && sc <= 'z')
	    return sc & not 040;			/* ascii dependent */
	else
	    switch (sc)
		{
		case '!': return '|';
		case '\'': return '`';
		case '^': return '~';
		case '(': return '{';
		case ')': return '}';
		default: return sc;
		}
	}
    else
	return sc;
}
cleanup ()
{
    unlink (rlock);
    exit ();
}
