#

/*
	atof is called with a pointer to an ASCII string.
	It returns the single-precision floating-point number
	represented by the string.
*/

#define	BIG	1671168.	/*2.**20. + 2.**19. + 2.**16. + 2.**15.*/
#define	HUGE	170141183460469231731687303715884105728.	/*2.**127.*/
#define MAXPOW	38	/*10. ** 38. < 2. * 127. < 10. ** 39.*/

float	atof(acp)
char *	acp;
	{
	register char *	cp;
	register int	c;
	int		sign;
	float		x;
	int		xdigits;
	float		y;
	register int	i;
	int		esign;
	int		epart;
	int		flag;

	cp = acp;
	while	((c = *cp) == ' ' || c == '\t')
		cp++;
	sign = 0;
	if	(c == '-')
		{
		sign++;
		cp++;
		}
	x = 0;
	xdigits = 0;
	i = 0;
	while	((c = *cp++) >= '0' && c <= '9')
		if	(x >= BIG)
			i++;
		else	{
			x = x * 10. + c - '0';
			xdigits++;
			}
	if	(c == '.')
		while	((c = *cp++) >= '0' && c <= '9')
			if	(x <= BIG)
				{
				x = x * 10. + c - '0';
				xdigits++;
				--i;
				}
	if	(c == 'E' || c == 'e')
		{
		esign = 0;
		if	(*cp == '-')
			{
			esign++;
			cp++;
			}
		epart = 0;
		while	((c = *cp++ - '0') >= 0 && c <= 9)
			epart = epart * 10 + c;
		if	(esign)
			i =- epart;
		else	i =+ epart;
		}
	while	(i)	/*Using a while allows us to utilize a break*/
		{
		flag = 0;
		if	(i < 0)
			{
			i = -i;
			if	(i > MAXPOW)
				{
				x = 0;
				break;
				}
			flag++;
			}
		else	if	(i + xdigits > MAXPOW)
				{
				x = HUGE;
				break;
				}
		y = 1;
		do	y =* 10.;
			while	(--i);
		if	(flag)
			x =/ y;
		else	x =* y;
		break;
		}
	if	(sign)
		x = -x;
	return(x);
	}
