
 (def cadar (lambda (x) (car (cdar x))))

 (def prog2
      (nlambda ($x$)
        (prog nil
         a    (cond ((null (dtpr $x$)) (return $x$))
                    ((null (cdr $x$))
                     (return (eval (car $x$))))
                    (t (eval (car $x$))
                       (setq $x$ (cdr $x$))
                       (go a))))))

 (def minus (lambda (x) (diff 0 x)))

 (def zerop (lambda (x) (eq x 0)))

 ($mumble nil t)

 (def readlist
      (lambda (x)
       (cond ((dtpr x) (concat (car x) (readlist (cdr x))))
             (t (quote "")))))

 (def cdadar (lambda (x) (cdar (cdar x))))

 (def cddar (lambda (x) (cdr (cdar x))))

 (def not (lambda (x) (null x)))

 (def advance
      (lambda nil
       (rplaca (cdar rules)
               (cond ((null (cdadar rules)) (cddar rules))
                     (t(cdadar rules))))))

 (def analyze
      (lambda nil
       (prog (rules parselist decomp)
             (setq keystack
                   (append keystack
                           (list
                            (get (quote none)
                                 (cond ((zerop
                                         (setq flipflop
                                               (plus 2
                                                     (minus
                                                      flipflop))))
                                        (quote mem))
                                       (t(quote lastresort)))))))
        a    (setq rules (get (car keystack) (quote rules)))
        b    (setq decomp
                   (caar
                    (cond ((atom (car rules))
                           (setq rules
                                 (get (car rules)
                                      (quote rules))))
                          (t rules))))
             (setq parselist nil)
             (cond ((not (test decomp sentence))
                    (setq rules (cdr rules)))
                   ((and (not
                          (atom
                           (car (setq rules (car (advance))))))
                         (not (eq (caar rules) (quote pre))))
                    (return
                     (sentprint (reconstruct (car rules)))))
                   ((not (atom (car rules)))
                    (setq sentence (reconstruct (cadar rules)))
                    (setq rules (cddar rules)))
                   ((eq (car rules) (quote newkey))
                    (setq keystack (cdr keystack))
                    (go a)))
             (go b))))

 (def breakanalyze
      (lambda nil
       (cond ((eq letter (quote "
"))
              (setq flag terminal)
              (setq terminal t))
             ((and (setq flag (get letter (quote punctuation)))
                   keystack)
              (gobble))
             (flag (setq sentence (setq flag nil)))
             (t (setq terminal nil)))))

 (def cleanup
      (lambda nil
       (prog (noblist)
             (setq noblist oblist)
        a    (rplaca noblist (car soblist))
             (cond
              ((setq noblist (cdr noblist))
               (setq soblist (cdr soblist))
               (go a))))))

 (def gobble
      (lambda nil
       (prog nil
        a    (setq letter (lcase (readc)))
             (breakanalyze)
             (cond ((not flag) (go a))))))

 (def initialize
      (lambda nil
       (setq soblist
             (append oblist
                     (setq sentence (setq keystack nil))))))

 (def makesentence
      (lambda nil
       (setq sentence
             (cons (cond ((setq flag
                                (get word (quote translation)))
                          flag)
                         (t word))
                   sentence))))

 (def memory
      (lambda nil
       (prog (parselist x)
             (cond
              ((and (setq rules
                          (get (car keystack) (quote memr)))
                    (test (caar rules) sentence))
               (rplaca (setq x
                             (cdar
                              (get (get (quote none)
                                        (quote mem))
                                   (quote rules))))
                       (append (car x)
                               (list
                                (reconstruct
                                 (caar (advance)))))))))))

 (def readin
      (lambda nil
       (prog (word letter flag terminal)
        a    (cond ((null (readword)) (go b)))
             (makesentence)
             (setkeystack)
        b    (breakanalyze)
             (cond ((not flag) (go a)))
             (setq sentence (reverse sentence)))))

 (def readword
      (lambda nil
       (prog nil
             (setq word nil)
        a    (cond
              ((setq flag
                     (get (setq letter (lcase (readc)))
                          (quote break)))
               (return
                (cond
                 (word
                  (setq word (readlist (reverse word))))))))
             (setq word (cons letter word))
             (go a))))

 (def reconstruct
      (lambda (r)
       (cond ((null r) nil)
             ((numberp (car r))
              (append (reco1 (car r) parselist)
                      (reconstruct (cdr r))))
             (t(cons (car r) (reconstruct (cdr r)))))))

 (def reco1
      (lambda (x p)
       (cond ((greaterp x 1) (reco1 (sub1 x) (cdr p)))
             (t(car p)))))

 (def setkeystack
      (lambda nil
       (cond ((and (setq flag (get word (quote priority)))
                   keystack
                   (greaterp flag
                             (get (car keystack)
                                  (quote priority))))
              (setq keystack (cons word keystack)))
             (flag
              (setq keystack (append keystack (list word)))))))

 (def sentprint
      (lambda (x)
       (prog nil
             (firstword (car x))
             (mapc (function mpatom) (cdr x))
             (mpatom (quote "...") t)
             (terpr))))

 (def mpatom
      (lambda (x f)
       (prog nil
             (patom (quote " "))
             (cond
              ((greaterp (pntlen x)
                         (diff (charcnt) (cond (f 1) (t 4))))
               (terpr)))
             (and (eq x (quote i))
                  (return (patom (quote I))))
             (patom x))))

 (def firstword
      (lambda (x)
       (prog (i l)
             (setq i 2)
             (setq l (nthchar x))
             (patom (ucase (nthchar x 1)))
        a    (and (greaterp i l) (return))
             (patom (nthchar x i))
             (setq i (add1 i))
             (go a))))

 (def ucase
      (lambda (x)
       (cond ((eq x (quote a)) (quote A))
             ((eq x (quote b)) (quote B))
             ((eq x (quote c)) (quote C))
             ((eq x (quote d)) (quote D))
             ((eq x (quote f)) (quote F))
             ((eq x (quote e)) (quote E))
             ((eq x (quote g)) (quote G))
             ((eq x (quote h)) (quote H))
             ((eq x (quote i)) (quote I))
             ((eq x (quote j)) (quote J))
             ((eq x (quote k)) (quote K))
             ((eq x (quote l)) (quote L))
             ((eq x (quote m)) (quote M))
             ((eq x (quote n)) (quote N))
             ((eq x (quote o)) (quote O))
             ((eq x (quote p)) (quote P))
             ((eq x (quote q)) (quote Q))
             ((eq x (quote r)) (quote R))
             ((eq x (quote s)) (quote S))
             ((eq x (quote t)) (quote T))
             ((eq x (quote u)) (quote U))
             ((eq x (quote v)) (quote V))
             ((eq x (quote w)) (quote W))
             ((eq x (quote x)) (quote X))
             ((eq x (quote y)) (quote Y))
             ((eq x (quote z)) (quote Z))
             (t x))))

 (def lcase
      (lambda (x)
       (cond ((eq x (quote A)) (quote a))
             ((eq x (quote B)) (quote b))
             ((eq x (quote C)) (quote c))
             ((eq x (quote D)) (quote d))
             ((eq x (quote E)) (quote e))
             ((eq x (quote F)) (quote f))
             ((eq x (quote G)) (quote g))
             ((eq x (quote H)) (quote h))
             ((eq x (quote I)) (quote i))
             ((eq x (quote J)) (quote j))
             ((eq x (quote K)) (quote k))
             ((eq x (quote L)) (quote l))
             ((eq x (quote M)) (quote m))
             ((eq x (quote N)) (quote n))
             ((eq x (quote O)) (quote o))
             ((eq x (quote P)) (quote p))
             ((eq x (quote Q)) (quote q))
             ((eq x (quote R)) (quote r))
             ((eq x (quote S)) (quote s))
             ((eq x (quote T)) (quote t))
             ((eq x (quote U)) (quote u))
             ((eq x (quote V)) (quote v))
             ((eq x (quote W)) (quote w))
             ((eq x (quote X)) (quote x))
             ((eq x (quote Y)) (quote y))
             ((eq x (quote Z)) (quote z))
             ((eq x (quote eof)) (exit))
             (t x))))

 (def test
      (lambda (d s)
       (prog nil
        g    (cond ((null d)
                    (return
                     (cond
                      ((not s)
                       (setq parselist (reverse parselist))))))
                   ((not
                     (cond ((numberp (car d))
                            (cond ((zerop (car d)) (test5))
                                  (t(test3 (car d) nil))))
                           ((test4 (car d)) (test2))))
                    (return nil)))
             (setq d (cdr d))
             (go g))))

 (def test1
      (lambda (propl x)
       (cond ((null propl) nil)
             ((get x (car propl)) t)
             (t(test1 (cdr propl) x)))))

 (def test2
      (lambda nil
       (prog nil
             (setq parselist (cons (list (car s)) parselist))
             (setq s (cdr s))
             (return t))))

 (def test3
      (lambda (x l)
       (cond ((zerop x)
              (setq parselist (cons (reverse l) parselist)))
             (s
              (test3 (sub1 x)
                     (cons (car s)
                           (prog2 (setq s (cdr s)) l)))))))

 (def test4
      (lambda (d)
       (cond ((null s) nil)
             ((atom d) (eq d (car s)))
             ((car d) (member (car s) d))
             (t(test1 (cdr d) (car s))))))

 (def test5
      (lambda nil
       (prog (l x)
             (cond
              ((null (cdr d))
               (setq parselist (cons s parselist))
               (return (not (setq s nil)))))
        a    (cond ((setq x
                          (prog (parselist)
                                (return (test (cdr d) s))))
                    (setq d (list (setq s nil)))
                    (return
                     (setq parselist
                           (nconc (reverse
                                   (cons (reverse l) x))
                                  parselist))))
                   ((and (setq l (cons (car s) l))
                         (setq s (cdr s)))
                    (go a))))))

 (def worker
      (lambda nil
       (prog (sentence soblist keystack)
        a    (initialize)
             (readin)
		(reclaim)
             (analyze)
		(reclaim)
             (terpr)
             (terpr)
             (cleanup)
             (go a))))

(def defprop
 (nlambda (x)
   (prog (a)
	[cond((null(caar x))(rplaca (car x)(list(car(cddr x))(cadr x)))(return nil]
	(setq a (car (car x)))
loop	(cond	[ (cdr a)
		   (setq a (cdr a))
		   (go loop])
	(rplacd a (cons (car (cdr (cdr x))) (cons (car (cdr x]

(def putprop
 [lambda (a val ind)
   (prog ()
	[cond((null(car a))(rplaca a(list ind val))(return val]
	(setq a (car a))
loop	(cond	[ (eq (car a) ind)
		   (rplaca (cdr a) val)
		   (go end]
		[ (cdr (cdr a))
		   (setq a (cdr (cdr a)))
		   (go loop])
	(rplacd (cdr a) (cons ind (cons val)))
end	(return val]
 ]




(def get (lambda (a ind)
   (prog ()
	(setq a (car a))
loop	(cond	[(eq a nil)(return nil]
		[ (eq (car a) ind)
		   (return (cadr a]
		[ (setq a (cddr a))
		   (go loop]]


(def reverse (lambda (x)
   (prog (temp)
	(cond	[ (or (atom x)
		      (numbp x))
		   (return x]
		[ (null (cdr x))
		   (return (cons (car x]
		[ t
		   (setq temp (reverse (cdr x)))
		   (rplacd (last temp) (cons (car x)))
		   (return temp]]
