#include	"ded.h"

/* second ded source file */

#define	REST 2005	/* resting position of cursor */
extern char *dfile;
extern int	a;
extern int magic;
int eflg;	/* used to toggle between normal and RAND editors */
char *blnks "                                        ";/*40blks*/

name(ap1,ap2)
char *ap1,*ap2;
{
	/* See if two names are the same up to a period "."
	 * in either or both.
	 */
	register char *p1,*p2;
	p1= ap1;
	p2 = ap2;
	while(*p1++ == *p2++ && *p1 != '\0' && *p2 != '\0');
	if(p1<ap1+2) return(0);
	p1--;
	p2--;
	if(*--p1 == '.' || *--p2 == '.')
		return(1); /* of type "prog.o", "prog.c" */
	else {
		if((*(p1+2) == '.' || *(p2+2) == '.')
		  && *(p1+1) == *(p2+1))
			return(1);
			   /* of type "prog", "prog.c" */
		else
			return(0);
	}
}


int ttym[3],otty,ttys;
list(apage) {
	/*
	 * A misnomer: "manage" would be a better name.  List
	 * the dfile entries (except . and ..) and any messages as well as file
	 * types; then call "edit" to see what the user wants to
	 * do.  Argument "apage" is first page to be shown.
	 * List usually gets circumvented via "reset"
	 * by edit; it only returns when the
	 * user wants to leave.  Then it returns the last page shown
	 * so it can be saved in the dfile.
	 */
	int place,page,j;
	register k;
	register char *cp;
	register struct fdir *fsdir;
	char ind,i[4];
	gtty (0, ttym);
	otty = ttym[2]&~040; /* no raw mode */
	otty =| 030;	/* echo and crmod */
	ttym[2] = 0362;	/* raw, no echo */
	stty(0, ttym);
begin:	erase();
	at(220); write(1,"Directory Editor",16);
	ind = 'a';
	i[1] = '.';
	i[2] = i[3] = ' ';
	place = 516;
	page = apage;
	fsdir = d;
	maxp = nent/PSIZ + (nent%PSIZ > 0);
	at(415); printf("Page %d of %d",page,maxp);
	if(flgflg) {
		at(150); printf("%d extra flags",flgflg);
	}
	for(fsdir =+ (page-1)*PSIZ+2; fsdir.inm < a; fsdir++) {
		/* above is PSIZ+2 to skip . and .. */
		/*
		 * below is commented out because a garbage file
		 * name with a first character lexically less than "."
		 * will otherwise cause the display list and the in-core
		 * dfile to be out of sync.
		 */
		/* if(eq(fsdir->fname,".") || eq(fsdir->fname,".."))
			continue;*/
		at(place =+ 100);
		i[0] = ind++;
		write(1,i,4);
		switch(fsdir->type & (C|AS|CHRST|ARCH|DIREC)) {
			case C:
				write(1,"C     ",6);
				break;
			case AS:
				write(1,"as    ",6);
				break;
			case CHRST:
				write(1,"chars ",6);
				break;
			case ARCH:
				write(1,"ar    ",6);
				break;
			case DIREC:
				write(1,"dir   ",6);
				break;
			default:
				write(1,"      ",6);
		}
		switch(fsdir->type & (SRC|OBJ)) {
			case SRC:
				write(1,"src  ",5);
				break;
			case OBJ:
				write(1,"obj  ",5);
				break;
			default:
				if (eq(fsdir->fname,dfile))
					write(1,"spcl ",5);
				else
					write(1,"     ",5);
		}
		k = 0;
		cp = fsdir->fname;
		while(*cp++) k++;
		write(1,fsdir->fname,k);
		if(fsdir->mesg[0]) {
			k = 0;
			cp = fsdir->mesg;
			while(*cp++) k++;
			at(place + 30);
			write(1,fsdir->mesg,k);
		}
		if((place-400)/100 > PSIZ) {
			j = edit(page,maxp);
			if(j<0) return(page);
			if(j > 0) {
				page = j;
				/* take 2 lines instead of 1 to prevent
				   type conversion of d. */
				fsdir = d;
				fsdir =+ (page-1)*PSIZ + 1;
			}
			else
				if(++page > maxp) goto begin;
			erase();
			place = 516;
			ind = 'a';
			at(220); write(1,"Directory Editor",16);
			at(415);
			printf("Page %d of %d",page,maxp);
			if(flgflg) {
				at(150); printf("%d extra flags",flgflg);
			}
		}
	}
	k = maxp;
	if((apage = edit(page,maxp)) < 0) return(k);
	goto begin;
}


edit(apage,amaxp)
{
	/*
	 * "ded" spends most of its time here waiting for input.
	 * Functions are defined in the huge switch statement below.
	 * Ed performs the function and then does a reset in those
	 * cases where new files may have been created (editing,
	 * compiling, etc.).  Either by reset or by return to list,
	 * it indicates what page to display next.  It always saves
	 * status in the dfile first before going to the outside world.
	 * This could be cleverly gotten around, but the amount of
	 * disk I/O involved is negligable compared to the
	 * other problems such as sorting and typing of new files.
	 */
	register char c;
	register struct fdir *fsdir;
	register char *cp;
	int pid, status;

round:	at(REST);
	switch(c = getchar()) {
		case DEL:	/* Leave ded */
			ttym[2] = otty;
			stty(0,ttym);
			return(-1);

		case 'M':	/* get descriptive message for a file */
			getmesg(apage);
			goto round;

		case 'F':	/* set compile flags for files */
			setflg(apage);
			goto round;

		case 'C': case 'A':	/* compile */
			saveall(apage);
			comp(c);
			reset(apage);

		case '!': case '%':	/* Escape to shell (!: 1 line, %: many lines) */
			saveall(apage);
			shell(c);
			reset(apage);

		case 'R': case 'U':	/* do "chdir .." */
			cp = "..";
			goto getstat;

		case 'P': case 'D':	/* do "pwd */
			at(REST-100);
			if( !(pid = fork()))
				execl("/usr/bin/pwd","pwd",0);
			while(pid != wait(&status));
			goto round;

		case 'E':	/* toggle between regular and RAND editors */
			eflg = (eflg?0:1);
			at(250);
			if(eflg) {
				printf("edit is re");
			}
			else {
				printf("edit is em");
			}
			goto round;

		case '\'': case '_':	/* set extra compile flags */
			setcflg();
			return(apage);


		case '\n': case '+':	/* goto next page (to page 1 if on last page) */
			if(apage + 1 > maxp)
				return(1);
			else
				return(apage + 1);

		case '1': case '2': case '3': case '4': case '5':
		case '6': case '7': case '8': case '9':
			/* go forward N pages, if possible */
			if((c = c - '0' + apage) > amaxp)
				goto round;
			else
				return(c);

		case '0':	/* goto page 1 directly */
			return(1);

		case 'a': case 'b': case 'c': case 'd': case 'e':
		case 'f': case 'g': case 'h': case 'i': case 'j':
		case 'k': case 'l': case 'm':
			/* edit file, or change to that directory */
			c =- 'a';
			if(c+3+(apage-1)*PSIZ > (a-d)/sizeof *fsdir) {
				/* c+3 to allow for . and .. */
				goto round;
			}
			c =+ 2;	/* to step over . and .. */
			fsdir = d;	/* two lines to prevent type */
			fsdir =+ c + (apage-1)*PSIZ; /* conversion of d */
			if(fsdir->type & OBJ || fsdir->type & ARCH)
				goto round;
			if(fsdir->type & DIREC) {
				cp = fsdir->fname;
getstat:			stat(cp,&statb);
				c = 0;
				if((getuid()>>8) == statb.uid) {
					if((statb.flgs&0700)==0700)
						c = 1;
				} else {
					if((statb.flgs&07)==07)
						c = 1;
				}
				if(!c) {
					write(1,"bad permissions.",16);
					sleep(1);
					at(REST); write(1,blnks,16);
					goto round;
				}
				saveall(apage);
				write(1,"going...",8);
				chdir(cp);
				reset(1);
			}
			if(eq(fsdir->fname,dfile))
				goto round;
			saveall(apage);
			ed(fsdir);
			reset(apage);

		case '-':	/* back up 1 page */
			if((c = apage - 1) >= 1)
				return(c);
			else
				goto round;

		default:
			goto round;
	}
}


getmesg(apage)
{
	/*
	 * Get a descriptive message for a file.
	 * Validity checking of file index is archetypal.
	 * Since we skip over . and .. entries, all checks
	 * on fsdir must be offset by 2.
	 */
	register char c1;
	register struct fdir *fsdir;
	register int i;
	char c;
	fsdir = d;
	at(2020); printf("Press the letter of the file you");
	at(2120); printf("want to write a description of.");
round:	c = getchar() - 'a' ;
	if(c<0 || c >= PSIZ || (c+3+(apage-1)*PSIZ > (a-d)/sizeof *fsdir)) {
		/* c+3 to skip . and .. */
		at(2220); write(1,"ERROR",5);
		sleep(1);
		at(2220); write(1,blnks,5);
		at(2020); write(1,blnks,40);
		at(2120); write(1,blnks,40);
		return;
	}
	c =+ 2;	/* to step over . and .. */
	fsdir =+ (c + (apage-1)*PSIZ);
	at(414 + 100*c); write(1,"*",1);
	at(2020); write(1,blnks,40);
	at(2120); write(1,blnks,40);
	sleep(1);
	at(2020); write(1,fsdir->fname,16);
	write(1,"   message >>> ",15);
	ttym[2] = otty;
	stty(0,ttym);
	zeroch(fsdir->mesg,12);
	i = 0;
	while((c1 = getchar()) != NL && i < 11) {	/* 11 to allow trailing 0 */
		fsdir->mesg[i++] = c1;
	}
	while(c1 != NL && (c1 = getchar()));
	ttym[2] = 0362;
	stty(0,ttym);
	at(414+100*c); write(1," ",1);
	at(2020); write(1,blnks,40);
	at(446+100*c);
	write(1,fsdir->mesg,12); write(1,blnks,12);
}

zeroch(ap, n)
char *ap;
{
	/*
	 * Primitive character oriented zeroing thing.
	 */
	register char *p;
	register rn;
	register i;
	p = ap;
	i = 0;
	rn = n;
	while(i++ < rn) *p++ = '\0';
}

setflg(apage) {
	/*
	 * Set compilation flags.  We turn it on by setting high-order
	 * bit of flag word, and store any order number in the rest of
	 * the flag word.  If an order is specified files will be
	 * compiled or assembled in that order, otherwise they
	 * will be treated in lexical order.
	 */
	register char c1;
	register struct fdir *fsdir;
	register int i;
	char c;

	fsdir = d;
	for(fsdir =+ (apage-1)*PSIZ+2, c1 = 0 ; c1 < PSIZ && fsdir.inm < a ; fsdir++,c1++) {
		if(fsdir->type&(C|AS) && fsdir->type&SRC) {
			at(408+100*(c1+2));
			if(fsdir->flags) {
				putchar(fsdir->flags + '0');
				write(1,blnks,2);
			}
			else
				write(1,blnks,3);
			printf(fsdir->type < 0 ? "ON ":"OFF");
		}
	}
round:	at(2020); printf("Press letter of file for flag set.");
round1:	at(2126);
	fsdir = d;
	if((c1 = getchar()) == '\n' || c1 == 0177 || c1 == 'F') {
		at(2020); write(1,blnks,40);
		return;
	} else {
		c1 =- 'a';
	}
	if(c1<0 || c1 >= PSIZ || (c1+3+(apage-1)*PSIZ > (a-d)/sizeof *fsdir)) {
		/* c1+3 to allow for . and .. */
		at(2220); write(1,"ERROR",5);
		sleep(1);
		at(2220); write(1,blnks,5);
		at(2020); write(1,blnks,40);
		return;
	}
	c1 =+ 2;	/* to step over . and .. */
	fsdir =+ (c1 + (apage-1)*PSIZ);
	if(!(fsdir->type&(C|AS)) || fsdir->type&OBJ)
		goto round1;
	if(fsdir->type < 0) {
		fsdir->type =& ~0200;
		fsdir->flags = 0;
		at(408+100*c1); write(1,blnks,1);
		at(411+100*c1); write(1,"OFF",3);
		goto round1;
	}
	else {
		fsdir->type =| 0200;
		at(411+100*c1); write(1,"ON ",3);
		at(414 + 100*c1); write(1,"*",1);
		at(2020); write(1,blnks,40);
		at(2020);
		printf("%s: 1-9 to set compile order",fsdir->fname);
	}
	c = c1;
	while((c1 = getchar()) != 'F' && c1 != 0177 ) {
		switch(c1) {
			case '1': case '2': case '3': case '4': case '5':
			case '6': case '7': case '8': case '9':
				fsdir->flags = c1 - '0';
				at(408+100*c); putchar(c1);
				at(414+100*c); write(1,blnks,1);
				at(2020);write(1,blnks,35);
				goto round;

			case '0': case '\n':
				fsdir->flags = 0;
				at(408+100*c); write(1,blnks,1);
				at(414+100*c); write(1,blnks,1);
				goto round;

			default:
				at(414+100*c); write(1,blnks,1);
		}
		goto round;
	}
	at(414+100*c); write(1,blnks,1);
	goto round;
}

texit() {
	/*
	 * Exit routine which resets teletype mode
	 * on the way out.  If ded bombs, the lack
	 * of echo can be particularly frightening.
	 */
	if(otty) {
		ttym[2] = otty;
		stty(0,ttym);
	}
	exit();
}

comp(ac)
char ac;
{
	/*
	 * Compile or assemble files.   First, all the files
	 * which are of the right type and which are turned on
	 * are collected.  In the collection process, surrounding
	 * object files are examined: if they have been more recently
	 * modified than the corresponding source files, it indicates
	 * the source has not been modified since the last compilation,
	 * and hence the object files may be used.  This collection
	 * of files is pointed to by the lexically ordered "files"
	 * structure.  Any specified order flags are then examined and
	 * the argument list is constructed.  If an order flag is
	 * specified it comes before any unordered files.
	 * Prefix and postfix flags are also put in the argument list here.
	 * The assembly
	 * or compilation is done with signals enabled so that it can
	 * be stopped; status is reported afterwards.
	 */
	register struct fdir *fsdir;
	register int type, i;
	int j, k, l;

	zeroch(files, sizeof files);
	i = 0;
	switch(ac) {
		case 'C':
			type = C;
			break;

		case 'A':
			type = AS;
	}
	for(fsdir = d; fsdir.inm < a; fsdir++) {
		if(fsdir->type < 0) {
			if(fsdir->type & type) {
				if(name(fsdir->fname,(fsdir+(type==C?1:-1))->fname)
					&& (fsdir+(type==C?1:-1))->type&OBJ){
				stat(fsdir->fname,&statb);
				stat((fsdir+(type==C?1:-1))->fname,&fdstatb);
				if(statb.modtime > fdstatb.modtime) {
					goto past;
				}
				else {
				files[i].nm = (fsdir+(type==C?1:-1))->fname;
				files[i].fl = fsdir->flags;
				if(i++>NFIL) goto err;
				continue;
				} /* end if(statb... */
				} /* end if(name... */
			past:
				files[i].nm = fsdir->fname;
				files[i].fl = fsdir->flags;
				if(++i >= NFIL) goto err;
			}
		}
	}
	zeroch(argl,sizeof argl);
	argl[0] = (type==C?"cc":"as");
	l = 0;
	for(j = 0; j < NFLAGS; j++) {
		if(preflg[j][0]) {
			argl[++l] = preflg[j];
		}
	}
	for(j = 1; j <= i; j++) {
		for(k = 0; k < i; k++) {
			if(files[k].fl == j) {
				argl[j+l] = files[k].nm;
				goto cont;
			}
		}
		for(k = 0; k < i; k++)
			if(files[k].nm != 0 && files[k].fl == 0) {
				argl[j+l] = files[k].nm;
				files[k].nm = 0;
				goto cont;
			}
cont:;
	}
	for(l = 1;argl[l];l++);
	for(j = 0; j < NFLAGS; j++) {
		if(pstflg[j][0])
			argl[j+l] = pstflg[j];
	}
	erase();
	i = 0;
	while(argl[i]) {
		printf("%s ",argl[i]);
		i++;
	}
	ttym[2] = otty;
	stty(0,ttym);
	if(!(l = fork())) {
		signal(2,0);
		printf("\nCompiling\n");
		if(execv((type==C?"/bin/cc":"/bin/as"),argl) < 0) { perror("\nbombed");
			exit();
		}
	}
	signal(2,1);
	while (l != wait(&j));
	if(j&0377) {
		printf("system: %d\n",j&0377);
	} else {
		printf("user: %d\n",j>>8);
	}
	getchar();
	ttym[2] =| 040;
	stty(0,ttym);
	return;
err:
	printf("too many files\n");
}

ed(ap)
char *ap;
{
	/*
	 * Invoke either "em" (regular editor) or
	 * RAND editor ("re") as specified by argument.
	 * Enable signals in editor to allow halting
	 * of long output.
	 * Note that if file is a charset you get the charset
	 * editor no matter what.
	 */
	register char *fp, *ap1, *ap2;
	int status;

	fp = ap;
	erase();
	ttym[2] = otty;
	stty(0,ttym);
	if(fp->type&CHRST) {
		ap1 = "/bin/chared";
		ap2 = "chared";
	} else {
		ap1 = (eflg?"/usr/bin/re":"/bin/em");
		ap2 = (eflg?"re":"em");
	}
	printf(">> %s %s\n", ap2, fp->fname);
	if(!fork()) {
		signal(2,0);
		execl(ap1, ap2, fp->fname, 0);
		perror("Can't edit");
		getchar();
	}
	signal(2,1);
	wait(&status);
	erase();
}

shell(ac) char ac; {
	/*
	 * Escape to shell.
	 * Take only one line if argument is "!", otherwise
	 * spawn a more permanent shell.  When it exits (via CNTL-D)
	 * ded will wake up as if nothing had happened.  God bless UNIX!
	 */
	register ret, pid;
	register *sig;
	int status;
	char *cp;

	ttym[2] = otty;
	stty(0,ttym);

	at(2001);
	if(ac == '!')
		write(1,"%% ",3);
	if(!(pid = fork())) {
		signal(2,0);
		if(ac == '!')
			cp = "-t";
		else
			cp = 0;
		execl("/bin/sh","ded_sh",cp,0);
	} else {
		sig = signal(2,1);
		while((ret = wait(&status)) != pid);
		signal(2,sig);
	}
	if(ac == '!') {
		printf("\nFinished.\n");
		getchar();
	}
	else
		erase();
	ttym[2] =| 040;
	ttym[2] =& ~010;
	stty(0,ttym);
}

setcflg() {
	/*
	 * Set extra compile flags.  These may be prefix flags
	 * (like "-" for assembler or "-O" for C) or
	 * postfix flags (libraries for C).
	 * flgflg is taken care of (and even saved) so that list
	 * can always inform the user of the existence of such
	 * flags.  Otherwise he may forget about them and
	 * get a nasty surprise.
	 */
	register char c, *cp;
	register i;

	erase();
	at(104); write(1,"prefix",6);
	at(121); write(1,"postfix",7);
	for(c = 'a', i = 0; i < NFLAGS; i++, c++) {
		at(305+100*i);
		printf("%c. %s", c, preflg[i]);
	}
	for(c = 'a'+NFLAGS+1, i = 0; i < NFLAGS; i++, c++) {
		at(320+100*i);
		printf("%c. %s", c, pstflg[i]);
	}
	at(505+100*NFLAGS);
	printf("Press 'letter' to change flag, 'LETTER' to delete flag.");
	at(101);

	for(;;) {
		while((c=getchar())<'a' || c > 'a' + 2*NFLAGS) {

			if(c >= 'A' & c <= 'A'+NFLAGS && *preflg[c-'A']) {
				flgflg--;
				zeroch(preflg[c - 'A'],FLAGSIZ);
				at(308+100*(c-'A')); write(1,blnks,FLAGSIZ);
				at(101);
				continue;
			}
			if(c >= 'A'+NFLAGS+1 && c <= 'A'+2*NFLAGS
				&& *pstflg[c-('A'+NFLAGS+1)]) {
				flgflg--;
				zeroch(pstflg[c-('A'+NFLAGS+1)],FLAGSIZ);
				at(323+100*(c-('A'+NFLAGS+1)));
				write(1,blnks,FLAGSIZ);
				at(101);
				continue;
			}
			if( c == '\n' || c == 0177) {
				getflgs();
				return;
			}
		}

		c =- 'a';
		if(c < NFLAGS+1) {
			cp = preflg + c;
		} else {
			cp = pstflg + (c - (NFLAGS+1));
		}
	

		ttym[2] =| 010;
		ttym[2] =& ~040;
		stty(0,ttym);
		
		i = (c>NFLAGS? 323+(c-NFLAGS-1)*100 : 308+c*100);
		at(i);
		write(1,blnks,FLAGSIZ);
		at(i);

		zeroch(cp,FLAGSIZ);
		read(0,cp,FLAGSIZ);
	
		i = cp;
		while(*cp++ != '\n' && cp<=i+FLAGSIZ);
		*--cp = '\0';
		at(101);
		ttym[2] =| 040;
		ttym[2] =& ~010;
		stty(0,ttym);
	}
}
