#
# include "8080asm.h"

//precidence of operators
# define PAO	2		//AND, OR
# define PPM	2		//+ -
# define PMD	3		//* /
# define PLP	1		// (
# define PRP	4		// )
# define PEE	0		// all other special chars

//global integers for this package
struct it	exitm;		//expression item
int	prcnt;		//paren count
int	rval;		//relocation value
int	etp1,etp2;	//global temps


// expression evaluator
//	call with:
//		address of function to get input
//	returns:
//		item type in itype
//		item value in ival
//		relocation flag in reloc 0=>absolute  1=>relocatable

expr(iploc)
int (*iploc)();
{

	register i, iop, itr;
	int ipr, rv1, rv2, topr, tv1, tv2;

	struct it opstk[32];	//operator stack
	struct it tree[63];		//operand stack

	iop = 0;		//operator stack pointer
	itr = -1;		//tree stack pointer
// form end of expression operator
	opstk[0].itty = ITSP;	//special character
	opstk[0].itop = '.';

// get an input item
exlp:
	while(1) {
		(*iploc)();		//get an input term

// special character
		if(itype==ITSP) {
			ipr = gprc(ival);	//get precidence of character
			if(ipr==PEE)			//end of expression
				break;
			if(ipr==PLP) {		//left paren
				prcnt++;
				iop++;			//up stack pointer
				opstk[iop].wd1=exitm.wd1;	//put operator on stack
				opstk[iop].wd2=exitm.wd2;
				continue;
			}
			if(ipr==PRP) {		//right paren
				prcnt--;		//down one level
exlp1:
				if(opstk[iop].itop == '(') {	//top stk is (
					iop--;		//remove stack
					continue;
				}
				itr++;			//up tree pointer
				tree[itr].wd1 = opstk[iop].wd1;	//move operator
				tree[itr].wd2 = opstk[iop].wd2;
				iop--;			//reduce operand stack
				goto exlp1;
			}
exlp2:
			if(ipr<=gprc(opstk[iop].itop)) {	//higher precidence or equal
				itr++;
				tree[itr].wd1 = opstk[iop].wd1;	//move operator
				tree[itr].wd2 = opstk[iop].wd2;
				iop--;			//reduce operand stack
				goto exlp2;
			}
			else {
				iop++;			//up operator stack
				opstk[iop].wd1 = exitm.wd1;	//put in operator stack
				opstk[iop].wd2 = exitm.wd2;
				continue;
			}
		}
// symbol or constant
		else {
			itr++;		//up tree pointer
			tree[itr].wd1 = exitm.wd1;	//put in tree
			tree[itr].wd2 = exitm.wd2;
			continue;
		}
	}

//output the rest of ther operator stack to the tree
exdn:
	for(i=iop; i>=0; i--) {
		itr++;
		tree[itr].wd1 = opstk[i].wd1;	//move operator
		tree[itr].wd2 = opstk[i].wd2;
	}

// collapse the tree into one entry
exct1:
	for(iop=0; iop<=itr-3; iop++) {
		if(tree[iop].itty==ITSP || tree[iop+1].itty==ITSP ||
			tree[iop+2].itty!=ITSP)  continue;

		tv1 = gval(&tree[iop]);	//get value of first operand
		rv1 = rval;				//relocation value
		tv2 = gval(&tree[iop+1]);	//value of second operand
		rv2 = rval;
		topr = tree[iop+2].itop;	//operator

		switch(topr) {				//operator

		case '+':
			tv1=+ tv2;
			rv1 =| rv2;
			break;

		case '-':
			tv1 =- tv2;
			rv1 =^ rv2;		//exclusive or
			break;

		case '*':			//multiplication
			tv1 =* tv2;
			break;

		case '/':			//division
			tv1 =/ tv2;
			break;

		case '&':			//logical and
			tv1 =& tv2;
			rv1 =^ rv2;
			break;

		case '|':			//logical or
			tv1 =| tv2;
			rv1 =^ rv2;
			break;

		case '%':	//mod
			tv1 =% tv2;
			break;

		case '<':	//left shift
			tv1 =<< tv2;
			break;

		case '>':	//right shift
			tv1 =>> tv2;
			break;

		case '^':	//exclusive or
			tv1 =^ tv2;
			break;

		case '!':	//bit by bit negate
			tv1 = tv2 ^ 0177777;
			break;

		default:			//invalid operator
			abort();
		}

//put new value in tree
		tree[iop].itty = ITCN;		//must be constant
		tree[iop].itop = tv1;		//value
		tree[iop].itrl = rv1;		//relocation value

// push up the rest of the tree
		for(i=iop+1; i<=itr-1; i++) {
			tree[i].wd1 = tree[i+2].wd1;
			tree[i].wd2 = tree[i+2].wd2;
		}
		goto exct1;
	}

// check for empty operand
	if(tree[0].itty==ITSP || tree[0].itop=='.') {
ivexp:
		reloc = 0;
		ival = 0;
		itype = ITCN;
		return;
	}

//check for unary minus and unary plus
	if( tree[1].itty!=ITSP || tree[0].itty==ITSP)
		goto ivexp;		//must be symbol or const followed by operator

	if(tree[1].itop!='.') {		//end of statement
		if(tree[1].itop!='+') {	//ignore unary plus
			if(tree[1].itop=='-')	//unary minus
				tree[0].itop = -gval(&tree[0]);
			else if(tree[1].itop=='!')
					tree[0].itop = gval(&tree[0]) ^ 0177777; //negate
				else
					abort();	//invalid operator
			tree[0].itty = ITCN;
		}
	}

// send results back to caller
	itype = tree[0].itty;
	if(itype==ITCN)			//constant
		ival=gval(&tree[0]);
	else
		ival = tree[0].itop;

	if(itype==ITSY && (ival->flags&SYDF)==0) {	//undefined symbol
		uerr(13);
		goto ivexp;
	}
	reloc = tree[0].itrl;		//relocation value

//if defined symbol get value and say constant
	if(itype==ITSY && (ival->flags&SYXR)==0) {
		reloc = (ival->flags&SYRL) && 1;	//get 0 or 1
		ival = ival->vl1;			//symbol vaue
		itype = ITCN;				//constant
	}
}

// get precidence of a operator
//	call with
//		operator
//	returns
//		precidence

gprc(dprc)
{

	switch(dprc) {

	case '+':
	case '-':
	case '&':		// and
	case '|':		// or
	case '^':		//exclusive or
		return(PPM);

	case '*':
	case '/':
	case '%':		//mod
	case '<':		//left shift
	case '>':		//right shift
	case '!':		//bit by bit negate
		return(PMD);

	case '(':
		return(PLP);

	case ')':
		if(prcnt==0)	//no left parens
			break;
		return(PRP);

	}
	return(PEE);	//end of expression
}

//get value from an it format item
//	call with
//		address of it format item
//	returns
//		the value
//		relocation value in rval
//	calls uerr if it cant get a value

gval(avwrd)
struct it *avwrd;
{

	register struct it *vwrd;

	vwrd = avwrd;
	if(vwrd->itty == ITCN) {		//constant
		rval = vwrd->itrl;
		return(vwrd->itop);			//value
	}
	if(((vwrd->itop)->flags&SYDF) != SYDF || ((vwrd->itop)->flags&SYXR)) {
		uerr(6);
		rval = 0;
		return(0);
	}
	rval = ((vwrd->itop)->flags&SYRL) && 1;
	return((vwrd->itop)->vl1);
}

//get items for expression evaluator (pass one)
//	returns:
//		item type in itype
//		item value in ival
//		item in it format in exitm

p1gi()
{

	if(fcflg)		//used item so must pass it
		gterm();
	if(fcflg==0 && ckspc(fchr)==1) {
		fcflg=1;	//just pass first character
		itype=ITSP;	//special char
		ival=fchr;	//value is the char
	}
	else {	//get a whole term
		fcflg = 0;
		gterm();		//get a term
		if(itype==ITSY) {	// got a symbol
			ival=lemt(sirt);	//look it up in main table
			if(ival==lmte)	//not there before
				mmte();		//put it in table
			else
				if((ival->flags)&SYOP) {	//symbol is an operator
					itype = ITSP;			//transform to operator char
					ival = ival->vl1;
				}
		}
	}
	exitm.itty = itype;
	exitm.itop = ival;
}

// get items for expression evaluator (pass 2)
// returns:
//		item type in itype
//		item value in ival
//		item in it format in exitm

p2gi()
{

	while(1) {
		if(opix==nite) {	//end of statement
			itype = ITSP;	//special char
			ival = ' ';		//blank
			exitm.itty = itype;
			exitm.itop = ival;
			return;
		}
		if((stbuf[opix].wd1) == ITIGN) {	//ignore this it entry
			opix++;
			continue;
		}

		itype = stbuf[opix].itty;	//type
		ival  = stbuf[opix].itop;	//value
			exitm.wd1 = stbuf[opix].wd1;
			exitm.wd2 = stbuf[opix].wd2;
		opix++;
		return;
	}
}

//check for a special character
//	call with
//		character to check
//	returns:
//		0 => character is number or letter
//		1 => special character

ckspc(cksc)
{

	if(cksc>='0' && cksc<='9') return(0);
	if(cksc>='a' && cksc<='z') return(0);
	if(cksc>='A' && cksc<='Z') return(0);
	if(cksc == '$' || cksc == '*') return(0);
	return(1);
}
