#include	"pop.h"

/* Functions that deal with the screen map */

/* stores the character c in the screen
 * map at the current position of
 * the pop specified by p.
 * Only printing characters are output
 * to this function, so control
 * characters are not stored.
 */

/* Need dummy row and dummy column
 * since screen positions are described
 * by integers 1 thru NCHARS and
 * by 1 thru NLINES.
 * Bad planning!
 *
 * The 2D array is a single array
 * of screen lines: this is why it
 * looks back-to-front.
 */

char screenmap[NLINES+1][NCHARS+1];

m_store(c,ap)
char c;
pop *ap;
{
register pop *p;

	p = ap;
	screenmap[p->cv][p->ch] = c;
}


/* This is used for funny
 * functions (do_cline and pborder)
 * which output regardless of the
 * current pop's cursor position.
 * This is all a bit awkward.
 */

m_cstore(c,h,v)
char c;
{
	screenmap[v][h] = c;
}


/* Re-displays current screen state.
 * Called by quit signal in RARE mode.
 * It will not always work properly
 * since the signal might be caught
 * in the middle of s_cursor.
 * The chances are that another quit
 * will clean up properly though.
 */
m_reshow()
{
register h,v;
extern popout;

	pflush();
	s_clear();
	for (v=1; v <= NLINES; v++) {
		s_cursor(1,v);
		for (h=1; h<=NCHARS; h++)
			do_push(screenmap[v][h]);
	}

	pselect(popout);
	pflush();
	signal(3, &m_reshow);		/* reset quit signal */
}



/* Screen map initalization sequence.
 * Sets array to SPACES and sets
 * up quit signal to call screen map
 * reshow function.
 * Remember we are in RARE mode.
 */
m_init()
{
register h,v;
register char c;

	c = SPACE;
	for (v=1; v <= NLINES; v++)
		for (h=1; h <= NCHARS; h++)
			screenmap[v][h] = c;

	signal(3, &m_reshow);
}
