/	.title	mainp2
	.globl		savreg,resreg
/
/ object module for part 2 0f main basic interpreter  8june 72
/
/ globals--emt calls
/
	.globl	crlf00,	prn00,	prln00,	clru00,	push00
	.globl	atoi00,	find00,	txt00,	srl00,	scr00
	.globl	gtdr00,	skip00,	dimc00,	aryl00,	tstu00
	.globl	two00,	tst00,	getv00,	junk00,	movs00
	.globl	atof00,	mls00,	eval00,	put00,	subs00
	.globl	psh00,	srch00,	prnt00,	pck00,	cmpf00
	.globl	addf00,	subf00,	flt00,	fix00,	clos00
/
/ globals--error calls
/
	.globl	goerr,	reterr,	dimerr,	dmverr,	dmderr
	.globl	deferr,	parerr,	ovferr,	ilferr,	nxverr
	.globl	unrerr,	oprerr,	iferr,	prnerr,	inperr
	.globl	in1err,	in2err,	in3err,	reaerr,	re1err
	.globl	re2err,	forerr,	nxterr,	nxmerr,	doerr
	.globl	geterr,	gt1err,	puterr,	gpferr
/
/ globals--returns to main
/
	.globl	init00,	init02,	init03,	init10,	init13
	.globl	old01
/
/ globals--references to fpp
/
	.globl	addf00,	subf00,	mulf00,divf00,	pwrf00
	.globl	sine00,	cos00,	atn00,	expf00,	log00
	.globl	abs00,	sqrt00,	int00,	rnd00,	sgn00
	.globl	ftoa00,	m.i,	fixd00,	fltd00
/
/ globals--system variables
/
	.globl	dati,	lineno,	positn,	runf,	usr
	.globl	r5temp
	.globl	lnkaip,	lnkget,	lnkput
/
/ globals--entry points
/
	.globl	stop00,	run00,	gosb00,	goto00,	res00
	.globl	ret00,	dim00,	def00,	eval00,	gtp00
	.globl	gtdr00,	let00,	if00,	pr00,	inp00
	.globl	read00,	for00,	next00,	rem00,	stop02
	.globl	run01,	do00,	getb00,	putb00
/
/ globals--for user functions
/
	.globl	undaer,	argerr
	.globl	fnm1,	fnm2,	fnm3,	fnm4,	fnm5
	.globl	fnm6,	fnm7,	fnm8,	fnm9,	fnm10
	.globl	fad1,	fad2,	fad3,	fad4,	fad5
	.globl	fad6,	fad7,	fad8,	fad9,	fad10
	.globl	lfn1,	lfn2,	lfn3,	lfn4,	lfn5
	.globl	lfn6,	lfn7,	lfn8,	lfn9,	lfn10
	.globl	lad1,	lad2,	lad3,	lad4,	lad5
	.globl	lad6,	lad7,	lad8,	lad9,	lad10
	.globl	dnm1,	dnm2,	dnm3,	dnm4,	dnm5
	.globl	dnm6,	dnm7,	dnm8,	dnm9,	dnm10
	.globl	dnm11,	dnm12,	dnm13,	dnm14,	dnm15
	.globl	dad1,	dad2,	dad3,	dad4,	dad5
	.globl	dad6,	dad7,	dad8,	dad9,	dad10
	.globl	dad11,	dad12,	dad13,	dad14,	dad15
/
/ part 2 of main interpreter
/
/
/
/
/
/ stop - stop and end statements - tell user program is done
/	registers used - r0,r1,r2,r3,r4
/
stop00:	jsr	pc,clos00/close datasets
	jsr	pc,crlf00
	mov	$stop01,r0	/tell user
	jsr	pc,prn00	/  that all has stopped
	jsr	pc,prln00	/   at some funny place
	jsr	pc,crlf00	/and then
stop02:	clr	lineno
	jmp	init00		/ ask what next
stop01:		<stop at line >

	.byte	0
	.even
/
/ run - start program execution
/	registers used - r5
/
run00:	mov	$1,runf		/turn on run flag
	jsr	pc,skip00	/get next character
	cmp	r2,$12		/a line feed?
	beq	run01		/restart this program
	dec	r1		/reset text pointer
	jmp	old01		/run old program
run01:	jsr	pc,clru00	/clear any remaining user area
	clr	lineno		/clear line number pointer
	mov	usr,r1		/put start of user area
	inc	r1		/ plus one in r1
	mov	$13507,m.i	/reset random number generator
	jmp	init03		/go back and look for line to do
/
/ gosb00 - gosub statement, push class 1 item on stack then do a goto
/	registers used - r0,r1,r2,r3,r4
/
gosb00:	mov	lineno,r0	/get current line number
	bis	$020000,r0	/set class 1 flag
	jsr	pc,push00	/push item on stack
/
/ goto00 - goto statement - reset lineno to new execution point
/	registers used - r0,r1,r2,r3,r4
/
goto00:	jsr	pc,eval00	/computed goto
	jsr	pc,fix00	/expression to integer in r0	
	jsr	pc,find00
	bne	goto01		/line doesn't exist
goto02:	mov	$1,runf		/set the run flag just in case he's
				/trying to start again
	jmp	init13	
goto01:	goerr			/ihlegal goto or gosub
/
/ res00 - restore statement - clear the data pkinter
/	registers used ) nkne
/	
res00:	clr	dati
	br	dim05		/clear data flag and go away
/
/ ret00 - return statement - find last gksub iteiimo hist,
/	get its line number, place in hineno, and delete the item.
/	registers used - r0,r1,r2,r3,r4,r5
/
ret00:	clr	-(sp)		/set up temporary pointer
	mov	$020000,r4	/look for class 1
	jsr	pc,txt00	/get address of list
	beq	ret03		/error if no list
	mov	$017777,r0	/set search mask
ret01:	jsr	pc,srl00	/find a class 1 item
	beq	ret02		/jump if done looking
	mov	r3,*sp		/save location
	tst	(r3)+		/skip over current one
	br	ret01		/look again until last is found
ret02:	mov	(sp)+,r3	/get last address
	beq	ret03		/error
	mov	*r3,r0		/get item
	bic	r4,r0		/clear out class mark
	inc	r0
	mov	$2,r4		/scrunch two bytes
	jsr	pc,scr00	/delete item from user area
	cmp	r0,$1		/is the return to line $1?
	beq	stop02		/yes it came from command mode
	jsr	pc,find00
	br	goto02
ret03:	reterr
/
/ dim statement - generate dimensioned table entry
/	registers used - r0,r1,r2,r3,r4.
/
dim00:	jsr	pc,gtdr00	/get a truncated variable
dim01:	bvs	dim99		/error if ng.
	bne	dim97		/previously declared variable fgund
	mov	r4,-(sp)
	jsr	pc,skip00	/get next character
	cmp	r2,$'(		/is it a left paren
	bne	dim99		/no, error
	jsr	pc,atoi00	/yes, get first dimension
	jsr	pc,dimc00	/check for dimension within bounds
	bne	dim99		/not in bounds
	mov	r0,-(sp)	/put away first dimension
	swab	*sp		/in upper half word
	jsr	pc,skip00	/get last character scanned
	cmpb	r2,$',		/is it a comma?
	bne	dim03		/no
	jsr	pc,atoi00	/get second dimension
	jsr	pc,dimc00	/is it in range?
	bne	dim99		/no
	bis	r0,*sp		/yes, pack it in
	jsr	pc,skip00	/get a character
dim03:	cmp	r2,$')		/no is it a right paren?
	beq	dim04		/yes, get next character
dim99:	dimerr			/bad dimension
dim04:	mov	(sp)+,r2	/get packed dimensions
	mov	(sp)+,r0	/get header
	mov	r1,-(sp)	/save text pointer
	jsr	pc,push00	/push header on list
	mov	r2,r0		/
	jsr	pc,push00	/push packed dimensions on list
	mov	r2,r1
	swab	r1		/get first dimension again
	jsr	pc,aryl00	/compute number of items to jsr	pc,skip00
	bvs	dim98
	jsr	pc,tstu00	/overflow?
	blo	dim98		/yes
	add	r0,r5		/no, update poiter
	mov	r5,r5temp	/save for restart
	mov	(sp)+,r1	/restore text pointer
	jsr	pc,skip00	/get a character
	cmp	r2,$',		/comma?
	beq	dim00		/yes look for next item
	dec	r1		/back up over terminator
dim05:	jmp	init02		/now goaway
dim98:	dmverr			/overflow
dim97:	dmderr			/previously used or declared
/
/ define statements are done here - one table entry is made, conflicts
/	are not checked.  registers used - r1,r2,r4.
/
def00:	jsr	pc,two00	/look for "fn"
	cmp	r4,$"NF		/is it an "fn"?
	bne	def99		/no, bad statement
	jsr	pc,skip00	/get function name
	jsr	pc,tst00	/is it alphabetic?
	beq	def99		/no
	bvs	def99		/no
	bis	$060000,r2	/yes, set class to 3
	mov	r2,r0
	jsr	pc,push00	/put away the header
	jsr	pc,skip00
	cmp	r2,$'(		/is the required left paren present?
	bne	def99		/no
	jsr	pc,getv00	/get the variable name
	bvs	def99		/error if bad variable
	mov	r4,r0
	jsr	pc,push00	/put away the name in word 2
	cmp	r2,$')		/closing paren present?
	bne	def99		/no
	jsr	pc,skip00
	cmp	r2,$'=		/equal sign?
	bne	def99
	mov	r1,r0
	jsr	pc,push00	/put away address of definition
	jsr	pc,junk00	/skip over rest of definition
	br	dim05
def99:	deferr			/horrible error!!!
/
/ eval - eval00, evaluate an arithmetic expression.  upon entry, r1
/	points to the current text position.  on exit, r2,r3, and r4
/	contain the numeric value of the expression.  registers used - all.
/
eval00:	clr	r0
	jsr	pc,push00	/clear the paren count
	sub	$2,r5temp	/restore to start of list
	mov	$-1,-(sp)	/push null (-1) on stack
eval02:	jsr	pc,tstu00	
	blo	eval18
	jsr	pc,skip00	/get a non-blank character
	cmp	r2,$'+		/is this a unary plus?
	beq	eval03		/yes, ignore it
	cmp	r2,$'-		/is it a unary minus?
	bne	eval01		/no
	mov	r2,r0		/yes, set operand2=0
	clr	r2		/and put the
	clr	r3		/ operator in r0
	clr	r4
	br	eval05
eval03:	jsr	pc,skip00	/get acharacter
eval01:	cmp	r2,$'(		/is operand an open paren?
	bne	eval04		/no, get a real operand
	clr	-(sp)		/push a null on the stack
	inc	-2(r5)		/increment the paren count
	br	eval02		/go back and do it again
eval05:	jsr	pc,movs00	/push operand on the stack
	mov	r0,-(sp)	/   operator on stack
	br	eval03		/and go back around
eval04:	dec	r1		/move character pointer back one
	mov	-(r5),-(sp)	/save paren count
	jsr	pc,gtp00	/get an operand
	mov	(sp)+,(r5)+	/restore the paren count
eval12:	mov	r2,-(sp)	/save r2
	jsr	pc,skip00	/get a character
	mov	$eval07+7,r0	/get address of list
gtpr01:	cmpb	-(r0),r2	/is it a legal operator?
	beq	gtpr02		/jump if legal
	cmp	r0,$eval07+1	/has search failed?
	bhi	gtpr01		/no
	clr	r0		/yes - set zero and back up pointer
	dec	r1		/ to point at failure
gtpr03:	mov	(sp)+,r2	/restore r2
	br	eval19		/and continue
gtpr02:	mov	r2,r0		/put a character in r0
	br	gtpr03
eval19:	tst	*sp		/is stack null?
	ble	eval17
eval06:	mov	r1,-(sp)	/save the text pointer
	mov	$eval07+7,r1	/get the table address
eval08:	cmpb	-(r1),r0		/find operator2
	bne	eval08		/it must be found
	asr	r1		/get rid of the byte pointer
	mov	r1,(r5)+	/put result on user list for a while
	mov	$eval07+7,r1	/get table address again
eval09:	cmpb	-(r1),2(sp)	/find operator1
	bne	eval09		/it must be there
	asr	r1		/clear low order bit
	mov	r1,(r5)+	/save it for now
	mov	(sp)+,r1	/restore text pointer
	cmp	-(r5),-(r5)	/compare operator1 with operator2
	blt	eval05		/go back if precedence is wrong
	mov	r0,(r5)+	/save operator2 for now
	mov	$eval07+7,r0
eval10:	cmpb	-(r0),*sp	/find appropriate operator in list
	bne	eval10		/it must be found
	sub	$eval07+2,r0	/get displacement
	asl	r0
	add	$eval11,r0	/we now have the routine address
	mov	r0,(r5)+	/save it
	tst	(sp)+		/discard old operator1
	mov	sp,r0		/get destination address
	jsr	pc,movs00	/put source on the stack
	mov	r1,-(sp)	/save text pointer
	mov	sp,r1		/get
	tst	(r1)+		/source address
	mov	-(r5),r2	/routine address
	mov	-(r5),-(sp)	/save operator2
	jsr	pc,*(r2)		/go compute value
	mov	(sp)+,r0	/restore operator2
	mov	(sp)+,r1	/restore text pointer
	add	$6,sp		/discard source
	mov	(sp)+,r2	/place result
	mov	(sp)+,r3	/ in
	mov	(sp)+,r4	/  operand2
	tst	*sp		/is stack null?
	bgt	eval06		/no, take care of rest of stack
eval17:	cmp	r0,$')		/is operator2 a closed paren?
	beq	eval14		/yes
	tst	r0		/no, is it null?
	bgt	eval05		/not null - go back
	tst	-(r5)		/is the paren count zero?
	bne	eval13		/no
	tst	(sp)+		/pop null
	clc|clv|clz|cln
	rts	pc		/return with result in r2,r3,r4.
eval13:	parerr			/paren count bad
eval14:	tst	-(r5)		/is paren count zero?
	bne	eval15		/no
eval16:	tst	(sp)+		/pop null
	sev			/yes, error - but don't tell user yet
	rts	pc
eval15:	tst	*sp		/jump
	blt	eval16		/if null = -1
	tst	(sp)+		/pop null
	dec	(r5)+		/decrement paren count
	br	eval12		/and do it again
eval18:	ovferr
eval07:	.byte	0,')		/do not
	.byte	'+,'-		/ change
	.byte	'*,'/		/  the order
	.byte	'^		/   of this table
	.even
eval11:	addf00			/this
	subf00			/ table
	mulf00			/  parallels the one
	divf00			/   above, so do not
	pwrf00			/    change its order
/
/
/ getop - gtp00, get an operand. 
/	upon entry, r1 points to the start of
/	an operand.  upon exit, r2,r3,and r4 contain the value of the
/	operand if legal.  if not legal, a fatal error call is made.  on
/	legal or illegal exits, r1 will always point one character after
/	the scan was ended.  note:  this routine must be re-entrant,
/	since it may, by way of calls to "eval", re-enter
/	itself before completion.  registers used - all.

/foroin - subroutine to get a numeric value via float or octal
/used by gtp18 below and fill(subroutine for input and data)
/

foroin:	mov	r1,-(sp)	/save pointer
	jsr	pc,skip00
	mov	(sp)+,r1	/restore pointer
	cmpb	r2,$'#		/test for octal
	beq	atoo00		/yes
	jsr	pc,atof00
	br	foexit		/common exit

atoo00:	mov	r5,-(sp)	/save,r5
	mov	r0,-(sp)	/save r0
	clr	(r0)+		/clear answer
	clr	(r0)+
	clr	-(sp)		/clear intermediate result
	clr	-(sp)

	jsr	pc,skip00	/bypass $
atoo01:	jsr	pc,skip00	/get the next char
	sub	$60,r2		/test for octal
	blt	atoo02		/no-exit
	cmpb	r2,$8.		/test for 8 or more
	bge	atoo02		/end
	mov	(sp),r4		/get intermediate
	mov	2(sp),r5
	ashc	$3,r4		/move up 3 places
	add	r2,r5		/add in new digit
	mov	r4,(sp)		/save intermediate
	mov	r5,2(sp)
	br	atoo01		/loop for next

atoo02:	mov	(sp)+,r3	/result
	mov	(sp)+,r2
	mov	r1,-(sp)	/save r1
	mov	2(sp),r0	/destination
	jsr	pc,fltd00	/double length float
	mov	(sp)+,r1	/restore registers
	mov	(sp)+,r0
	mov	(sp)+,r5
	dec	r1		/set r1 to point to delimiter
	clc|clv|cln|clz			/clear al faults
foexit:	rts	pc		/common exit





/
gtp06:	ilferr
gtp00:	mov	r1,-(sp)	/save text backup pointer
	jsr	pc,skip00	/get first character
	jsr	pc,tst00
	bvs	gtp15		/jump if bad operand
	bne	gtp02		/jump if not numeric
gtp18:	mov	(sp)+,r1	/restore character pointer
	sub	$6,sp		/reserve some space
	mov	sp,r0		/  for the destination
	jsr	pc,foroin	/convert the number - ignoring error flags
	bvs	gtp06
	mov	(sp)+,r2	/get
	mov	(sp)+,r3	/ the
	mov	(sp)+,r4	/  result
	rts	pc
gtp01:	mov	(r0)+,r2	/get
	mov	(r0)+,r3	/ the
	mov	(r0)+,r4	/  number
	rts	pc		/and return
gtp15:	cmp	r2,$'.		/does the number start with "."?
	beq	gtp18		/yes
	cmp	r2,$'#		/test for octal
	beq	gtp18		/yes
	br	gtp19		/jo	
gtp02:	cmp	r2,$'F		/is this a "def"ined function?
	beq	gtp07		/yes - sijce no standard functikn begins with "f"	
	mov	$177700,-(sp)
	bic	*sp,r2		/iask off extra bits
	mov	r2,r0	
	jsr	pc,mls00	/multiphy
	jsr	pc,mls00	/ by 36 here
	jsr	pc,skip00	/get secknd char here
	jsr	pc,tst00
	bvs	gtp11		/go try for a variable
	beq	gtp11		/if jot a function	
	bic	*sp,r2		/make 8 bits into 6
	add	r2,r0		/add it ij iodulo 36	
	jsr	pc,mls00	/multiply by	
	jsr	pc,mls00	/ 36 again
	jsr	pc,skip00	/get third character
	jsr	pc,tst00	/check what it is
	bvs	gtp11		/try for a variable
	bic	(sp)+,r2
	add	r2,r0		/this is the functioncode
	mov	$gtp16,r3	/start of list	
gtp04:	cmp	(r3)+,r0	/is this a good function name?
	beq	gtp05		/yes
	cmp	r3,$gtp17	/search failure?
	blo	gtp04		/no
	br	gtp19		/yes, go try a variable
gtp05:	mov	gtp17-gtp16-2(r3),-(sp)	/save address of function
	cmp	r3,$gtp30	/is it a user function
	bgt	gtp31		/branch if so
	jsr	pc,skip00
	cmp	r2,$'(		/is function legal
	bne	gtp19		/no, go try variable
	jsr	pc,eval00
	bvc	gtp21		/there must be a paren found
gtp23:	mov	(sp)+,r0	/restore jump address
	jsr	pc,movs00	/put away value
	mov	r0,r2
	mov	sp,r0		/source address
	mov	r1,-(sp)	/save text pointer
	mov	r0,r1
	sub	$6,sp
	mov	sp,r0		/destination address
	jsr	pc,*r2		/go do the function
	mov	(sp)+,r2	/get
	mov	(sp)+,r3	/ the
	mov	(sp)+,r4	/  value
	mov	(sp)+,r1	/restore text pointer
gtp24:	add	$10,sp		/get rid of all the junk
	rts	pc
gtp31:	clr	-(sp)		/space for r5
	clr	-(sp)		/zero arg count
	mov	sp,r0		/count address
	mov	$gtp32,-(sp)	/push return address
	jsr	pc,psag00	/push args on stack
	mov	r1,6(r0)	/save r1
	mov	r5,2(r0)	/save r5
	mov	*r0,r1		/arg count
	mov	4(r0),pc	/go do function
gtp32:	mov	(sp)+,r2	/get
	mov	(sp)+,r3	/  the
	mov	(sp)+,r4	/    value
	cmp	(sp)+,(sp)+	/now useless
	mov	(sp)+,r5	/restore r5
	tst	(sp)+		/dont need fun address
	mov	(sp)+,r1	/restore text pointer
	rts	pc
gtp11:	tst	(sp)+		/pop mask from stack
gtp19:	br	gtp09
gtp07:	jsr	pc,skip00	/get second character
	cmp	r2,$'N		/look for an "n"
	bne	gtp09		/go for avariable if something else
	jsr	pc,skip00	/get third character
	jsr	pc,tst00
	bvs	gtp09		/if not alphabetic then
	beq	gtp09		/  go try for a variable
	jsr	pc,txt00	/get address of user storage
	beq	gtp12		/error if no user list
	clr	r0		/set zero mask for the search
	bis	$060000,r2	/set class 3
	mov	r2,r4		/ with function name to find
	jsr	pc,srl00	/search the list for the item
	beq	gtp09		/jump if failure, now try a variable
	tst	(r3)+
	mov	(r3)+,r4	/get name of formal parameter
	mov	(r3)+,-(sp)	/save address of function definition
	jsr	pc,txt00	/get beginning of list again
	jsr	pc,srl00	/search list for the variable
	bne	gtp08		/jump if found
	jsr	pc,skip00
	cmp	r2,$'(
	bne	gtp11		/jump if badness
	mov	r4,-(sp)	/save name of formal parameter
	jsr	pc,eval00	/evaluate actual parameter
	bvs	gtp20		/closed paren must be present here
gtp21:	parerr
gtp20:	mov	(sp)+,r0
	mov	r5,-(sp)
	jsr	pc,push00	/put away
	clr	r0		/the
	jsr	pc,push00	/value
	jsr	pc,put00	/for the formal parameter here
	mov	r1,-(sp)	/save text pointer
	mov	4(sp),r1	/temporary position
	jsr	pc,eval00	/evaluate the function
	bvs	gtp21		/no extra parens allowed here
	mov	(sp)+,r1	/text pointer to r0
	mov	(sp)+,r5	/address of dummy to r5 - delete f.p.
	mov	r5,r5temp	/save for restart
	cmp	(sp)+,(sp)+	/pop def'n address and remember char. pointer
	rts	pc
gtp08:	cmp	(r3)+,(r3)+	/found variable - point to value
	mov	(sp)+,r0	/get address of prototype code
	mov	(r3)+,-(sp)	/save
	mov	(r3)+,-(sp)	/the real
	mov	(r3)+,-(sp)	/ value
	mov	r3,-(sp)	/and the address
	mov	r0,-(sp)	/and the prototype pointer
	jsr	pc,skip00
	cmp	r2,$'(		/is it legal?
	bne	gtp13		/no
	jsr	pc,eval00	/get value of real parameter
	bvc	gtp21		/closed paren must be present
	mov	r1,r0		/save text pointer
	mov	2(sp),r1	/get address of variable
	mov	r4,-(r1)	/put away
	mov	r3,-(r1)	/ parameter
	mov	r2,-(r1)	/  there
	mov	(sp)+,r1	/get prototype text
	mov	r0,-(sp)	/save text pointer on stack
	jsr	pc,eval00	/evaluate function
	bvs	gtp21		/no extra parens allowed here
	mov	(sp)+,r1	/restore text pointer
	mov	(sp)+,r0	/get variable address
	mov	(sp)+,-(r0)	/put
	mov	(sp)+,-(r0)	/ real
	mov	(sp)+,-(r0)	/  variable back where it belongs
	tst	(sp)+		/discard old text pointer
	rts	pc		/and return
gtp09:	mov	(sp)+,r1	/variable, back up pointer to try again
	jsr	pc,gtdr00	/get address of variable
	bvs	gtp12		/non-existent
	beq	gtp12		/ variable here
	jmp	gtp01		/go away again
gtp12:	nxverr			/non-existent variable error - zero assumed
	clr	r2		/set
	clr	r3		/variable
	clr	r4		/to zero
	rts	pc
gtp13:	add	$12,sp		/get rid of any junk on the stack
	br	gtp09
/
gtp14:	undaer			/undefined acquisition function
gtp16:		60602	/sin
		10537	/cos
		03756	/atn
		16300	/exp
		37343	/log
		02553	/abs
		61246	/sqr
		27634	/int
		56434	/rnd
		60472	/sgn
gtp30:		61576	/swr	/start of new functions
		fnm1	/ten slots for user defined funs
		fnm2
		fnm3
		fnm4
		fnm5
		fnm6
		fnm7
		fnm8
		fnm9
		fnm10
gtp17:	sine00
	cos00
	atn00
	expf00
	log00
	abs00
	sqrt00
	int00
	rnd00
	sgn00
	swr00
	fad1
	fad2
	fad3
	fad4
	fad5
	fad6
	fad7
	fad8
	fad9
	fad10
/
/
/ psharg - psag00 pushes arguments enclosed in brackets on stack
/ arg count in r0 incremented for each argument evaluated
/ r1 points to ( at entry, after ) at exit
/ if r1 doesn't point to ( at entry - no operation
/
psag00:	jsr	pc,skip00	/get next character
	cmp	r2,$'(		/any args?
	beq	psag01		/yes, stack them
	dec	r1		/back up text pointer
psag04:	rts	pc		/return
psag01:	mov	r0,-(sp)	/save count address
	jsr	pc,eval00	/evaluate argument
	bvc	psag02		/branch if not finished
	mov	(sp)+,r0	/get count address
	inc	*r0		/one more arg
	mov	r3,-(sp)	/put arg on stack
	mov	r2,-(sp)
	mov	4(sp),-(sp)	/return address
	mov	r4,6(sp)	/slot in r4
	br	psag04		/return
psag02:	mov	(sp)+,r0	/get count address
	mov	r3,-(sp)	/put arg on stack
	mov	r2,-(sp)
	mov	4(sp),-(sp)	/return address
	mov	r4,6(sp)	/slot in r4
	inc	*r0		/one more arg
	jsr	pc,skip00	/get next character
	cmp	r2,$',	/should be a comma
	beq	psag01		/back for another arg
	argerr			/error in argument list
	.data
psag03:		0		/temp for return!!!!!!!!!
	.text
/
/
/ switch register acquisition function
/
swr00:	tst	r1		/check no of args
	beq	swr01		/should be zero
	argerr			/no args wanted
swr01:	sub	$6,sp		/space for result
	sys	38.		/read console switches
	mov	r0,r1		/value for jsr	pc,flt00
	mov	sp,r0		/address for jsr	pc,flt00
	jsr	pc,flt00 			/float it onto stack
	mov	6(sp),pc	/return
/
/
/ rad36p - r36p00 gets code for 3 character name into r0
/ first two characters must be alphabetic,third can be numeric
/ returns ccc if name ok, r1 points after third character
/ returns with v bit set if invalid name
/
r36p00:	jsr	pc,skip00	/get first character
	jsr	pc,tst00	/alphabetic?
	beq	r36p02		/otherwise
	bvs	r36p02		/    invalid return
	mov	$177700,-(sp)	/6 bit mask
	bic	*sp,r2		/mask off extra bits
	mov	r2,r0		/start coding
	jsr	pc,mls00	/multiply by
	jsr	pc,mls00	/    36  here
	jsr	pc,skip00	/get second character
	jsr	pc,tst00	/alphabetic?
	beq	r36p01		/no, invalid
	bvs	r36p01		/       return
	bic	*sp,r2		/only 6 bits
	add	r2,r0		/add in modulo 36
	jsr	pc,mls00	/multiply by
	jsr	pc,mls00	/  36 again
	jsr	pc,skip00	/get third character
	jsr	pc,tst00	/alphanumeric?
	bvs	r36p01		/invalid return
	bic	(sp)+,r2	/get 6 bits
	add	r2,r0		/this is r36p code
	clz|clv|cln|clc			/set ok
	rts	pc
r36p01:	tst	(sp)+		/pop mask
r36p02:	clz|clv|cln|clc
	sev			/v for invalid return
	rts	pc
/
/
/ do00 - do command processor. branches to user
/ routine at dad1 etc. two possibilites - can evaluate args
/ or just pass on pointers
/
do00:	jsr	pc,r36p00	/get name
	bvc	do02		/branch if name ok
do01:	doerr			/error in do call
do02:	mov	$do10,r3	/start of list
do03:	cmp	(r3)+,r0	/is this the name
	beq	do04		/yes
	cmp	r3,$do12	/search failure?
	blo	do03		/no, continue
	br	do01		/name not found
do04:	cmp	r3,$do11	/evaluate or not?
	bgt	do07		/no, simple jump
	clr	-(sp)		/space for r1
	clr	-(sp)		/space for r5
	mov	do12-do10-2(r3),-(sp)	/save jump address
	clr	-(sp)		/zero arg count
	mov	sp,r0		/count address
	mov	$do05,-(sp)	/return address
	jsr	pc,psag00	/push args on stack
	mov	r1,6(r0)	/save r1
	mov	r5,4(r0)	/save r5
	mov	*r0,r1		/set no of args
	mov	2(r0),pc	/go do routine
do05:	cmp	(sp)+,(sp)+	/now useless
	mov	(sp)+,r5	/restore r5
	mov	(sp)+,r1	/restore r1
do06:	jmp	init02		/back for next command
do07:	jsr	pc,*do12-do10-2(r3)	/go do routine
	br	do06		/return
do10:		dnm1		/do name table
		dnm2
		dnm3
		dnm4
		dnm5
		dnm11
		dnm12
		dnm13
		dnm14
		dnm15
do11:		dnm6
		dnm7
		dnm8
		dnm9
		dnm10
do12:	dad1			/do jump table
	dad2
	dad3
	dad4
	dad5
	dad11
	dad12
	dad13
	dad14
	dad15
	dad6
	dad7
	dad8
	dad9
	dad10
/
/
/ getadr - gtdr00, get address of variable/array element - data
/	address returned in r0.  registers used - r0,r1,r2,r3,r4.
/
gtdr00:	jsr	pc,getv00	/get a variable name
	bvs	gtdr03		/exit if in error
	dec	r1		/back up character pointer
	clr	r0		/set zero search mask
	jsr	pc,txt00	/get address of user storage
	beq	gtdr02		/jump if not found
	jsr	pc,srl00	/find the item
	beq	gtdr02		/jump if not there
	cmp	*sp,$dim01	/skip the rest if
	beq	gtdr04		/   called from dim
	tst	(r3)+		/point to subscripts
	cmpb	*r1,$'(		/is there a subscript expression?
	bne	gtdr01		/no
	inc	r1		/skip over open paren
	mov	r4,-(sp)	/save search object
	jsr	pc,subs00	/compute the subscript
	mov	(sp)+,r4
gtdr02:	tst	r0		/set flags
gtdr03:	rts	pc		/return when done
gtdr01:	tst	(r3)+		/point to data address
gtdr04:	mov	r3,r0		/put result in r0
	rts	pc		/and return
/
/ let00 - let statement, evaluate expression and assign a value to a
/	variable.  registers used - all.
/ also evaluate parameters for let control command and jump
/
let02:	mov	(sp)+,r1	/restore r1
	jsr	pc,gtdr00	/get variable address
	bvs	let99		/jump if bad variable
	bne	let01
	mov	r4,r0		/get name
	jsr	pc,psh00	/push variable on the list
let01:	mov	r0,-(sp)	/save data address
	jsr	pc,skip00
	cmp	r2,$'=		/is the "let" ok?
	bne	let99		/no
	jsr	pc,eval00	/yes, evaluate expression
	bvs	let98		/error if mismatched parens
	mov	(sp)+,r0	/get data address
	mov	r2,(r0)+	/put
	mov	r3,(r0)+	/ result
	mov	r4,(r0)+	/  away
	jmp	init02		/go back for next line
let99:	unrerr			/unrecognized statement
let98:	parerr			/mismatched parens
let00:	mov	r1,-(sp)	/save r1
	jsr	pc,r36p00	/try for function
	bvs	let02		/no, try variable
	mov	$let20,r3	/start of list
let10:	cmp	(r3)+,r0	/is this the name?
	beq	let11		/branch if so
	cmp	r3,$let21	/search failure?
	blo	let10		/no, continue
	br	let02		/yes, try variable
let11:	clr	-(sp)		/space for r5
	mov	let21-let20-2(r3),-(sp)	/save address
	clr	-(sp)		/zero argument count
	mov	sp,r0		/address of list
	mov	$let15,-(sp)	/return address
	jsr	pc,psag00	/push args on stack
	jsr	pc,skip00	/get next character
	cmp	r2,$'=		/should be =
	bne	let99		/error if not
	mov	r0,-(sp)	/save list address
	jsr	pc,eval00
	bvs	let98		/parenthesis error
	mov	(sp)+,r0	/restore r0
	mov	r1,6(r0)	/save r1
	mov	r5,4(r0)	/save r5
	mov	*r0,r1		/set no of args
	mov	2(r0),pc	/go do routine
let15:	cmp	(sp)+,(sp)+	/now useless
	mov	(sp)+,r5	/restore r5
	mov	(sp)+,r1	/restore r1
	jmp	init02		/end of let
let20:		lfn1	/	/let name table
		lfn2
		lfn3
		lfn4
		lfn5
		lfn6
		lfn7
		lfn8
		lfn9
		lfn10
let21:	lad1		/	/address table
	lad2
	lad3
	lad4
	lad5
	lad6
	lad7
	lad8
	lad9
	lad10
/
/
/ if <expression><rel-op><expressio> then <stmt>.  compare two
/	expressions and act accordingly.  registers used - all.
/
if00:	jsr	pc,eval00	/evaluate the first part of the statement
	bvs	let98		/illegal paren
	jsr	pc,movs00	/put result on the stack
	jsr	pc,two00	/get the rel-op here
	cmp	r2,$'>		/is it legal?	
	beq	if01		/yes	
	cmp	r2,$'=
	beq	if01		/yes
	dec	r1		/no, back up text pointer
	clrb	r4		/clear ihlegal character
if01:	mov	$if03,r2	/get list of legal forms
if02:	cmp	r4,(r2)+	/is it legal?
	beq	if05		/yes
	cmp	r2,$if04	/did search fail?
	blo	if02		/no
	oprerr			/yes - fatah error
if05:	sub	$if03+2,r2	/get address	
	asl	r2		/of the
	add	$if04,r2	/required test
	mov	r2,-(sp)	/and save it
	jsr	pc,eval00	/get next part of expressikn	
	bvs	let98		/ilhegal paren
	mov	r1,-(sp)	/save text pointer
	mov	sp,r1		/get
	cmp	(r1)+,(r1)+	/ address of source
	jsr	pc,movs00	/put destination on stack
	mov	sp,r0		/destination address
	jsr	pc,cmpf00	/compare floating
	jmp	*10(sp)		/do resulting test
if03:		"><		/ .ne.
		"=<		/ .le.
	.byte	0,'<		/ .lt.
		"=>		/ .ge.
	.byte	0,'>		/ .gt.
	.byte	0,'=		/ .eq.
if04:	bne	if07		/  .ne.
	br	if06
	ble	if07		/  .le.
	br	if06
	blt	if07		/  .lt.
	br	if06
	bge	if07		/  .ge.
	br	if06
	bgt	if07		/  .gt.
	br	if06
	beq	if07		/  .eq.
if06:	add	$6,sp		/pop destination
	mov	(sp)+,r1	/restore text pointer
	add	$10,sp		/pop source
rem00:	jsr	pc,srch00		/skip over rest of line
	dec	r1		/and back up the pointer
	jmp	init02		/and go away (handle remark here too)
if07:	add	$6,sp		/pop destination
	mov	(sp)+,r1	/restore text pointer
	add	$10,sp		/pop source
	jsr	pc,two00	/get two characters
	cmp	r4,$"HT		/is this a "then"?
	bne	if09		/no
	jsr	pc,two00
	cmp	r4,$"NE		/make sure spelling is ok
	bne	if99		/bad if statement
	jsr	pc,skip00	/skip over blanks
	dec	r1		/point at character
	jsr	pc,tst00	/check numeric
	bvs	if08		/must be a code .gt. 140
	bne	if99		/error if alphabetic
if10:	jmp	goto00		/make it a go to
if08:	jmp	init10		/go back to figure out the rest
if09:	cmp	r4,$"OG		/is this a "go"?
	bne	if99		/no, error
	jsr	pc,two00
	cmp	r4,$"OT		/error
	beq	if10		/ if not a "goto"
if99:	iferr			/illegal if

/
/	pr00 - print statement
/
/		registers used 0,1,2,3,4-or all for short
/
/ this is octal output section added by dfk
pr031:	mov	(sp),r1		/back up to beginning for octal
	jsr	pc,two00	/ test oc
	cmp	r4,$"CO
	bne	pr03i		/no
	jsr	pc,two00	/test t_
	cmp	r4,$"$T		/
	bne	pr03i		/no
	jsr	pc,skip00	/test (
	cmpb	r2,$'(
	bne	pr11i		/no-then fail
	jsr	pc,eval00	/get value
	bvc	pr11i		/no )
	jsr	pc,fixd00	/fix it double
	clr	-(sp)		/zero count of characters
	mov	r2,-(sp)	/save it
	mov	r3,-(sp)
	mov	$-36,-(sp)	/initialise shift
	mov	$'#,r2		/print $ 

	jsr	pc,prnt00
pr032:	mov	(sp),r0		/test shift exhausted
	bgt	pr033		/yes
	mov	2(sp),r2	/get number back
	mov	4(sp),r3	/and l.s.
	ashc	r0,r2		/shift it
	cmp	r0,$-36		/test if first-if so 2 not 3 bits
	bne	pr034		/use 3
	bic	$177774,r3	/use 2
	br	pr035
pr034:	bic	$177770,r3	/use 3
pr035:	mov	r3,r2		/convert to char
	bne	pr036		/test if zero
	tst	6(sp)		/if is 0 and no sig chars yet
	beq	pr037		/bypass
pr036:	inc	6(sp)		/set that char sent
	add	$60,r2		/add $60
	jsr	pc,prnt00	/print char
pr037:	add	$3,(sp)		/update shift count
	br	pr032		/loop
pr033:	tst	6(sp)		/test if have sent anything
	bne	pr038		/yes
	mov	$'0,r2		/print 0
	jsr	pc,prnt00
pr038:	add	$12,sp		/restore stack
	mov	$-1,(sp)	/set must find sep next
	br	pr01		/get next item to print

/indirect jumps between print below and octal above
pr03i:	br	pr03
pr11i:	br	pr11
pr031i:	br	pr031


pr00:	clr	-(sp)		/a switch to force a delimiter
pr01:	mov	$34,r0		/make sure this may bytes are available
	jsr	pc,tstu00	/and find out for sure
	blo	pr02		/jump if not available
	jsr	pc,skip00	/get the next character
	cmpb	r2,$',		/check for a valid delimiter
	beq	pr04		/is it a comma?
	cmpb	r2,$';
	beq	pr09		/is it a semi-colon?
	cmpb	r2,$'"
	beq	pr12		/is is a quote?
	cmpb	r2,$':
	beq	pr13		/is it a colon?
	cmpb	r2,$012
	beq	pr13		/is it a <lf>?
	tst	(sp)		/it's not a delimiter
	blt	pr11		/if negative then we wanted one!
	dec	r1		/back up to the start of the expression
	mov	r1,-(sp)	/save r1
	jsr	pc,two00	/get two characters
	cmp	r4,$"HC		/?start of chr_
	bne	pr031		/no, test if oct_
	jsr	pc,two00	/next two characters
	cmp	r4,$"$R	/rest of chr$
	bne	pr031		/no,test oct_
	jsr	pc,skip00
	cmpb	r2,$'(		/should be chr_(
	bne	pr11		/error
	jsr	pc,eval00	/get number
	bvc	pr11		/should be )
	jsr	pc,fix00	/make integer
	mov	r0,r2		/for jsr	pc,prnt00
	bic	$177600,r2	/7 bits max
	jsr	pc,prnt00	/output character
	tst	(sp)+		/restore stack
	mov	$1,(sp)		/no delimeter required
	br	pr01		/continue print
pr03:	mov	(sp)+,r1	/restore r1
	jsr	pc,eval00	/go find the value
	bvs	pr11		/overflow is an error
	mov	r1,-(sp)	/save the text pointer
	jsr	pc,ftoa00
	mov	sp,r0		/the output area was left on the stack
	jsr	pc,prn00
	add	$24,sp		/remove the output area
	mov	(sp)+,r1	/restore the text pointer
	mov	$-1,(sp)	/force a delimiter
	br	pr01

pr04:	mov	positn,r0	/get the position
	cmp	r0,$56.		/we've found a comma
	blt	pr05		/see if there's any more room
	jsr	pc,crlf00
	br	pr09
pr05:	neg	r0		/calculate the mod 14 count
pr06:	bgt	pr07		/add 14 until a positive result
	add	$14.,r0		/add and go again
	br	pr06
pr07:	movb	$040,r2		/output spaces
pr08:	jsr	pc,prnt00
	dec	r0		/decrement the mod 14 counter
	bgt	pr08		/loop if more to do
pr09:	mov	$1,(sp)	/set delimiter found switch
	br	pr01

pr11:	prnerr			/issue fatal error

pr12:	movb	(r1)+,r2	/start to output the literal string
	jsr	pc,prnt00
	cmpb	*r1,$012	/try to find the other end of this mess
	beq	pr11		/line feed before matching " is an error
	cmpb	*r1,$'"
	bne	pr12		/if not <lf> or " go again
	inc	r1		/skip the "
	clr	*sp		/show a quote field exists
	br	pr01

pr13:	tst	(sp)+		/check for trailing delimiter
	bgt	pr14		/negative or zero means crlf
	jsr	pc,crlf00
pr14:	dec	r1		/back up to the terminator
	jmp	init02		/back to the interpreter
pr02:	ovferr			/storage overflow in print
inp00:	
	clr	-(sp)		/set up a land mark
	jsr	pc,com00	/get variable
	bvc	inp02		/it is ok
	inperr			/issue fatal error
inp02:	clr	-(sp)		/set the limits of addresses
	mov	r1,-(sp)	/save the text pointer
inp10:	tst	lnkaip		/using aux inp?
	bne	inp11		/skip ? if so
	mov	$'?,r2		/tell him to get with it
	jsr	pc,prnt00
inp11:	jsr	pc,pck00	/get a line
	jsr	pc,fill00	/try to satisfy the request
	bvs	inp06		/overflow is back data
	bgt	inp04		/too much input typed
	blt	inp05		/not enough input typed
	mov	(sp)+,r1	/recover the test address
	tst	(sp)+		/remove first 0
	tst	(sp)+		/remove a word and check for the end
	bne	.-2		/loop for more
	dec	r1		/back up character pointer
	tst	runf		/check for immediate mode
	bne	inp03		/omit this little bit if running
	movb	$012,*r1
inp03:	jmp	init02

inp04:	in1err			/he typed too much
	br	inp10		/try again
inp05:	in2err			/he didn't type enough
	br	inp10		/try again
inp06:	in3err			/he is a lousy typist
	br	inp10		/try again

fill00:	mov	sp,r4		/use r4 for a while
	cmp	(r4)+,(r4)+	/points to the last zero now
	tst	(r4)+		/points to the last address
	tst	(r4)+		/go find the first 0
	bne	.-2		/loop till found
	tst	-(r4)		/r4 points to the first 0
fill01:	mov	-(r4),r0	/pick up a variable address
	beq	fill06		/not enough data
	mov	r4,-(sp)	/save the list pointer
	jsr	pc,foroin
	bvs	fill99		/i wish he could type
	mov	(sp)+,r4	/restore list pointer
	cmpb	*r1,$',		/check the separator
	beq	fill02		/it's a comma
	cmpb	*r1,$':
	beq	fill03		/it's a colon
	cmpb	*r1,$012	
	beq	fill03		/it's a <lf>
fill05:	sev			/set overflow
fill04:	rts	pc		/return
fill02:	inc	r1		/skip the separator
	br	fill01		/take another conversion
fill03:	mov	-(r4),r0	/see if the next one is valid
	beq	fill04		/exit if kk
	sen			/tell him not enough data
	rts	pc		/return
fill06:	clz|clv|clc|cln			/make more data than var.
	rts	pc		/and exit
fill99:	tst	(sp)+		/remove list pointer
	br	fill05		/and exit
/
/ common expression handler for read and input
/
com00:	jsr	pc,gtdr00	/get name
	bvs	com99		/bad name
	bne	com01		/ok if found
	mov	r4,r0		/set up the name
	jsr	pc,psh00	/push variable on list
com01:	mov	(sp)+,r2	/save return address
	mov	r0,-(sp)	/save the variable address
	mov	$4,r0		/see if four
	jsr	pc,tstu00	/ bytes are available
	blo	com03		/     overflow if not available
	mov	r2,-(sp)	/replace the return address on the stack
	jsr	pc,skip00
	cmpb	r2,$',		/check for a good separator
	beq	com00		/commas are ok
	cmpb	r2,$';		/so is a semi-colon
	beq	com02
	cmpb	r2,$12		/so is a <lf>
	beq	com02
com99:	sev			/set badness
com02:	rts	pc
com03:	ovferr			/overflow
read00:	mov	$1,-(sp)	/a back stop for the landmark
	clr	-(sp)		/a landmark
	jsr	pc,com00
	bvc	read02
read99:	reaerr
read02:	clr	-(sp)
	mov	r1,-(sp)
	mov	dati,r1		/pick up the current pointer
	bne	read03		/start now if we are some where
	mov	usr,r1		/start from the begining
	br	read05		/and look for a data statement
read03:	cmpb	*r1,$12		/next
	beq	read05		/data statement
	jsr	pc,fill00	/go get data
	bvs	read07		/oh no an error
	blt	read04		/branch on not enough data
	mov	r1,dati		/save the pointer for next time
	mov	(sp)+,r1	/get back the text pointer
	tst	(sp)+		/pop the top 0
	tst	(sp)+		/pop to the landmark
	bne	.-2		/loop for maore
	tst	(sp)+		/then go to the back stop
	beq	.-2		/loop for more if any
	dec	r1
	jmp	init02		/back to the boss
read04:	tst	(r4)+		/r4 points to the last good variable
	clr	(r4)+		/clear it and any others to the
	tst	*r4		/land mark we laid down before
	bne	.-4		/loop til we find that 0
read05:	jsr	pc,txt00	/find the upper limit
read06:	cmpb	$145,(r1)+	/is we at a data statement??
	beq	read03		/if so go finish what we started
	cmp	r1,r3		/see if it's all over
	blo	read06		/branch if more text
	re1err			/fatal error
read07:	re2err			/fatal error
/
/ get00 - coding for get command
/
getb00:	clr	-(sp)		/set up landmark
	jsr	pc,com00	/get variable addresses
	bvc	getb01		/ok?
	geterr			/syntax error ij get	
getb01:	clr	-(sp)		/set limit of addresses
	mov	sp,r4		/use r4 for a while
	tst	(r4)+		/points to last address
	tst	(r4)+		/go fijd first zero
	bne	.-2		/loop til found
	tst	-(r4)		/r4 pkints to first zero	
getb02:	mov	-(r4),r0	/pick up a variable address
	beq	getb04		/finished if zero
	jsr	r5,savreg
	mov	lnkget,r0
	sys	read;datget;6	/read it in
	cmp	r0,$6		/must be same as requested
	beq	getb03		/all is ok
	gt1err			/out of data
getb03:	jsr	r5,resreg
	mov	datget,(r0)+	/get
	mov	datget+2,(r0)+	/  the
	mov	datget+4,(r0)	/    data
	br	getb02		/next variable
getb04:	tst	(sp)+		/past zero
	tst	(sp)+		/look for
	bne	.-2		/ next zero
	dec	r1		/reset text pointer
	jmp	init02		/return
	.data
datget:	0;0;0
	.text
/
/ putb00 - coding for put command
/
putb00:	jsr	pc,eval00	/get value
	bvs	putb01		/overflow is error
	mov	r2,datput	/put
	mov	r3,datput+2	/  data 
	mov	r4,datput+4	/    in buffer
	jsr	r5,savreg
	mov	lnkput,r0	/descriptor
	sys	write;datput;6	/do the write
	cmp	r0,$6		/eroor if not same
	bne 	putb02		/error if not zero
	jsr	r5,resreg
	jsr	pc,skip00	/get next character
	cmp	r2,$',		/is it a comma
	beq	putb00		/put another if so
	dec	r1		/back up pointer
	jmp	init02		/return
putb01:	puterr			/illegal put
putb02:	gpferr			/file error
	.data
datput:	0;0;0
	.text
/
/
/ for <variable> = <formula> to <formula> step <formula>.  set up
/	and execute the "for"statement.  registers used - all.
/
for00:	jsr	pc,getv00	/get the control variable
	cmp	r2,$'=		/is it a simple variable?
	bne	for99		/no
	clr	r0		/zero mask
	mov	r4,-(sp)	/save control variable address
	jsr	pc,txt00	/get address of list
	jsr	pc,srl00	/find the variable
	bne	for01		/found it
	mov	r4,r0		/put the variable
	jsr	pc,psh00	/away
	br	for02		/data address in r0
for01:	mov	r3,r0
	cmp	(r0)+,(r0)+	/get data address in r0
for02:	mov	r0,-(sp)	/put it away
	clr	r0		/zero mask
	jsr	pc,txt00
	bis	$040000,r4	/look for the "for" item
	jsr	pc,srl00
	beq	for03		/none there
	mov	r4,-(sp)	/save new header
	mov	r1,-(sp)	/save text pointer
	mov	$20,r4		/delete 16 bytes from the list
	jsr	pc,scr00
	mov	(sp)+,r1	/restore text pointer
	mov	(sp)+,r4		/restore header
for03:	mov	r4,r0
	jsr	pc,push00	/place header on the list
	mov	lineno,r0
	jsr	pc,push00	/line number goes second
	jsr	pc,eval00	/get the starting formula
	mov	*sp,r0		/destination
	mov	r2,(r0)+	/put
	mov	r3,(r0)+	/ away the
	mov	r4,(r0)+	/  value
	jsr	pc,two00	/get two bytes
	cmp	r4,$"OT		/is it a "to"?
	bne	for99		/no
	jsr	pc,eval00	/yes
	jsr	pc,put00	/put ending value away
	cmpb	*r1,$'S		/is this a "step"?
	bne	for05		/no
	jsr	pc,two00	/yes
	cmp	r4,$"TS		/look for "st"
	bne	for99		/not found
	jsr	pc,two00
	cmp	r4,$"PE		/and "ep"
	bne	for99		/not found
	jsr	pc,eval00	/evaluate the step value
for04:	jsr	pc,put00	/put the value away
	br	for06
for05:	clr	r2		/default
	mov	$040000,r3	/ step
	mov	$100001,r4	/  is one
	br	for04
for06:	mov	*sp,r0		/control variable address
	mov	r1,-(sp)	/save text pointer
	mov	r5,r1
	sub	$14,r1		/address of end value
for14:	mov	r1,-(sp)	/save address
	jsr	pc,cmpf00
	beq	for07		/go do loop if variable = end value
	blt	for08		/end less than control
	mov	(sp)+,r1	/get address of end value
	tst	10(r1)		/is the step > 0
	blt	for09		/no, loop is all washed up
	br	for13
for07:	tst	(sp)+		/pop end value address
for13:	mov	(sp)+,r1	/step is ok, go do loop
	cmp	(sp)+,(sp)+	/remove start value and header
for12:	jmp	init02		/go do next statement
for99:	forerr
for08:	mov	(sp)+,r1
	tst	10(r1)		/is step < 0?
	blt	for13		/yes, all is ok
for09:	mov	(sp)+,r1	/restore text pointer
	tst	(sp)+		/pop control variable address
	jsr	pc,txt00	/step is wrong or loop is done
for10:	cmpb	(r1)+,$155	/look for a next
	beq	for11
	cmp	r1,r3		/done?
	blo	for10		/no
	nxterr			/yes, no matching next
for11:	jsr	pc,getv00
	cmp	r4,*sp		/is variable correct?
	bne	for10		/ loop until found or failure
	tst	(sp)+		/we-uns is here boss
for15:	dec	r1
	br	for12		/and is done
/
/ next <simple variable> - terminate the "for" loop
/	registers used - all.
/
next00:	clr	r0		/zero mask
	jsr	pc,getv00	/get the control variable
	mov	r4,-(sp)	/save control variable name
	jsr	pc,txt00
	jsr	pc,srl00	/find the variable
	beq	next99		/next without for
	mov	r3,-(sp)	/save address of variable
	bis	$040000,r4
	jsr	pc,txt00	/find
	jsr	pc,srl00	/the corresponding "for" element
	beq	next99		/not found
	mov	r1,-(sp)	/save text pointer
	cmp	(r3)+,(r3)+	/address of end value
	mov	r3,r1
	add	$6,r1		/get the step
	mov	2(sp),r0	/address
	mov	r3,-(sp)
	cmp	(r0)+,(r0)+	/ of control variable
	mov	r0,-(sp)	/save c.v. addr. temporarily
	jsr	pc,addf00	/add the step to it
	mov	(sp)+,r0
	mov	*sp,r3
	mov	r3,r1
	tst	10(r3)		/check sign of step
	bpl	next02		/positive, do normal compare
	jsr	pc,cmpf00	/do the compare
	bgt	next01		/ backwards
	br	next03
next02:	jsr	pc,cmpf00	/equal?
	blt	next01		/yes, all done
next03:	mov	(sp)+,r0	/"for" address
	tst	(sp)+		/discard text pointer
	mov	r0,-(sp)	/save "for" address
	tst	-(r0)
	mov	*r0,r0		/get line number
	jsr	pc,find00	/find where it belongs
	jsr	pc,junk00	/skip to next statement
	mov	r1,r4		/text pointer to temporary
	mov	(sp)+,r1	/get end value address
	mov	*sp,r0		/control variable address
	mov	r4,-(sp)	/text pointer
	cmp	(r0)+,(r0)+
	br	for14		/go back to check things out
next99:	nxmerr			/next without for
next01:	mov	(sp)+,r1	/get step size
	add	$6,r1		/ here
	mov	2(sp),r0	/and control variable address
	cmp	(r0)+,(r0)+	/ here
	jsr	pc,subf00	/then subtract step to make it right again
	mov	(sp)+,r1	/next is text pointer
	cmp	(sp)+,(sp)+	/discard two more words
	br	for15
/
