/	.title	basfpp
/
/ fpp object module for basic  1 june 72
/

/globls--error calls

	.globl	lnnerr,	dvferr,	fixerr,	logerr,	sqrerr
/
/ globals--entry points
/
	.globl	atof00,	atoi00,	itoa00,	jtoa00,	imul00
	.globl	addf00,	subf00,	negf00,	divf00,	mulf00
	.globl	movf00,	cmpf00,	flt00,	fix00,	fixs00
	.globl	minit,	mfrac,	msetu,	mdopo,	mmove
	.globl	mini2,	mappr,	mdpim,	mdpid,	tst00
	.globl	skip00,	movs00
/
	.globl	sine00,	cos00,	atn00,	expf00,	log00
	.globl	abs00,	sqrt00,	int00,	rnd00,	sgn00
	.globl	pwrf00,	rnd01,	m.i,	ftoa00
        .globl  fixd00, fltd00, fixds0

/
/ globals--returns to main--and system variables
/
	.globl	init02,	rndm
/
/
/ register assignments
/
/
/pdp-11 floating point package
/
rnd00:	mov	r0,-(sp)	/save the destination
	mov	m.i,r0		/get the last number
	mov	m.k,r1		/get the generator
	jsr	pc,imul00
	bic	$100000,r0	/clear sign bit
	mov	r0,m.i		/save for next time
	mov	r0,r1
	mov	*sp,r0		/setup to float
	jsr	pc,flt00
	mov	(sp)+,r0	/pop the destination
	sub	$17,4(r0)	/adjust for fixed point on the right
	rts	pc
m.i:	13507
m.k:	403		/=64*8+3
/
/ randomize statement
/
rnd01:	mov	rndm,m.i	/get the random word
	bis	$1,m.i		/make it odd
	jmp	init02
atof00:	mov	r5,-(sp)	/save r5
	mov	r0,-(sp)	/save the defa
	clr	(r0)+		/clear high order fraction
	clr	(r0)+		/clear low order fraction
	clr	*r0		/clear the exponent
	clr	-(sp)		/clear exp1
	clr	-(sp)		/clear exp2
	clr	-(sp)		/clear the switches
m.afxn:	jsr	pc,skip00	/get a character fron the input string
	cmpb	$105,r2		/look for an e
	beq	m.afe		/branch if an e is found
	cmpb	$55,r2		/look for a minus
	beq	m.afmi		/branch if a minus sign
	cmpb	$53,r2		/look for a plus
	beq	m.afpl		/branch if a plus sign
	cmpb	$56,r2		/look for a decimal point
	beq	m.afd		/branch if a decimal point
	jsr	pc,tst00	/make sure it is numeric
	bne	m.afxt		/error if not numeric
	sub	$60,r2		/convert to a binary number
	mov	r1,-(sp)	/save the sefa
	bit	$4,2(sp)	/test the e switch
	bne	m.afxp		/branch if collecting exponent
	sub	$6,sp		/put a floating point number on stack
	mov	sp,r0		/set up the defa for jsr	pc,flt00
	mov	r2,r1
	jsr	pc,flt00	/float the integer
	mov	16(sp),r0	/get the defa
	mov	$m.ten,r1	/get the address of 10.
	jsr	pc,mulf00	/multiply by 10.
	bvs	m.afvt		/overflow is a no-no
	mov	16(sp),r0	/fix up the defa pointer
	mov	sp,r1		/set up the sefa pointer
	jsr	pc,addf00	/add the current digit
	bit	$10,10(sp)	/test the d switch
	beq	.+6	/->	/if zero don't touch exp2
	dec	12(sp)	/  i	/decrement exp2
	add	$6,sp	/<-	/clear up the stack
m.afss:	mov	(sp)+,r1	/pick up the sefa
	bis	$1,*sp		/set the s switch
	br	m.afnx		/go get more stuff
m.afxp:	mov	r2,-(sp)	/push the current digit
	mov	10(sp),r3	/get the old exponent
	mov	$12,r5		/put decimal 10 in r5
	clr	r2		/clear registers for
	clr	r4		/the big multiply
	cmp	r3,$980.
	bgt	m.afvu
	jsr	pc,mdpim	/multiply by ten
	add	(sp)+,r3	/add the current digit
	mov	r3,6(sp)	/save it back on the stack
	br	m.afss		/set s switch
m.afe:	bit	$4,*sp		/see if thsi is the first e
	bne	m.afvs		/error if more than one e
	bis	$4,*sp		/set the e switch
	bic	$1,*sp		/clear the s switch
	br	m.afnx		/get the next character
m.afd:	bit	$14,*sp		/test e and d switches
	bne	m.afvs		/either one set is an errror
	bis	$10,*sp		/set the d switch
	br	m.afnx		/set start of significance
m.afpl:	bic	$400,*sp	/clear the m switch
	br	.+4	/->	/skip the next instruction
m.afmi:	bis	$400,*sp/  i	/set the m switch
	bit	$4,*sp	/<-	/test the e switch
	bne	m.afse		/branch if sign of the exponent
	bit	$1,*sp
	bne	m.afxt
	bit	$30,*sp		/test the a, d, and s switches
	bne	m.afvs		/if either is set an error is here
	bis	$20,*sp		/set the a switch
	bit	$400,*sp	/test if a minus sign
	beq	m.afnx		/return if plus sign
	bis	$100,*sp	/set minus sign
	br	m.afnx		/get the next character
m.afxt:	br	m.aftx		/darn 11 branches that go no
m.afnx:	br	m.afxn		/further than 128 words
m.afse:	bit	$01,*sp		/test b and s switches
	bne	m.afxt		/error if either is set
	bit	*sp,$40
	bne	m.afvs
	bis	$40,*sp		/set the b switch
	bit	$400,*sp	/test for a minus sign
	beq	m.afnx		/exit if a plus
	bis	$200,*sp	/set minus exponent
	br	m.afnx		/get next character
m.afvs:	bis	$2,*sp		/set v switch
	br	m.afxt
m.afvt:	add	$10,sp		/remove 8 words from the stack
	mov	(sp)+,r1	/restore pointer to text
	br	m.afvs		/set v and exit
m.afvu:	cmp	(sp)+,(sp)+	/pop one word off the stack
	br	m.afvs		/set v and exit
m.aftx:	mov	r1,-(sp)	/save the source pointer
	bit	$100,2(sp)	/see if it should be negative
	beq	m.afx2		/branch of no conversion
	mov	10(sp),r0	/pick up defa
	mov	r0,r1		/make sefa=defa
	jsr	pc,negf00	/negate the number
m.afx2:	bit	$200,2(sp)	/see if a negative exponent
	beq	m.afx3		/branch if no negation
	neg	6(sp)		/negate the exponent
	bvc	m.afx3		/test for valid expontne
	bis	$2,2(sp)		/set the v bit
	br	m.afx5		/exit with error
m.afx3:	add	4(sp),6(sp)	/remember any decimal places
	beq	m.afx5		/branch if no conversion
	blt	m.afdv		/if less then zero divide
m.afx4:	mov	10(sp),r0	/set up defa=$
	mov	$m.ten,r1	/set up sefa=10.
	jsr	pc,mulf00	/multiply by 10.
	dec	6(sp)		/decrement and test
	bgt	m.afx4		/for done
	br	m.afx5		/bypas divide section
m.afdv:	mov	10(sp),r0	/set up defa=$
	mov	$m.ten,r1	/set up sefa=10.
	jsr	pc,divf00	/divide by 10.
	inc	6(sp)		/increment and test
	blt	m.afdv		/for completion 
m.afx5:	mov	(sp)+,r1	/restore the source pointer
	dec	r1		/point to delimiter
	mov	(sp)+,r4	/save the siwtches
	add	$6,sp		/remove 3 more words form the stack
	mov	(sp)+,r5	/restore r5
	bit	$2,r4		/test for v setting
	beq	.+4	/->
	sev			/ascii error
	rts	pc
m.ten:		000000;050000;100004	/floating point 10.
m.one:		000000;040000;100001	/floating point 1.
m.ten6:		000000;075022;100024	/floating point 10.^6
m.ten7:		040000;046113;100030	/floating point 10.^7
m.five:		000000;40000;100000	/floating point .5
ftoa00:	mov	$12,r0		/put some words on the stack
	clr	-(sp)		/clear a word of stack
	dec	r0		/decrement the counter
	bgt	.-4		/loop if more to do
	jsr	pc,movs00
	mov	$030040,10(sp)	/move a sp 0 to the output
	movb	$040,12(sp)	/follow with a space
	tst	r3		/test the sign of the number
	beq	m.xaxt		/if 0 we're done already
	bgt	m.xa1		/if negative make positive
	mov	sp,r0		/point to our number for
	mov	r0,r1		/both source and destination
	jsr	pc,negf00
	movb	$55,10(sp)	/move in a - sign
m.xa1:	mov	$m.ten6,r1	/start the ranging process
	mov	sp,r0		/compare 10^6:$
	jsr	pc,cmpf00
	bgt	m.xa3		/branch if too small
m.xa2:	mov	$m.ten7,r0	/ok ln the low compare
	mov	sp,r1		/compare $:10^7
	jsr	pc,cmpf00
	blt	m.xa4		/branch if ranging is done
	mov	$m.ten,r1
	mov	sp,r0		/divide by 10
	jsr	pc,divf00
	inc	6(sp)		/make the exponent larger
	br	m.xa2		/see if it's in range yet
m.xa3:	mov	$m.ten,r1
	mov	sp,r0		/multiply by 10
	jsr	pc,mulf00
	dec	6(sp)		/make the exponent smaller
	br	m.xa1		/see if it's big enough
m.xa4:	mov	$m.five,r1	/round up with .5
	mov	sp,r0
	jsr	pc,addf00
	sub	$100037,4(sp)
m.xa6:	asr	2(sp)
	ror	(sp)
	inc	4(sp)
	bne	m.xa6
	mov	sp,r0
	add	$16,r0		/point to the output area
	mov	sp,r1		/convert to ascii
	mov	r0,-(sp)	/save r0 for later
	jsr	pc,jtoa00
	mov	(sp)+,r0	/get the output area address
	add	$3,r0		/possible start of significance
	cmpb	$40,*r0
	beq	m.xa5		/branch if all's well
	inc	6(sp)		/signifance starts here
	br	m.xa5+2		/omit standard correction
m.xa5:	inc	r0		/go to the next position
	add	$7,6(sp)	/do a final adjustment to the exponent
	mov	$10,r1		/use r1 to count sigfigs
	mov	r0,r2		/save r0 for latter
	add	$7,r2		/point to last digit+1
	dec	r1		/reduce the sig fig count
	cmpb	$60,-(r2)	/see if it's significant
	beq	.-6		/loop if insignificant
	mov	sp,r4
	add	$11,r4		/move to the real output area
	cmp	$10,6(sp)	/see what format to use
	ble	m.xae		/branch if e format
	cmp	$-10,6(sp)	/check the lower limit too
	bge	m.xae		/branch if e format
	mov	r1,r3		/use a temporary register
	neg	r3
	add	6(sp),r3	/add the exponent
	add	$7,r3		/add constant offset
	blt	m.xae		/branch if ready for e format
	mov	6(sp),r3	/f format for sure
	blt	m.fa1		/if negative shift right
	bgt	m.fa3		/if positive move dec pt right
m.fa4:	movb	$56,(r4)+	/output a dec pt
m.fa0:	movb	(r0)+,(r4)+	/move a digit
	cmp	r0,r2		/see if we are done
	blos	m.fa0		/loop if not
m.fa5:	movb	$040,(r4)+	/insert a trailing space
	clrb	*r4		/follow with a null for printl
m.xaxt:	add	$10,sp		/clean up the stack
	mov	22(sp),pc	/return
m.fa1:	movb	$56,(r4)+	/output a decimal pt
m.fa2:	movb	$60,(r4)+	/output a leading 0
	inc	r3		/decrement negative counter
	blt	m.fa2		/see if done inserting
	br	m.fa0		/go output the significant digits
m.fa3:	movb	(r0)+,(r4)+	/move a digit
	dec	r3		/reduce the count
	bgt	m.fa3		/loop if not done
	cmp	r0,r2		/see if there is any more significance
	blos	m.fa4		/if more continue
	br	m.fa5		/else exit

m.xae:	movb	$56,(r4)+	/output a dec pt
m.ea0:	movb	(r0)+,(r4)+	/output a digit
	cmp	r0,r2		/see if all the good ones are out
	blos	m.ea0		/loop if not
	movb	$105,(r4)+	/output and e
	add	$6,sp		/remove unused stack space
	mov	*sp,r1		/get the exponent
	mov	sp,r0		/go to the output area
	add	$14,r0
	mov	r0,-(sp)	/save r0 the destination
	mov	r4,-(sp)	/save r4 the output area
	jsr	pc,itoa00
	mov	(sp)+,r4	/reasore r4
	mov	(sp)+,r0	/get back all the goodies
m.ea1:	cmpb	(r0)+,$40	/compare with a space
	beq	m.ea1		/loop if a space
	cmpb	-(r0),$55	/see if its -
	beq	m.ea2
	movb	$40,(r4)+	/output a space for a sign
m.ea2:	movb	(r0)+,(r4)+	/output a digit
	cmpb	*r0,$40		/look for the trailing space
	bne	m.ea2		/loop if not done
	movb	$040,(r4)+	/follow the number with a space
	clrb	*r4		/follow with a null
	tst	(sp)+		/clean up the stack
	mov	22(sp),pc	/return
atoi00:	clr	r0		/put the number in r0
m.ainx:	jsr	pc,skip00	/get a character from the input stream
	jsr	pc,tst00	/see if it is in range for a digit
	bne	m.aixt		/all done if non-numeric
	sub	$60,r2		/reduce to a binary value
	asl	r0		/multiply the current number by
	add	r0,r2		/10 via x*2+x*8+current digit
	asl	r0
	asl	r0
	add	r2,r0
	bit	$160000,r0	/test for too big
	beq	m.ainx		/ok if in range
	lnnerr			/line number is really bad
m.aixt:	dec	r1		/reset pointer back one char.
	rts	pc
itoa00:	mov	r0,-(sp)	/save the defa
	clr	-(sp)		/clear high order word
	mov	r1,-(sp)	/move the word
	bge	.+6	/->	/branch if high order bit 0	
	com	2(sp)	/  i	/set all bits in the word
	mov	sp,r1	/<-	/set up the sefa for jtoa call
	sub	$14,sp		/expand the stack for a destination
	mov	sp,r0		/let the stack be the destijation
	jsr	pc,jtoa00	/calh jtoa for the real conversion
	mov	sp,r1		/set up for a move to real defa	
	mov	20(sp),r0	/restore the user's defa
	add	$5,r1		/the first five are spaces
	mov	$7,r2		/total of seven characters to be moved
	movb	(r1)+,(r0)+	/<-	/move a character
	dec	r2		/  i	/decrement counter
	bgt	.-4		/->	/branch if more to do
	add	$22,sp		/remove all junk form the stack
	rts	pc
jtoa00:	mov	r5,-(sp)	/save r5
	mov	r0,-(sp)	/save the defa
	clr	-(sp)		/this is a sign control word
	mov	(r1)+,r3	/get the integer low order
	mov	*r1,r2		/and high order
	bge	.+12	/->	/if negative
	neg	r2	/  i	/reverse the sign
	neg	r3	/  i	/and zot the sign control
	sbc	r2	/  i	/word on the stack
	inc	*sp	/  i
	mov	$12,r5	/<-
	clr	r4
	mov	$-1,-(sp)	/a negitive number for later
m.ja01:	clr	r0		/zero out a bunch of registers
	clr	r1
	jsr	pc,mdpid	/divide by ten
	mov	r1,-(sp)	/push the remainder
	bis	r2,r0		/put all the bits
	bis	r3,r0		/in one register
	tst	r0		/test the quotient for zero
	bne	m.ja01		/branch if more to do
	mov	sp,r5		/now count the mumber of digits
	inc	r4	/<-
	tst	(r5)+	/  i	/we have a negative number somewhere
	bge	.-4	/->
	dec	r4		/be real accurate about this
	mov	$13,r3		/eleven
	sub	r4,r3		/r3 has the number of leading spaces
	dec	r3		/save room for a sign
	mov	2(r5),r0	/restore the lost defa
m.ja02:	tst	r3		/is the count exausted
	ble	m.ja03
	movb	$40,(r0)+	/insert a space (ascii 040)
	dec	r3
	br	m.ja02		/back for some more
m.ja03:	tst	*r5
	beq	m.ja04
	movb	$55,(r0)+	/insert minus sign (ascii 055)
	br	m.ja05
m.ja04:	movb	$40,(r0)+	/or a space for a sign
m.ja05:	add	$60,*sp	/<-	/convert to ascii
	movb	(sp)+,(r0)+/  i	/move to output area
	tst	*sp	/  i	/see if we are done
	bge	.-10	/->	/branch if more to do
	movb	$40,*r0		/follow by a trailing space
	add	$6,sp
	mov	(sp)+,r5	/restore r5
	rts	pc
/single precision integer multiply
/length =     bytes
/execution time =       cycles-typical
/
imul00:	mov	r5,-(sp)	/save r5
	mov	r0,r3		/pick up one operand
	mov	r1,r5	/<-	/pick up the other operand
	clr	r2	/<-	/prepare to
	clr	r4		/multiply
	jsr	pc,mdpim	/go-go-go-zap
	mov	r3,r0	/move the result to 
	mov	r2,r1		/the destination
	mov	(sp)+,r5	/restore r5
	rts	pc
/	subroutine to multiply two double precision integers
/	uses all registers (r0-r5)
/
/		multiplier in r2-r3
/		multiplicand in r4-r5
/		result returned in r0-r1-r2-r3
/
mdpim:	clr	r0		/clear high order words
	clr	r1
	mov	$41,-(sp)	/move 33 dec to counter
m.dp01:	ror	r0
	ror	r1
	ror	r2		/shift to add
	ror	r3
	bcc	m.dp02		/no carry no add
	add	r5,r1
	adc	r0		/add double precision to obtain new partial 
	add	r4,r0		/product
m.dp02:	dec	*sp		/decrement counter
	bne	m.dp01
	tst	(sp)+		/remove the counter
	rts	pc

/	division utility subroutine
/	r0-r1-r2-r2=dividend
/	r4-r5=divisor
/	r0-r1=remainder after division
/	r2-r3=quotient after division
/
mdpid:	mov	$40,-(sp)	/counter for division cycles
	mov	r4,-(sp)	/high order
	mov	r5,-(sp)	/low order divisor to the stack
	neg	2(sp)		/form negative
	neg	*sp		/version of the divisor
	sbc	2(sp)
	add	*sp,r1
	adc	r0		/perform the initial subtraction
	add	2(sp),r0
	bcs	m.dp50		/if carry then overflow has occurred
	clr	-(sp)		/this is a longer lasting carry bit
m.dp40:	rol	r3
	rol	r2
	rol	r1
	rol	r0
	tst	*sp		/test "carry" indicator
	beq	m.dp41		/if no "carry" then add else subtract
	clr	*sp		/clear up for next time
	add	2(sp),r1
	adc	r0		/add -(divisor)
	adc	*sp	/  i	/set "carry"
	add	4(sp),r0/<-
	br	m.dp42
m.dp41:	add	r5,r1
	adc	r0		/add +(divisor)
	adc	*sp	/  i	/set "carry"
	add	r4,r0	/<-
m.dp42:	adc	*sp		/set "carry"
	tst	*sp		/test the update indicator
	beq	.+4	/->	/if zero forget it
	inc	r3	/  i	/no carry possible here
	dec	6(sp)	/<-	/decrement counter
	bgt	m.dp40		/branch if more to do
	ror	r3
	bcs	m.dp44
	add	r5,r1
	adc	r0
	add	r4,r0
	clc
m.dp44:	rol	r3
	add	$10,sp		/adjust stack by 4 words
	clv
	rts	pc
m.dp50:	add	$6,sp
	dvferr
	sev
	rts	pc
addf00:	mov	r5,-(sp)	/save r5
	mov	r0,-(sp)	/save defa
	mov	(r1)+,-(sp)	/move source to r3,r5,expa on stack
	mov	(r1)+,-(sp)
	mov	*r1,-(sp)
	mov	(r0)+,r2	/move destination to r2,r1,r0 in registers
	mov	(r0)+,r1
	mov	*r0,r0
	cmp	r0,*sp		/if r0>expa swap
	blos	m.fad2		/floating point numbers
	mov	sp,r4	
	mov	r0,r3
	mov	*r4,r0
	mov	r3,(r4)+
	mov	r1,r3
	mov	*r4,r1
	mov	r3,(r4)+
	mov	r2,r3
	mov	*r4,r2
	mov	r3,(r4)+
m.fad2:	sub	*sp,r0		/r0=r0-expa
	beq	m.fad8		/if zero omit alignment
	bpl	m.fad3		/if positive then no add
	cmp	r0,$-37
	bge	m.fad4
m.fad3:	mov	2(sp),r5
	mov	4(sp),r3
	br	m.fad7
m.fad4:	cmp	r0,$-20		/if difference between exponents is
				/>15 and <31 do a fast right shift
	bgt	m.fad5		/add 15 to the exponent,move high to
	add	$20,r0
	mov	r1,r2
	clr	r1
	tst	r2
	bpl	m.fad5
	com	r1
m.fad5:	tst	r0		/if difference between exponents is 0
				/then skip r3ignment loop
	beq	m.fad8
m.fad6:	asr	r1		/shift fraction right  and check
	ror	r2		/if exponents are r3igned yet
	inc	r0
	bne	m.fad6
m.fad8:	mov	2(sp),r5	/put fraction a into registers
	mov	4(sp),r3
	add	r2,r3		/do a dour2e precision add to sum
	adc	r5		/the fractions
	bvs	m.fad9
	add	r1,r5
	bvc	.+10	/->	 if an overflow occurs
m.fad1:	ror	r5	/  i	 then shift the carry bit
	ror	r3	/  i	 back into the number and
	inc	*sp	/  i	 increment the exponent
m.fad7:	mov	6(sp),r0/<-	 put defa in a register
	mov	r0,r1		/save defa for later
	mov	r3,(r0)+	/move fraction to destination
	mov	r5,(r0)+
	mov	*sp,(r0)+
	mov	r1,r0		/get un touched defa
	add	$10,sp		/fix up stack
	mov	(sp)+,r5	/restore r5
	jmp	norm00
m.fad9:	add	r1,r5
	bcs	m.fad7		/if a carry no real overflow
	br	m.fad1
/floating point subtraction subroutine.
/length = 26 bytes
/exection time = 32 cycles + addf time

subf00:	mov	r0,r4		/save defa
	sub	$6,sp
	mov	sp,r0
	jsr	pc,negf00	/negate
	mov	r4,r0
	mov	sp,r1
	jsr	pc,addf00	/and add
	add	$6,sp
	rts	pc
/negation subroutine.negates source and puts
/result in destination
/length = 22 bytes

/execution time = 18 cycles
abs00:	jsr	pc,movf00
	tst	2(r1)		/test for negative
	bge	negf01		/exit if positive
negf00:	mov	(r1)+,r2	/move source fraction to registers
	mov	(r1)+,r3	
	neg	r3		/negate fraction in registers
	neg	r2
	sbc	r3
	mov	r2,(r0)+	/move negative fraction to destination
	mov	r3,(r0)+
	mov	(r1)+,(r0)+	/move exponent to destination
negf01:	rts	pc
/
/ sgn00 - get the sign of the operand
/
sgn00:	jsr	pc,movf00	/move to dest.
	mov	$m.ten+6,r1	/address of 1.
	tst	2(r0)		/test original
	bgt	sgn01
	beq	sgn02		/if zero we exit
	jsr	pc,negf00	/store -1.
	rts	pc
sgn01:	jsr	pc,movf00	/store +1.
sgn02:	rts	pc
divf00:	mov	r5,-(sp)	/save r5
	mov	r0,-(sp)	/save defa
	clr	-(sp)		/sign control word
	mov	(r1)+,r5	/pick up the divisor
	mov	(r1)+,r4	/high order word
	tst	r4		/test for division by zero
	beq	m.divv		/division by zero is a no-no
	bge	.+12	/->	if negative
	neg	r4	/  i	change the sign
	neg	r5	/  i	but still keep
	sbc	r4	/  i	track of the original
	inc	*sp	/  i	sign on the stack
	mov	(r0)+,r3/<-
	mov	(r0)+,r2	/pick up the dividend
	beq	m.mul0		/if zero then short divide
	bgt	.+12	/->	if negative
	neg	r2	/  i	change the sign
	neg	r3	/  i	but still keep
	sbc	r2	/  i	track of the original
	dec	*sp	/  i	sign on the stack word
	mov	*r1,r1	/<-	/get the exponents
	neg	r1		/and subtract
	add	*r0,r1		/to check for over-under-flow
	ror	r1		/and put it on the stack
	rol	r1		/when done
	bvc	m.divv
	add	$100000,r1
	mov	r1,-(sp)
	mov	r3,r1
	mov	r2,r0
	clr	r2		/set up to do the divide
	clr	r3
	ror	r0
	ror	r1
	ror	r2
	jsr	pc,mdpid	/call the divide routine
	neg	r4		/change the sign of the divisor
	neg	r5
	sbc	r4
	asl	r1		/double the remainder
	rol	r0
	add	r5,r1		/add -(divisor)
	adc	r0
	add	r4,r0
	blt	m.div2
	add	$1,r3		/round up the result
	adc	r2
m.div2:	clc
	ror	r2
	ror	r3
	inc	*sp
	tst	2(sp)		/check sign  word
	beq	.+10	/->
	neg	r2	/  i
	neg	r3	/  i
	sbc	r2	/  i
	mov	4(sp),r0/<-	 get defa
	mov	r3,(r0)+
	mov	r2,(r0)+
	mov	(sp)+,*r0
	cmp	(sp)+,(sp)+	/fix up the stack pointer
	mov	(sp)+,r5	/restore r5
	cmp	-(r0),-(r0)	/point to the destination
	mov	r0,r1
	jmp	norm00
m.divv:	cmp	(sp)+,(sp)+	/fix up the stack
	dvferr
	mov	(sp)+,r5	/restore r5
	sev
	rts	pc
mulf00:	mov	r5,-(sp)	/save r5
	mov	r0,-(sp)	/save defa
	mov	(r1)+,r5	/fetch source
	mov	(r1)+,r4
	mov	*r1,r1
	clr	-(sp)		/sign control word
	tst	r4
	beq	m.mul0		/short circuit if zero
	bpl	m.mul2		/if neg make positive
	neg	r4		/zip-zap-
	neg	r5		/zowie-and-
	sbc	r4		/swosh
	dec	*sp		/fiddle whith the sign
m.mul2:	mov	(r0)+,r3	/pick up destination
	mov	(r0)+,r2
	beq	m.mul0		/fast if zero
	bpl	m.mul3		/omit sign change if positive
	neg	r2
	neg	r3
	sbc	r2
	inc	*sp		/do a good job on the sign
m.mul3:	add	*r0,r1		/compute a try at the new exponent
	ror	r1
	rol	r1
	bvc	m.divv		/handle over-under-flow
	add	$100000,r1
	mov	r1,-(sp)
	jsr	pc,mdpim	/do the multiplication
	inc	*sp		/adjust the exponent after multiply
m.mul8:	rol	r2		/now normalize
	rol	r1
	rol	r0
	bvs	m.mul4
	dec	*sp
	br	m.mul8
m.mul4:	ror	r0
	ror	r1
	adc	r1		/round off the result
	adc	r0
	bvc	m.mul6
	inc	*sp
	br	m.mul4
m.mul6:	mov	(sp)+,r2	/do the fancy foot work
	tst	(sp)+		/remember the sign word we saved?
	beq	m.mul7		/branch for positive result
	neg	r0
	neg	r1
	sbc	r0
m.mul7:	mov	(sp)+,r3	/we saved the destination for just such a cause
	mov	r1,(r3)+
	mov	r0,(r3)+
	mov	r2,*r3
	mov	(sp)+,r5
	rts	pc
m.mul0:	clr	r0		/quick and dirty
	clr	r1
	clr	r2
	tst	(sp)+		/get rid of the sign control word
	br	m.mul7
/
/ double precision float
/
fltd00: mov     r2,(r0)+
        mov     r3,(r0)+
        mov     $100037,*r0
        br      dfk1

/ conversion of single precision integers to floating point numbers
/
flt00:	clr	(r0)+
	mov	r1,(r0)+
	mov	$100017,*r0
dfk1:   cmp     -(r0),-(r0)
	mov	r0,r1
/
/subroutine to normalize an un-normalized floating point number
/
norm00:	mov	(r1)+,r4	/move source to registers
	mov	(r1)+,r2
	mov	(r1)+,r3
	mov	r3,r1		/save for later check
	tst	r2		/check for a zero fraction
	bne	m.nor2
	tst	r4
	bne	m.nor2
	clr	r3		/return 0.0 cause fraction=0
	br	m.ret2
m.nor2:	inc	r3
m.norl:	dec	r3		/normr4ization loop
	asl	r4		/shift fraction left
	rol	r2
	bvc	m.norl		/normr4ized yet?
	bcc	m.nor3		/specir4 -1 fraction check
	bne	m.nor3		/if not -(2^n) then exit now
	tst	r4
	bne	m.nor4
	sec			/it was -1 to make it -1/2
	ror	r2
	inc	r3
	inc	r1
m.nor4:	sec
m.nor3:	ror	r2
	ror	r4
m.ret2:	mov	r4,(r0)+
	mov	r2,(r0)+
	mov	r3,(r0)+
	cmp	r3,r1
	bhi	.+6	/->	/make sure the value didn't decrease
	clv		/  i
	rts	pc	/  i
	sev		/<-
	rts	pc
/pdp-11 floating point package
/fix,fixd,flt,fltd,cmpf,movef
/
/
/routine for moving floating point numbers from source adddress to
/destination address
/
movf00:	mov r1,r2
	mov r0,r4
	mov (r2)+,(r4)+
	mov (r2)+,(r4)+
	mov (r2)+,(r4)+
	rts	pc

/
/subroutine for comparing two floating point numbers and setting
/the indicators with out modifying either number.the indicators
/are set from the source minus destination.
/
cmpf00:	mov	r1,-(sp)	/save sefa
	jsr	pc,mmove	/put destination on the stack
	mov	sp,r0		/sp is now the defa
	mov	6(sp),r1	/restore sefa to r1
	jsr	pc,subf00		/s-d to top of stack
	mov	2(sp),r1	/save high order fraction in r1
	add	$10,sp		/get rid of trash on stack
	neg	r1		/set the indicators properly
	rts	pc

/subroutine to put the number pointed to by r0 on the stack
/
mmove:	mov	(sp)+,r2	/make stack same height as at call
	add	$6,r0		/make ro point to top of number
	mov	-(r0),-(sp)	/move the number backward to the
	mov	-(r0),-(sp)	/stack so it comes out correctly
	mov	-(r0),-(sp)
	mov	r2,pc		/return fast
int00:	mov	(r1)+,r3	/pick up the number
	mov	(r1)+,r2	/and put it in regesters
	mov	*r1,r4
	bpl	int03		/branch if the answer is zero
	cmp	-(r1),-(r1)
	cmp	r4,$100037	/see if we need to do anything
	bhis	movf00		/branch if no fraction part
	sub	$100037,r4	/compute $ of fraction bits
int01:	asr	r2
	ror	r3
	inc	r4		/  into place
	blt	int01
	mov	r0,r1
	mov	r3,(r0)+
	mov	r2,(r0)+
	mov	$100037,*r0
	mov	r1,r0
	br	norm00
int03:	tst	r2
	bpl	int02
	mov	$m.one,r1
	jmp	negf00
int02:	clr	(r0)+
	clr	(r0)+		/clear three words-flt pt 0.
	clr	(r0)
	rts	pc
/
/ fix- fix00, number in r2,r3,r4 fixed to number in r0.
/	registers used - r0,r1,r2,r3,r4.
/
fixs00:	mov	(r1)+,r2
	mov	(r1)+,r3
	mov	*r1,r4
fix00:	cmp	r4,$100017	/check for exponent too large
	bhi	fix04		/jump if exponent too large
	beq	fix03		/jump if no work needed
	cmp	r4,$100000	/check for zero exponent
	blo	fix05		/jump if zero
	sub	$100017,r4	/generate backwards counter
fix02:	asr	r3		/move it once
	inc	r4
	bne	fix02		/loop until count equals zero
	adc	r3		/ round-added by doug *******
fix03:	mov	r3,r0		/put result in r0
	rts	pc
fix04:	cmp	r4,$100020	/may be -(2^15)
	bne	fix06		/no
	cmp	r3,$140000	/r3 correct for -(2^15)?
	bne	fix06		/no
	asl	r3		/yes
	br	fix03
fix06:	fixerr
fix05:	clr	r0		/result can be zero
	rts	pc
/ double length fix
/ r2,r3,r4 contain fp no
/ answer to r2,r3 as l.s,m.s.
/
fixds0:	mov	(r1)+,r2	/aux route to fixd
	mov	(r1)+,r3
	mov	*r1,r4

fixd00:	cmp	r4,$100037	/check for exponent too large
	bhi	fixd04		/jump if exponent too large
	beq	fixd03		/jump if no work needed



	cmp	r4,$100000	/check for zero exponent
	blo	fixd05		/jump if zero
	sub	$100037,r4	/generate backwards counter
fixd02:	asr	r3		/move it once
	ror	r2		/l.s. uses carry of m.s.
	inc	r4		/count up
	bne	fixd02		/loop until count equals zero
	adc	r2		/round l.s.
	adc	r3		/and m.s.
fixd03:	rts	pc		/exit

fixd04:	cmp	r4,$100040	/may be -(2^31)
	bne	fixd06		/no
	cmp	r3,$140000	/r3 correct for -(2^31)
	bne	fixd06		/no
	asl	r3		/yes
	br	fixd03		/exit

fixd06:	fixerr			/fail - on return set 0
fixd05:	clr	r2		/zero result
	clr	r3		/zero result
	br	fixd03		/exit


/sin,cos,log,exp,sqr,atn
/
/power function
/
pwrf00:	mov	r1,-(sp)	/initialize the stack with defa and sefa
	mov	r0,-(sp)
	sub	$6,sp		/and put room for a number on there too
	mov	r0,r1		/start with ln(a)
	mov	sp,r0		/and put it on the stack
	jsr	pc,log00
	mov	10(sp),r1	/continue with b*ln(a)
	mov	sp,r0
	jsr	pc,mulf00
	mov	6(sp),r0	/finish up with exp(b*ln(a)) to the 
	mov	sp,r1		/destination with stack as source
	jsr	pc,expf00
	add	$12,sp		/one must be neat about the stack
	rts	pc		/off we go into the wild blue yonder!!
/
/floating point natural logarithim routine
/source pointer in r1
/destination pointer in r0
/
log00:	jsr	pc,mini2
	tst 2(r0)		/y .le. 0?
	bgt m.xy
m.yy:	logerr
	add	$4,sp
	rts	pc
m.xy:	mov r0,r1		/does y=1?
	tst (r1)+
	bne m.xx		/does low fraction=0?
	cmp (r1)+,$40000	/yes. does high fraction =40000?
	bne m.xx
	cmp (r1)+,$100001	/yes. does exponent =1?
	bne m.xx
	clr (r0)+		/yes. clear destination
	clr (r0)+
	clr (r0)+
	add $4,sp
	rts	pc
m.xx:	mov 4(r0),-(sp)		/let n=exp (y)
	add	$100000,*sp
	mov	$100000,4(r0)	/let exp (y)=0
	mov *sp,r1		/float n and leave result on stack
	sub $6,sp
	mov sp,r0
	jsr	pc,flt00
	mov 10(sp),r0		/save x on stack
	jsr	pc,mmove
	mov $m.rt2b,r1
	jsr	pc,subf00		/dest=dest-sqr(2)
	mov sp,r0		/let x(stk)=x(stk)+sqr(2)/2
	mov $m.rt2b,r1
	jsr	pc,addf00
	mov 16(sp),r0		/let dest=dest/x(stk)
	mov sp,r1
	jsr	pc,divf00
	mov $m.tabl,r4		/set up setup routine
	mov 16(sp),r0		/loc of destination
	mov $4,r3		/number of constants.
	jsr	pc,msetu
	jsr	pc,mdopo	/evaluate the polynomial
	mov 16(sp),r0		/het dest=dest)(ln 2)/2	
	mov $m.lgb2,r1
	jsr	pc,subf00
	add $6,sp		/pop to floated n
	mov sp,r0
	mov $m.loge,r1		/let n=n*ln 2
	jsr	pc,mulf00	
	mov sp,r1		/let dest=dest+n
	mov 10(sp),r0
	jsr	pc,addf00
m.out:	add $14,sp		/restore sp to original position
	clv
	rts	pc
/
/log	
m.rt2b:	074626;055202;100000	/sqrt(2)/2
m.loge:	005776;054271;100000	/ln 2
m.tabl:	125112;046414;077777	/.300974506336
	007411;063120;077777	/.399659100019
	066333;052525;100000	/.666669470507
	177772;077777;100001	/1.999999993788
expf00:	jsr	pc,mini2	/get pointers
	cmp	4(r0),$100016	/is exp(y)>14
	bhi	m.yy		/yes, error
m.ehee:	mov $m.log2,r1		/no.
	jsr	pc,mfrac	/compute fractional part. result is in dest.
	mov 2(sp),r0		/let y=y*[ln(2)/2]
	mov $m.lgb2,r1
	jsr	pc,mulf00
	mov 2(sp),r0		/save it twice on stack
	jsr	pc,mmove
	jsr	pc,mmove
	mov sp,r0		/let tem1(stk)=a0-y
	mov $m.ma0,r1
	jsr	pc,addf00
	mov sp,r0
	mov r0,r1
	jsr	pc,negf00
	inc 12(sp)		/let num(stk)=2y
	mov 16(sp),r0
	mov r0,r1		/let y=y^2
	jsr	pc,mulf00
/at this point dest =y^2, and a0-y and 2y are on stack
	mov 16(sp),r0		/let dest=dest+b1
	mov $m.bb1,r1
	jsr	pc,addf00
	mov $m.aa1,r0		/move aa1 on stack
	jsr	pc,mmove
	mov sp,r0		/let a1=a1/dest
	mov 24(sp),r1
	jsr	pc,divf00
	mov sp,r0		/let a1=a1+tem1(stk). tem1=a0-y
	mov r0,r1
	add $6,r1
	jsr	pc,addf00
	mov sp,r1		/let num(stk)=/a1. num=2y
	mov r1,r0
	add $14,r0
	jsr	pc,divf00
	add $14,sp		/pop to num
	mov sp,r0
	mov $m.one,r1		/let num=num+1
	jsr	pc,addf00
	mov sp,r0
	mov r0,r1
	jsr	pc,mulf00	/let num=num^2
	mov sp,r1
	mov 10(sp),r0		/move num to dest
	jsr	pc,movf00
	mov 10(sp),r0		/exp(dest)=exp(dest)+int
	add 6(sp),4(r0)
	jmp m.out
/
/exponential
m.log2:	016624;056125;100001	/log(2) e
m.lgb2:	005776;054271;077777	/(ln 2)/2
m.ma0:	037347;117741;100004	/-12.015016753875
m.aa1:	041565;132306;100012	/-601.8042666979565
m.bb1:	026570;074056;100006	/60.09019073192600
/
/evals a polynomial according to parameters on the stack
/$ of constants
/loc of x on stack
/loc of u1 on stack/loc of dest on stack
/starting loc of constants
mdopo:	sub $2,2(sp)
	mov 10(sp),r0		/let dest=dest*k(1)
	mov 12(sp),r1
	mov r0,-(sp)
	jsr	pc,mulf00
m.loop:	add $6,14(sp)		/update cpnstant pointer
	mov *sp,r0		/dest = dest+k(n)
	mov 14(sp),r1
	jsr	pc,addf00
	tst 4(sp)		/test the counter
	beq m.hank		/if it ='s 0 then goto hank
	mov *sp,r0		/dest=dest*u
	mov 10(sp),r1
	jsr	pc,mulf00
	dec 4(sp)		/cntr=cntr-1
	br m.loop		/loop done?
m.hank:	mov *sp,r0		/yes. divide by x
	mov 6(sp),r1
	jsr	pc,mulf00
	tst (sp)+
	mov (sp)+,r3		/save saved r5
	add $26,sp
	mov r3,-(sp)
	rts	pc
/following subroutine pushes the pointers, which are
/contained in r0 and r1 onto the stack, along with a flag.
/it also transfers the source floating word to the dstination
/floating word.
minit:	mov (sp)+,r3		/saved saved r5
	clr -(sp)		/clear a flag
mini3:	mov r1,-(sp)		/push on source pointer
	mov r0,-(sp)		/push on dest pointer
	jsr	pc,movf00	/move source to dest
	mov	r3,pc		/boy can we branch fast
mini2:	mov	(sp)+,r3		/get the return address
	br	mini3

/sets up dopol
/pointer to dest in r0,$ of constants in r3
/loc of first constant in r4
/sets up stack in following manner: 
/			starting loc of constants (top of stack)
/		        loc  of destination
/    		        loc of the contents of destination squared
/		        number of constants
msetu:	mov	(sp)+,r1	/save saved r5
	jsr	pc,mmove	/save x on stack
	mov r1,-(sp)
	mov r4,-(sp)
	mov r3,-(sp)
	mov r0,-(sp)		/save registers
	mov r0,r1
	jsr	pc,mulf00	
	mov (sp)+,r0
	mov (sp)+,r3
	mov (sp)+,r4
	mov (sp)+,r1
	jsr	pc,mmove	/save  xz2 on stack
	mov r4,-(sp)		/push loc of constant pointer
	mov r0,-(sp)		/dest pointer
	mov	$6,-(sp)	/u1 pointer
	add	sp,(sp)
	mov	$16,-(sp)	/x pointer
	add	sp,(sp)
	mov	r3,-(sp)	/cntr
	mov	r1,pc		/branch back
/computes the fractional part of some number times destination.
/r1 points to the number
/r0 points to the destination
/computation is done as follows: dest=dest-int(dest)
mfrac:	mov 2(sp),r0
	jsr	pc,mulf00
	mov (sp)+,2(sp)		/save saved r5
	mov *sp,r1		/put dest pointer in r1
	jsr	pc,fixs00
	mov	r0,-(sp)
	mov *sp,r1		/make r1 point to int
	sub $6,sp		/make room for the floated int which will be put there
	mov sp,r0
	jsr	pc,flt00	/float the int and put result on stack
	mov sp,r1		/let dest=dest-int(dest)
	mov 10(sp),r0
	jsr	pc,subf00
	add $6,sp		/pop past floated int
	mov 4(sp),-(sp)		/restore saved r5
	rts	pc
/
sine00:	jsr	pc,minit	/clear flags, push pointers
m.sin1:	tst 2(r0)		/test y
	bge m.notn		/y<0?
	mov r0,r1
	jsr	pc,negf00	/yes. let y=-y
	inc 4(sp)		/let nflag=1
	br m.note
m.notn:	bne m.note		/y=0?
m.exit:	add $6,sp		/yes. restore sp to starting position
	rts	pc
m.note:	mov $m.pie2,r1		/let y=y*(2/pi)
	jsr	pc,mfrac	/compute fractional part. result will be in dest
/stack has the int part (not floated),and destination has the
/fractional part (known as f)
	mov	(sp)+,r2
	bic $177774,r2		/and 11(base 2) with int
	asl r2
	add $m.tab,r2		/compute address of table of branches
	mov	*r2,pc		/branch to proper place
m.q2:	mov $m.one,r1		/let f=-(f-1)
	mov *sp,r0
	jsr	pc,subf00
m.q3:	mov *sp,r0		/let f=-f
	mov r0,r1
	jsr	pc,negf00
	br m.eval
m.q4:	mov $m.one,r1
	mov *sp,r0
	jsr	pc,subf00		/let f=f-1
/dest now equals x. evaluate the polynomial
m.eval:	mov *sp,r0		/get dest pointer
	mov $m.a11,r4		/pointer to constant table
	mov $6,r3		/number of constants
	jsr	pc,msetu	/set up dopol
	jsr	pc,mdopo
	tst 4(sp)		/was nflag set?
	beq m.exit
	mov *sp,r0
	mov	r0,r1
	jsr	pc,negf00	/yes. let dest=-dest
	br	m.exit
cos00:	jsr	pc,minit	/clear flags, push pointers
	mov $m.pi2,r1	
	jsr	pc,addf00	/let y=pi/2+y
	mov *sp,r0
	br m.sin1
/
/sin
m.tab:	m.eval;m.q2;m.q3;m.q4
m.pie2:	140671;050574;100000	/2/pi
m.a11:	017676;106516;077756	/-.00000341817225
	175316;051777;077764	/.00016021713430
	156214;131513;077771	/-.00468162023910
	167376;050632;077775	/.07969258728630
	006165;126521;100000	/-.64596409264401
m.pi2:	166516;062207;100001	/pi/2
atn00:	clr -(sp)		/clear nflag
	jsr	pc,minit	/clear aflag,push pointers
	tst 2(r0)		/does x=0?
	beq m.tt9
	bge m.p2		/x doesn't =0. is  x<0?
	inc 6(sp)		/x is minus. set nflag
	mov r0,r1		/let x=-x
	jsr	pc,negf00
m.p2:	mov $m.one,r1		/is x>1, or is  x-1>0?
	mov *sp,r0
	jsr	pc,cmpf00
	bge m.p
	inc 4(sp)		/x is >1. set aflag
	mov $m.one,r0		/let x=1/x
	jsr	pc,mmove	/move one onto the stack
	mov sp,r0
	mov 6(sp),r1
	jsr	pc,divf00
	mov sp,r1		/move result back into dest
	mov 6(sp),r0
	jsr	pc,movf00
	add $6,sp		/pop past one
m.p:	mov $m.ot32,r1		/is x<2-sqt(3), or is x-[2-sqt(3)]<0?
	mov *sp,r0
	jsr	pc,cmpf00
	ble m.br4
	clr -(sp)		/it is. let c=0
	clr -(sp)
	clr -(sp)
	br m.eva1
/let x=[x*sqt(3)-1]/[x+sqt(3)]
/let c=pi/6
m.br4:	mov $m.pi6,r0
	jsr	pc,mmove	/move pi6 onto the stack
	mov 6(sp),r0
	jsr	pc,mmove	/save x on stack
	mov $m.rot3,r1
	jsr	pc,mulf00	/let dest=dest*sqt(3)
	mov 14(sp),r0
	mov $m.one,r1		/let dest=dest-1
	jsr	pc,subf00
/dest now ='s x*sqt(3)-1
/compute x+sqt(3)
	mov sp,r0
	mov $m.rot3,r1
	jsr	pc,addf00
	mov 14(sp),r0		/divide dest by x+sqt(3)
	mov sp,r1
	jsr	pc,divf00
	add $6,sp		/pop up to c

/
/eval the polynomial
m.eva1:	mov 6(sp),r0		/pointer to dest
	mov $m.tab2,r4		/pointer toconstant table
	mov $5,r3		/number of constants
	jsr	pc,msetu	/set up dopol
	jsr	pc,mdopo
	mov sp,r1		/let dest=dest+c
	mov 6(sp),r0
	jsr	pc,addf00
	add $6,sp		/pop past c
	tst 4(sp)		/aflag=0?
	beq m.p6
	mov *sp,r0		/no.let dest=pi/2-dest
	mov $m.pi2,r1
	jsr	pc,subf00
	mov *sp,r0
	mov r0,r1
	jsr	pc,negf00
m.p6:	tst 6(sp)		/was nflag set?
	beq m.tt9
	mov *sp,r0
	mov r0,r1
	jsr	pc,negf00	/let dest=-dest
m.tt9:	add $10,sp
	clv
	rts	pc
/
/arctan
m.ot32:	050574;042230;077777	/2-sqrt(3)
m.rot3:	165640;067331;100001	/sqrt(3)
m.pi6:	044336;041405;100000	/pi/6
m.tab2:	113440;060462;077775	/.09491954952
	107717;133556;077776	/-.14173460613
	155646;063141;077776	/.19996534780
	131012;125252;077777	/-.33333289364
	177776;077777;100000	/.99999999843
sqrt00:	jsr	pc,minit	/clear nflag,push pointers.
	tst 2(r0)		/is x<0?
	beq	m.br3
	bge m.br1
	inc 4(sp)		/yes .set nflag
	mov r0,r1
	jsr	pc,negf00	/let x=-x
m.br1:	clr 2(sp)		/clear oflag
	mov *sp,r0
	cmp	(r0)+,(r0)+
	add	$100000,*r0
	asr	*r0		/shift exp(x) once right to see if is odd and
	adc	2(sp)
	mov *r0,-(sp)		/to divide it by two. save it on stack
	mov	$100000,*r0	/let exp(x)=0.
	mov 2(sp),r0		/save x on the stack
	jsr	pc,mmove
	mov $m.bb,r1		/let x=b*x
	jsr	pc,mulf00
	mov 10(sp),r0
	mov $m.aa,r1		/let x=x+a
	jsr	pc,addf00
	jsr	pc,mappr	/do first approximation
	jsr	pc,mappr	/do second iteration
	jsr	pc,mappr	/boy oh boy are we precise today!
	add 6(sp),4(r0)		/add saved expoonent to exp(dest)
	add $10,sp
	tst 2(sp)		/was oflag set
	beq m.br2
	mov $m.root,r1		/yes. mult by sqt(2)
	jsr	pc,mulf00
m.br2:	tst 4(sp)		/was nflag set?
	beq	m.br3
	sqrerr
m.br3:	add	$6,sp
	clv
	rts	pc
/subroutine performs an approximation
/of the form y0=.5(y0+x/y0)
/
mappr:	mov	sp,r0
	tst (r0)+		/add 2 to r0
	jsr	pc,mmove	/save x on stack
	mov sp,r0		/set up destination
	mov 20(sp),r1		/set up source
	jsr	pc,divf00	/compute x/y0
	mov sp,r1
	mov 20(sp),r0
	jsr	pc,addf00	/let y0=y0+x/y0
	mov 20(sp),r0
	dec 4(r0)
	add $6,sp
	rts	pc
/
/square root
m.root:	074626;055202;100001	/sqrt(2)
m.aa:	125672;065324;077777	/.41730760
m.bb:	067102;045612;100000	/.59016207
/
