#

/*	software for the 'Dazzler' video device
 *	takes mini-explor picture and maps it into
 *	a 64x64 array of 4bit values
 *	which are Dazzler-Altair code for color and
 *	intensity.
 *
 *	For information, contact
 *	Prof. Lou Katz
 *	Columbia University
 *	College of Physicians & Surgeons
 *	630 West 168 Street
 *	New York, N.Y. 10032
 *
 *	212-694-3501
 *
 *	April  14, 1976
 *	Note that EXPLOR array has y=0 at bottom, and
 *	Dazzler has y=0 at top, so that Dazzler(y) = 63 - EXPLOR(y)
 *
 *	Note also that dazzler documentation does not correspond
 *	to actual performance.  Color output corresponds to
 *	red-green-blue-intensity, not red-blue-green-intensity
 */

char d_vid[64][64];
int d_opt[4] { 0,1,2,3 };
int d_color[4] { 01,02,04,010 };

setopt(v0,v1,v2,v3)
{
	dzset(v0,v1,v2,v3,&d_opt[0]);
}
color(v0,v1,v2,v3)
{
	dzset(v0,v1,v2,v3,&d_color);
}


dzset(v0,v1,v2,v3,array)
int *array;
{
	register int *vp;

	vp = array;
	*vp++ = v0;
	*vp++ = v1;
	*vp++ = v2;
	*vp = v3;
}

/* routines to setup and transmit dazzler information
 * lk and jf
 * march 1976
 */

char table[16] {
	' ','r','g','y','b','m','c','w',
	'+','R','G','Y','B','M','C','W'
};

dazzle(ix,iy,iw,ih,hue)
char hue;
{
	char value,bit;
	register int xl,yh;


	switch(hue) {

case 'i':	/* intensity */
		bit = 010;
		break;
case 'g':
		bit = 02;
		break;
case 'b':	/* blue */
		bit = 04;
		break;
case 'r':
		bit = 01;
		break;
case 'G':
		bit = 012;
		break;
case 'B':
		bit = 014;
		break;
case 'R':
		bit = 011;
		break;
case 'm':
		bit = 05;
		break;
case 'c':	/* dim cyan */
		bit = 06;
		break;
case 'y':	/* dim yellow */
		bit = 03;
		break;
case 'M':
		bit = 015;
		break;

case 'C':
		bit = 016;
		break;
case 'Y':
		bit = 013;
		break;
case 'w':	/* dim white */
		bit = 07;
		break;
case 'W':	/* Bright White */
		bit = 017;
		break;


case 'p':	/* print the d_vid array in recognizable form */
		/* put out two extra newlines to get 66 lines
	 	 * total, which is just one page */
		putchar('\n');
	   	for(yh=0;yh<64;yh++)  {
			for(xl=0;xl<64;xl++)  {
				value = d_vid[xl][yh];
				putchar(table[value]);
			}
			putchar('\n');
		}
		putchar('\n');
		return;

case 't':	/* transmit the dazzler array in proper format */
		putchar('\020');

		for (yh=0;yh<32;yh++)
			for (xl=0;xl<32;xl++)
				putchar(d_vid[xl][yh]+'@');
		for (yh=0;yh<32;yh++)
			for (xl=32;xl<64;xl++)
				putchar(d_vid[xl][yh]+'@');
		for (yh=32;yh<64;yh++)
			for (xl=0;xl<32;xl++)
				putchar(d_vid[xl][yh]+'@');
		for (yh=32;yh<64;yh++)
			for (xl=32;xl<64;xl++)
				putchar(d_vid[xl][yh]+'@');

		putchar('\020');
		return;

case '0':	/* clear entire d_vid array */
case 'z':

		for(xl=0;xl<64;xl++)
			for(yh=0;yh<64;yh++)
				d_vid[xl][yh] = 0;
		return;

default:	/* catchall here. use value in bit form, mod 017 */
		bit = hue & 017;

	}

	setopt(0,1,2,3);	/* set correspondence between explor
				 * value and way hue is combined in
				 * d_vid array
				 */
	color(bit,bit,bit,bit);	/* set correspondence between explor
				 * value and hue to be used
				 */
	frambuf(ix,iy,iw,ih);
}



frambuf(ix,iy,iw,ih)
{
	dcombn(ix,iy,iw,ih,31,31);
}


dcombn(ix,iy,iw,ih,xto,yto)
{

	register char *vidp;
	char *vidptop;
	register int xl,yh;
	struct {
		char dummy[64];
	} *vp1,*vptop;
	int il,ir,ib,it,ok;
	int numxy, bits;

	int xdl,ydl;	/* dazzler left or bottom edge */
	int xrl,yrl;

	rctfy(ix,iy,iw,ih,&il,&ir,&ib,&it,&ok);
	if (!ok) {
		printf("dazzle(%d,%d,%d,%d) - bad call\n",ix,iy,iw,ih);
		return;
	}
/*	this is the check for not overflowing dazzler space */
		rctfy(xto,yto,iw,ih,&xdl,&xrl,&ydl,&yrl,&ok);
		if (!ok)
			return;
		if (xrl > 63) xrl = 63;
		if (yrl > 63) yrl = 63;

	/* the loop to modify the d_vid array.
	 * this uses a  rule, which must be
	 * set by a call to 'color'
	 *
	 *  rule		action
	 *   0		none
	 *   1		& ~bits (turn those bits off)
	 *   2		|bits (turn those bits on)
	 *   3		=bits (replace with those bits only)
	 *   4		&bits (retain those bits only if on)
	 *   5		arithmetic add values
	 *   6		arithmetic subtract values
	 */

	vp1 = d_vid[xdl];
	vptop = d_vid[64];
	vidptop = vptop;
	vidptop =+ 64;

	for(xl=il;xl<=ir;xl++) {
		vidp = vp1++;
		if (vidp >= vptop)
			break;
		vidp =+ ydl;

		for(yh=ib;yh<=it;yh++) {

			if  (((numxy=num(xl,yh))>3) || numxy<0)
				printf("bad num %o at %d,%d\n",numxy,xl,yh);
			bits = d_color[numxy] & 017;

			switch(d_opt[numxy]) {
case 6:
				*vidp =- bits;
				*vidp++ =& 017;
				break;
case 5:
				*vidp =+ bits;
				*vidp++ =& 017;
				break;
case 4:
				*vidp++ =& bits;
				break;
case 3:
				*vidp++ = bits;
				break;
case 2:
				*vidp++ =| bits;
				break;
case 1:
				*vidp++ =& (~bits)&017;
				break;
case 0:
default:
				vidp++;
			}
			if (vidp>=vidptop)
				break;
		}
	}
}

dshow(mode)
char mode;
{
	dazzle(0,0,0,0,mode);
}

video()
{
	dshow('t');
}
