/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney.
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID	@(#)sun4state.h	1.3 88/09/27
*/

/*
**	Link flags.
*/

enum
{
	fl4_dead, fl4_down,
	fl4_filtered, fl4_call,
	fl4_foreign,
	fl4_home, fl4_linkname,
	fl4_forward, fl4_duproute,
	fl4_othertype,
	fl4_pseudo,
	fl4_newcost, fl4_newflags,
	fl4_newlink, fl4_newregion,
	fl4_newdelay,
	fl4_n				/* 16 */
};

#define	MAXFLAGS	((int)fl4_n)
typedef unsigned short	Flags4;		/* Enough bits for MAXFLAGS */

#ifdef	TOKEN_DATA
#ifdef	DEBUG
char *	Flag4Names[] =
{
	"dead", "down",
	"filtered", "call",
	"foreign",
	"home", "linkname",
	"forward", "duproute",
	"othertype",
	"pseudo",
	"newcost", "newflags",
	"newlink", "newregion",
	"newdelay"
};
#endif	/* DEBUG */
#endif	/* TOKEN_DATA */

#define	FL4_CALL	(Flags4)(1L<<(int)fl4_call)
#define	FL4_DEAD	(Flags4)(1L<<(int)fl4_dead)
#define	FL4_DOWN	(Flags4)(1L<<(int)fl4_down)
#define	FL4_DUPROUTE	(Flags4)(1L<<(int)fl4_duproute)
#define	FL4_FILTERED	(Flags4)(1L<<(int)fl4_filtered)
#define	FL4_FOREIGN	(Flags4)(1L<<(int)fl4_foreign)
#define	FL4_FORWARD	(Flags4)(1L<<(int)fl4_forward)
#define	FL4_HOME	(Flags4)(1L<<(int)fl4_home)
#define	FL4_LINKNAME	(Flags4)(1L<<(int)fl4_linkname)
#define	FL4_NEWCOST	(Flags4)(1L<<(int)fl4_newcost)
#define	FL4_NEWDELAY	(Flags4)(1L<<(int)fl4_newdelay)
#define	FL4_NEWFLAGS	(Flags4)(1L<<(int)fl4_newflags)
#define	FL4_NEWLINK	(Flags4)(1L<<(int)fl4_newlink)
#define	FL4_NEWREGION	(Flags4)(1L<<(int)fl4_newregion)
#define	FL4_NEWTRAFFIC	(Flags4)(1L<<(int)fl4_newtraffic)
#define	FL4_NEWSPEED	(Flags4)(1L<<(int)fl4_newspeed)
#define	FL4_OTHERTYPE	(Flags4)(1L<<(int)fl4_othertype)
#define	FL4_PSEUDO	(Flags4)(1L<<(int)fl4_pseudo)

#define	FL4_INTERNAL	(FL4_DUPROUTE|FL4_FORWARD|FL4_HOME|FL4_LINKNAME|FL4_NEWCOST|FL4_NEWDELAY|FL4_NEWFLAGS|FL4_NEWLINK|FL4_NEWREGION|FL4_NEWTRAFFIC|FL4_NEWSPEED|FL4_OTHERTYPE)
#define	FL4_NOEXPORT	(FL4_INTERNAL|FL4_PSEUDO)
#define	FL4_NOIMPORT	(FL4_NOEXPORT)
#define	FL4_RESTRICT	(FL4_INTERNAL|FL4_FILTERED|FL4_PSEUDO)
#define	FL4_ROUTING	(FL4_DEAD|FL4_DOWN)

/*
**	The SUN IV state file is a sequence of bytes terminated by:-
**		C4_EOF
**		LOCRC
**		HICRC
**
**	The CRC checks all the preceding bytes.
*/

#define	OZCC		"au"	/* Country code for "oz" regions */
#define	TYPE_SEP	'='	/* Char. separating types from domain names in SUN IV addresses */
#define	TOKEN_C		0200	/* All statefile token bytes have top bit on */

/*
**	Separators used between tokens in state file.
**
**	(Order used in Accept4[] below.)
*/

#define	TOKEN_4_SIZE	1022

typedef enum
{
	t4_eof, t4_ordertypes,				/* [000], [001] */
	t4_address, t4_oldaddress, t4_comment,		/* [002], [003], [004] */
	t4_region, t4_visible, t4_rflags, t4_date, t4_route, t4_forward, /* [005] - [012] */
	t4_spooler, t4_caller, t4_filter, t4_linkname,	/* [013], [014], [015], [016] */
	t4_link, t4_lflags, t4_cost, t4_delay, t4_speed, t4_traffic, t4_restrict,
	t4_mapadr, t4_mapreg, t4_maptyp, t4_mapval, t4_xalias, t4_ialias,
	t4_fastroute, t4_cheaproute,
	t4_expect,
	t4_n,					/* [31] */
	t4_nextregion, t4_nextlink,
	t4_max,
	t4_error, t4_null
}
			Token4;

#define	t4_start	t4_eof

typedef long		Token4s;		/* Enough bits for 1<<t4_n */

#ifdef	TOKEN_DATA
#ifdef	DEBUG
char *	Token4Names[] =
{
	"eof", "ordertypes",
	"address", "oldaddress", "comment",
	"region", "visible", "rflags", "date", "route", "forward",
	"spooler", "caller", "filter", "linkname",
	"link", "lflags", "cost", "delay", "speed", "traffic", "restrict",
	"mapadr", "mapreg", "maptyp", "mapval", "xalias", "ialias",
	"fastadvroute", "cheapadvroute",
	"expect",
	"n",
	"nextregion", "nextlink",
	"max",
	"error", "null"
};
#endif	/* DEBUG */

#define	T_ADDRESS	(Token4s)(1L<<(int)t4_address)
#define	T_CALLER	(Token4s)(1L<<(int)t4_caller)
#define	T_CHEAPROUTE	(Token4s)(1L<<(int)t4_cheaproute)
#define	T_COMMENT	(Token4s)(1L<<(int)t4_comment)
#define	T_COST		(Token4s)(1L<<(int)t4_cost)
#define	T_DATE		(Token4s)(1L<<(int)t4_date)
#define	T_DELAY		(Token4s)(1L<<(int)t4_delay)
#define	T_EOF		(Token4s)(1L<<(int)t4_eof)
#define	T_EXPECT	(Token4s)(1L<<(int)t4_expect)
#define	T_FASTROUTE	(Token4s)(1L<<(int)t4_fastroute)
#define	T_FILTER	(Token4s)(1L<<(int)t4_filter)
#define	T_FORWARD	(Token4s)(1L<<(int)t4_forward)
#define	T_IALIAS	(Token4s)(1L<<(int)t4_ialias)
#define	T_LFLAGS	(Token4s)(1L<<(int)t4_lflags)
#define	T_LINK		(Token4s)(1L<<(int)t4_link)
#define	T_LINKNAME	(Token4s)(1L<<(int)t4_linkname)
#define	T_MAPADR	(Token4s)(1L<<(int)t4_mapadr)
#define	T_MAPREG	(Token4s)(1L<<(int)t4_mapreg)
#define	T_MAPTYP	(Token4s)(1L<<(int)t4_maptyp)
#define	T_MAPV		(Token4s)(1L<<(int)t4_mapval)
#define	T_OLDADDRESS	(Token4s)(1L<<(int)t4_oldaddress)
#define	T_ORDERTYPES	(Token4s)(1L<<(int)t4_ordertypes)
#define	T_REGION	(Token4s)(1L<<(int)t4_region)
#define	T_RESTRICT	(Token4s)(1L<<(int)t4_restrict)
#define	T_RFLAGS	(Token4s)(1L<<(int)t4_rflags)
#define	T_ROUTE		(Token4s)(1L<<(int)t4_route)
#define	T_SPEED		(Token4s)(1L<<(int)t4_speed)
#define	T_SPOOLER	(Token4s)(1L<<(int)t4_spooler)
#define	T_TRAFFIC	(Token4s)(1L<<(int)t4_traffic)
#define	T_VISIBLE	(Token4s)(1L<<(int)t4_visible)
#define	T_XALIAS	(Token4s)(1L<<(int)t4_xalias)

#define	F_ADDRESS	(T_COMMENT|T_REGION)
#define	F_OLDADDRESS	(T_COMMENT|T_REGION)
#define	F_COMMENT	(T_REGION)
#define	F_MAP		(T_XALIAS)
#define	F_LINK		(F_MAP|T_COST|T_DELAY|T_LFLAGS|T_LINK|T_REGION|T_RESTRICT|T_SPEED)
#define	F_REGION	(F_MAP|T_LINK|T_REGION|T_VISIBLE)
#define	F_NEXTREGION	(F_MAP|T_REGION)
#define	F_NEXTLINK	(F_NEXTREGION|T_LINK)

/*
**	Token expectations (in same order as Token4.)
*/

Token4s			Accept4[] = 
{
	T_ADDRESS,	/* t4_eof */
	T_ADDRESS,	/* t4_ordertypes */
	F_ADDRESS,	/* t4_address */
	F_OLDADDRESS,	/* t4_oldaddress */
	F_COMMENT,	/* t4_comment */
	F_REGION,	/* t4_region */
	F_REGION,	/* t4_visible */
	F_REGION,	/* t4_rflags */
	F_REGION,	/* t4_date */
	F_REGION,	/* t4_route */
	F_REGION,	/* t4_forward */
	F_REGION,	/* t4_spooler */
	F_REGION,	/* t4_caller */
	F_REGION,	/* t4_filter */
	F_REGION,	/* t4_linkname */
	F_LINK,		/* t4_link */
	F_LINK,		/* t4_lflags */
	F_LINK,		/* t4_cost */
	F_LINK,		/* t4_delay */
	F_LINK,		/* t4_speed */
	F_LINK,		/* t4_traffic */
	F_LINK,		/* t4_restrict */
	T_MAPV|T_EXPECT,/* t4_mapadr */
	T_MAPV|T_EXPECT,/* t4_mapreg */
	T_MAPV|T_EXPECT,/* t4_maptyp */
	F_MAP,		/* t4_mapval */
	F_MAP,		/* t4_xalias */
	T_MAPV|T_EXPECT,/* t4_ialias */
	T_MAPV|T_EXPECT,/* t4_fastroute */
	T_MAPV|T_EXPECT,/* t4_cheaproute */
	0,		/* t4_expect */
	0,		/* t4_n */
	F_NEXTREGION,	/* t4_nextregion */
	F_NEXTLINK	/* t4_nextlink */
};
#endif	/* TOKEN_DATA */
