/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)ReadState.c	1.3 88/09/05
*/

/*
**	Open state file, read it, and return file descriptor.
**	If 'update' is false, file is closed.
*/

#define	LOCKING
#define	STDIO

#include	"global.h"
#include	"debug.h"
#include	"sun4state.h"


static char *	StateFile;

extern void	Rstate();
extern void	R4state();


FILE *
ReadState(update, ignCRC)
	Lock_t		update;
	bool		ignCRC;
{
	register FILE *	fd;

	Trace3(1, "ReadState(r%s, %sCRC)", update?"+":"", ignCRC?"ign":"");

	if ( StateFile == NULLSTR )
		StateFile = STATEFILE;

	if ( (fd = fopen(StateFile, update?"r+":"r")) != NULL )
	{
		register int	c;

#		if	AUTO_LOCKING != 1
		if ( Lock(StateFile, fileno(fd), update) == SYSERROR )
		{
			Syserror("Can't lock \"%s\"", StateFile);
			return NULL;
		}
#		endif	AUTO_LOCKING

		(void)ungetc(c = getc(fd), fd);	/* Forward compatibility with SUN IV */
	
		if ( c & TOKEN_C )
			R4state(fd, false, NULLSTR, (Time_t)0, ignCRC);
		else
			Rstate(fd, false, NULLSTR, (Time_t)0, ignCRC);

		if ( update )
			rewind(fd);
		else
		{
#			if	AUTO_LOCKING != 1
			UnLock(fileno(fd));
#			endif	AUTO_LOCKING
			(void)fclose(fd);
		}

		return fd;
	}

	Syserror("Can't open \"%s\"", StateFile);

	return NULL;
}



void
SetState(newfile)
	char *	newfile;
{
	Trace2(1, "SetState(%s)", newfile);
	StateFile = newfile;
}
