/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)HashName.c	1.5 88/09/05
*/

/*
**	Calculate hash for a node name.
*/

#include	"global.h"
#include	"debug.h"
#include	"state.h"

#include	"node.h"



int
HashName(name)
	char *		name;
{
	register char *	cp = name;
	register int	hash;
	register int	c;
#	if	CRC_HASH == 1
	char		nn[NODE_NAME_SIZE];
	register char *	np = nn;
#	else	CRC_HASH == 1

	hash = 0;

#	endif	CRC_HASH == 0

	while ( c = *cp++ )
	{
#		if	CRC_HASH == 1

		*np++ = c|040;

#		else	CRC_HASH == 1

		HASH(hash, c|040);

#		endif	CRC_HASH == 1
	}

#	if	CRC_HASH == 1

	hash = acrc((Crc_t)0, nn, np-nn);

#	endif	CRC_HASH == 1

	Trace3(3, "\"%s\" hash = %#x", name, hash);

#	ifdef	HASH_MASK

	return hash & HASH_MASK;

#	else	HASH_MASK

	if ( hash < 0 )
		hash = ~hash;

	return hash % HASH_SIZE;

#	endif	HASH_MASK
}
