static char sccsid[] = "@(#)hayesmodem.c	1.2 (Neology) 85/09/18";
/*
**	patterns and functions to call using hayes compatible modems
*/

#include	"global.h"
#include	"caller.h"

#define TRACE

/*
**	The following PASSWD stuff is imported from "passwd.q"
*/

#ifndef	CALLARGS
#define	CALLARGS	"callargs"
#endif
#ifndef	CALLTIMES
#define	CALLTIMES	"calltimes"
#endif	CALLTIMES

#define	MAXPHONES	8

extern	int	Traceflag;

char
	*callargs = CALLARGS,	
	*daemon1 = NNDAEMON,		/* standard daemon */
	*daemon2 = NN2DAEMON,		/* alternate protocol */
	*hostflg = "-BF",		/* dialup, don't fork, cooked */
	*host	 	= NULLSTR,	/* connecting from where? */
	*target  	= NULLSTR,	/* connecting to where? */
	*passwd  	= NULLSTR,
	*ph_num[MAXPHONES + 1],		/* array of phone number pointers */
	**phoneno	= ph_num,	/* Current phone number to call */
	*device  	= NULLSTR,	/* Which call unit? (cul0) */
	*speed   	= "1200",
	*opentime	= "60",
	*logintime	= "25";		/* MUST be greater then 15 seconds
						(modem carrier detect time) */


int
	rclcount = 0,	/* count of resets calls */
	rcount	 = 0,	/* count of resets */
	tcount	 = 0,	/* count of timeouts */
	lcount	 = 0;	/* count of Unix login attempts */
	dcount	 = 0;	/* count of dial attempts */

int
	callbusy(),
	callefail(),
	calltfail(),
	eof(),
	gotlogin(),
	gotpasswd(),
	ignoreline(),
	nocarrier(),
	resetnotok(),
	resetunit(),
	start2(),
	started(),
	timeout();
	tocallunit(),
	tounix();

struct patlist atreset[] =
{
	{ "OK",    tocallunit },
	{ TIMEOUT, resetnotok },
	{ 0, 0 }
};

struct patlist atcallunit[] =
{
	{ "CONNECT 1200", tounix },
	{ "BUSY", callbusy },
	{ "NO CARRIER", nocarrier },
	{ "ERROR", callefail },
	{ TIMEOUT, calltfail },
	{ 0, 0 }
};

struct patlist atunix[] =
{
	{ "[Ii]llegal", ignoreline },
	{ "[Ii]ncorrect", ignoreline },
	{ "[Ll]ogin", gotlogin },
	{ "[Pp]assword", gotpasswd },
	{ STARTMSG, started},
	{ START2MSG, start2 },	/* alternate protocol */
	{ TIMEOUT, timeout },
	{ EOFSTR, eof },
	{ 0, 0 }
};

args(argc, argv)
	register int	argc;
	register char *	argv[];
{
	while ( --argc > 0 )
	{
		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'd':
					device = ++*argv;
					goto break2;
				case 'l':
					host = ++*argv;
					goto break2;
				case 'p':
					if (phoneno != &ph_num[MAXPHONES])
					{
					    *phoneno++ = ++*argv;
					    goto break2;
					}
					outend("fail too many phone numbers");
					exit(1);
				case 'P':
					passwd = ++*argv;
					goto break2;
				case '1':
					daemon1 = ++*argv;
					goto break2;
				case '2':
					daemon2 = ++*argv;
					goto break2;
				case 'T':
#ifdef TRACE
					Traceflag = atoi(++*argv);
#endif
					goto break2;
				default:
					out("fail unexpected flag \"-");
					out(*argv);
					out("\" in ");
					outend(CALLARGS);
					exit(1);
				}
			}
break2:			;
		}
		else if (target != NULLSTR)
		{
			out("fail target already given: \"");
			out(*argv);
			outend("\" unexpected.");
			exit(1);
		}
		else
			target = *argv;
	}
}

void
init(argc, argv)
	int	argc;
	char	*argv[];
{

	args(argc, argv);
	if (target == NULLSTR)
	{
	    outend("fail no target");
	    exit(1);
	}

	callargs = concat(SPOOLDIR(/), target, "/", callargs, NULLSTR);
	(void)readargs(callargs, args);
	phoneno = ph_num;
	if (*phoneno == NULLSTR)
	{
	    outend("fail no phone numbers");
	    exit(1);
	}
#ifdef	TRACE
	if (Traceflag > 5 )
		outend("trace opening line......");
#endif	TRACE
	out("timeout "); outend(opentime);
	out("opendial "); outend(device);
	outend("local");
	out("speed "); outend(speed);
	out("timeout "); outend(logintime);
#ifdef	TRACE
	if (Traceflag > 1 )
		outend("trace starting reader ......");
#endif	TRACE
	outend("read");
	resetunit();
	rclcount = 0;
}

resetunit()
{
#ifdef	TRACE
	if (Traceflag > 5 )
		outend("trace resetting modem ......");
#endif	TRACE
	if (++rclcount > 20)
		outend("fail call fail - modem reset called 20 times.");
	rcount = 0;
	dcount = 0;
	state(atreset);
	outend("sleep 2");
	outend("write +++");
	outend("sleep 2");
	outend("write ATZ\r");
	reset();
}

resetnotok()
{
#ifdef	TRACE
	if (Traceflag > 5 )
		outend("trace issuing another reset comand ......");
#endif	TRACE
	if (++rcount > 10)
		outend("fail call fail - 10 modem resets failed.");
	state(atreset);
	outend("sleep 2");
	outend("write +++");
	outend("sleep 2");
	flushinput();
	outend("write ATZ\r");
	reset();
}

tocallunit()
{
#ifdef	TRACE
	if (Traceflag > 1 )
		outend("trace dialing......");
#endif	TRACE
	state(atcallunit);
	out("write ATD"); out(*phoneno++); outend("\r");
	if (*phoneno == NULLSTR)
	    phoneno = ph_num;
	reset();
}

callbusy()
{
	if (++dcount > 9)
		outend("fail was busy 10 times");
	else
	{
#ifdef	TRACE
		if (Traceflag)
			outend("trace reset modem - call busy");
#endif	TRACE
		resetunit();
	}
}

calltfail()
{
#ifdef	TRACE
	if (Traceflag > 5 )
		outend("trace waiting......");
#endif	TRACE
	if (++dcount > 9)
		outend("fail timeout 9 times");
	else
	{
		reset();
	}
}

callefail()
{
	reset();
	if (++dcount > 9)
		outend("fail error");
	else
	{
#ifdef	TRACE
		if (Traceflag)
			outend("trace reset modem - error");
#endif	TRACE
		reset();
		flushinput();
		resetunit();
	}
}

ignoreline()
{
	reset();
	reset();
}

nocarrier()
{
	if (++dcount > 9)
		outend("fail no carrier");
	else
	{
#ifdef	TRACE
		if (Traceflag)
			outend("trace reset modem - no carrier");
#endif	TRACE
		resetunit();
	}
}

tounix()
{
	tcount = 0;
	lcount = 0;
	dcount = 0;
#ifdef	TRACE
	if (Traceflag > 5 )
		outend("trace clearing line of modem startup garbage ......");
#endif	TRACE
	outend("write \n\n");
	sleep(10);
	flushinput();
	outend("write \n");
#ifdef	TRACE
	if (Traceflag > 1 )
		outend("trace waiting for login......");
#endif	TRACE
	outend("remote");
	state(atunix);
}

gotlogin()
{
#ifdef	TRACE
	if (Traceflag > 5 )
		outend("trace got login ......");
#endif	TRACE
	if ( ++lcount >= 9 )
	{
		out("fail too many login attempts at "); outend(target);
	}
	out("write "); out(host); outend("\r");
	reset();
}


gotpasswd()
{
#ifdef	TRACE
	if (Traceflag > 5 )
		outend("trace got passwd ......");
#endif	TRACE
	out("write "); out(passwd); outend("\r");
	reset();
}


started()
{
#ifdef	TRACE
	if (Traceflag)
		outend("trace call succeeded, daemon starting");	/**/
#endif	TRACE
	out("succeed "); outend(target);
	exit(0);
}


start2()
{
#ifdef	TRACE
	if (Traceflag)
		outend("trace call succeeded, daemon 2 starting");	/**/
#endif	TRACE
	out("daemon "); outend(daemon2);
	out("succeed "); out(hostflg); out(" "); outend(target);
	exit(0);
}


timeout()
{
	if (++tcount >= 9)
	{
		outend("sleep 2");
		outend("write +++");
		outend("sleep 2");
		outend("write ATZ\r");
		outend("fail 9 timeouts in login");
		exit(1);
	}
	outend("write \r");
	reset();
}

eof()
{
	outend("fail unexpected eof");
	exit(1);
}
