/*
**	Copyright (c) 1989 Piers Lauder, University of Sydney.
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID	@(#)StripEnv.c	1.3 89/08/25
*/

#include	"global.h"
#include	"debug.h"


static char	PATH[]	= "PATH=/bin:/usr/bin";
static char *	Envs[]	=
{
	"SYSTYPE=",
	"TZ=",
	NULLSTR
};
static char *	Env[(sizeof Envs)/(sizeof Envs[0])+1];

extern char *	getenv();



/*
**	Sanitize environment.
**
**	(Only PATH, SYSTYPE, TZ, for now.)
*/

char **
StripEnv()
{
	register char *	cp;
	register char *	ep;
	register char **cpp;
	register char **epp;

	for ( epp = Env, cpp = Envs ; (cp = *cpp++) != NULLSTR ; )
		if ( (ep = getenv(cp)) != NULLSTR )
			*epp++ = ep - strlen(cp);

	*epp++ = PATH;
	*epp = NULLSTR;

	return Env;
}
