/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)CopyFile.c	1.2 87/10/01
*/

#define	FILE_CONTROL
#define	STDIO

#include	"global.h"
#include	"debug.h"

#include	<errno.h>


static char	CouldNot[] = "Couldn't %s \"%s\"";



/*
**	Copy contents of "file" to "ofd".
*/

void
CopyFile(file, ofd, ofile)
	char *		file;
	int		ofd;
	char *		ofile;
{
	register int	ifd;

	while ( (ifd = open(file, O_READ)) == SYSERROR )
		Syserror(CouldNot, "open", file);

	(void)CopyFd(ifd, file, ofd, ofile);

	(void)close(ifd);
}



/*
**	Copy data from ifd to ofd.
*/

long
CopyFd(ifd, ifile, ofd, ofile)
	int		ifd;
	char *		ifile;
	int		ofd;
	char *		ofile;
{
	register int	r;
	register int	w;
	register char *	cp;
	register long	posn;
	bool		pipe = false;
	char		buf[BUFSIZ];

	Trace5(1, "CopyFd(%d, %s, %d, %s)", ifd, ifile, ofd, ofile);

	while ( (posn = lseek(ofd, (long)0, 1)) == SYSERROR )
		if ( errno != ESPIPE )
			Syserror(CouldNot, "seek", ofile);
		else
		{
			pipe = true;
			posn = 0;
			break;
		}

	for ( ;; )
	{
		cp = buf;
		r = BUFSIZ;

		while ( (r = read(ifd, cp, r)) == SYSERROR )
			Syserror(CouldNot, "read", ifile);

		if ( r == 0 )
			return posn;

		while ( (w = write(ofd, cp, r)) != r )
		{
			if ( w == SYSERROR )
			{
				Syserror(CouldNot, "write", ofile);
				if ( !pipe )
					(void)lseek(ofd, posn, 0);
			}
			else
			{
				cp += w;
				r -= w;
				posn += w;
			}
		}
	}
}
