/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)debug.h	1.3 84/09/10
*/

/*
**	Definitions of debugging routines.
**
**	Report:	report on abnormal condition if DEBUG.
**	Fatal:	abort program, print arguments if DEBUG.
**	Trace:	produce output on TraceFd if DEBUG == 2.
*/

extern void	Fatal();

extern int	Traceflag;
#ifdef	BUFSIZ
extern FILE *	TraceFd;
#endif

#if	DEBUG >= 1

#define	DODEBUG(A)	A

extern void	Report();

#define	Report1(A)		Report(A)
#define	Report2(A,B)		Report(A,B)
#define	Report3(A,B,C)		Report(A,B,C)
#define	Report4(A,B,C,D)	Report(A,B,C,D)
#define	Report5(A,B,C,D,E)	Report(A,B,C,D,E)
#define	Report6(A,B,C,D,E,F)	Report(A,B,C,D,E,F)
#define	Report7(A,B,C,D,E,F,G)	Report(A,B,C,D,E,F,G)
/**	If more are added, then must change "Lib/Report.c"	**/

#define	Fatal1(A)		Fatal(A)
#define	Fatal2(A,B)		Fatal(A,B)
#define	Fatal3(A,B,C)		Fatal(A,B,C)
#define	Fatal4(A,B,C,D)		Fatal(A,B,C,D)
#define	Fatal5(A,B,C,D,E)	Fatal(A,B,C,D,E)
#define	Fatal6(A,B,C,D,E,F)	Fatal(A,B,C,D,E,F)
#define	Fatal7(A,B,C,D,E,F,G)	Fatal(A,B,C,D,E,F,G)
/**	If more are added, then must change "Lib/Fatal.c"	**/

#if	DEBUG == 2

extern void	Trace();

#define	Trace1(L,A)		{if(Traceflag>=L)Trace(L,A);}
#define	Trace2(L,A,B)		{if(Traceflag>=L)Trace(L,A,B);}
#define	Trace3(L,A,B,C)		{if(Traceflag>=L)Trace(L,A,B,C);}
#define	Trace4(L,A,B,C,D)	{if(Traceflag>=L)Trace(L,A,B,C,D);}
#define	Trace5(L,A,B,C,D,E)	{if(Traceflag>=L)Trace(L,A,B,C,D,E);}
#define	Trace6(L,A,B,C,D,E,F)	{if(Traceflag>=L)Trace(L,A,B,C,D,E,F);}
#define	Trace7(L,A,B,C,D,E,F,G)	{if(Traceflag>=L)Trace(L,A,B,C,D,E,F,G);}
/**	If more are added, then must change "Lib/Trace.c"	**/

#else	DEBUG == 2

#define	Trace1(L,A)
#define	Trace2(L,A,B)
#define	Trace3(L,A,B,C)
#define	Trace4(L,A,B,C,D)
#define	Trace5(L,A,B,C,D,E)
#define	Trace6(L,A,B,C,D,E,F)
#define	Trace7(L,A,B,C,D,E,F,G)

#endif	DEBUG == 2

#else	DEBUG >= 1

#define	DODEBUG(A)

#define	Report1(A)
#define	Report2(A,B)
#define	Report3(A,B,C)
#define	Report4(A,B,C,D)
#define	Report5(A,B,C,D,E)
#define	Report6(A,B,C,D,E,F)
#define	Report7(A,B,C,D,E,F,G)

#define	Fatal1(A)		Fatal("")
#define	Fatal2(A,B)		Fatal("")
#define	Fatal3(A,B,C)		Fatal("")
#define	Fatal4(A,B,C,D)		Fatal("")
#define	Fatal5(A,B,C,D,E)	Fatal("")
#define	Fatal6(A,B,C,D,E,F)	Fatal("")
#define	Fatal7(A,B,C,D,E,F,G)	Fatal("")

#define	Trace1(L,A)
#define	Trace2(L,A,B)
#define	Trace3(L,A,B,C)
#define	Trace4(L,A,B,C,D)
#define	Trace5(L,A,B,C,D,E)
#define	Trace6(L,A,B,C,D,E,F)
#define	Trace7(L,A,B,C,D,E,F,G)

#endif	DEBUG >= 1
