/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)WriteHeader.c	1.3 89/01/09
*/

/*
**	Write out header at end of file.
**
**	Assumes that "HdrFields" has been set up properly.
**
**	Result, if not SYSERROR, is the number of bytes in the header.
*/

#define	STDIO
#define	FILE_CONTROL
#define	STAT_CALL
#include	"global.h"

#include	"debug.h"
#include	"header.h"



int
WriteHeader(fd, start, minlength)
	int			fd;
	long			start;
	int			minlength;
{
	register char **	fp;
	register char *		cp;
	register int		bytes;
	register char *		hdbuf;
	Crc_t			crc;

	if ( lseek(fd, start, 0) == (long) SYSERROR )
		return SYSERROR;

	HdrFields.hf_start[(int)ht_type] = HDR_TYP1;

	for
	(
		fp = HdrFields.hf_start, bytes = 0 ;
		fp < &HdrFields.hf_start[NHDRFIELDS] ;
		fp++
	)
	{
		if ( *fp != NULLSTR )
			bytes += strlen(*fp)+1;	/* Add 1 for null */
		else
			++bytes;
	}

	if ( minlength > HDR_LENGTH_SIZE )
	{
		minlength -= HDR_LENGTH_SIZE;

		if (bytes < minlength)
			bytes = minlength;
	}

	DODEBUG(if(CRC_SIZE!=2)Fatal("CRC_SIZE"));

	hdbuf = Malloc(bytes+CRC_SIZE+HDR_LENGTH_SIZE+1);

	for
	(
		fp = HdrFields.hf_start, cp = hdbuf;
		fp < &HdrFields.hf_start[NHDRFIELDS] ;
		fp++
	)
	{
		if ( *fp != NULLSTR )
		{
			strcpy(cp, *fp);
			cp += strlen(cp)+1;	/* Add 1 for null */
		}
		else
			*cp++ = '\0';

	}

	while ( cp < &hdbuf[bytes] )
		*cp++ = '\0';

	crc = acrc((Crc_t)0, hdbuf, bytes);
	*cp++ = LOCRC(crc);
	*cp++ = HICRC(crc);
	bytes += CRC_SIZE;

	(void)strclr(cp, HDR_LENGTH_SIZE);
	(void)sprintf(cp, "%d", bytes);
	bytes += HDR_LENGTH_SIZE;

	errno = 0;
	if ( write(fd, hdbuf, bytes) != bytes )
	{
		free(hdbuf);
		return SYSERROR;
	}

	free(hdbuf);

	return HdrLength = bytes;
}
