/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
*/

static char	sccsid[]	= "@(#)linkstats.c	1.19 85/11/08";

/*
**	Print out statistics for each link based on contents of state files.
*/

#if EBUG
#define	STDIO  
#endif
#define	FILE_CONTROL
#define	STAT_CALL

#include	"global.h"

#include	"command.h"
#include	"debug.h"
#include	"spool.h"
#include	"state.h"
#undef	Extern
#define	Extern
#include	"Stream.h"

#include	<ndir.h>
#include	<errno.h>

#include	<signal.h>

#if AUSAS
#define AUSAM
#endif


/*
**	Filenames that must be set up
*/

char *	Slash		= "/";		/* Path name element separator */
char *	Statefile	= STATUSFILE;	/* Filename for daemon status information */
char *	Spooldir	= SPOOLDIR();	/* Spool area directory name */

/*
**	Parameters set from arguments
*/

char *	Name;				/* Program invoked name */
int	Traceflag;			/* Trace level */

/*
**	List for found links.
*/

typedef struct LLel *	LLl_p;

typedef struct LLel
{
	LLl_p	lql_next;
	char *	lql_link;
	ino_t	lql_ino;
}
	LLel;

LLl_p	LinkList;			/* Head of linked list */
LLl_p *	LinkVec;			/* Vector of sorted links */
int	NLinks;				/* No. of links found */

/*
**	Miscellaneous info.
*/

NodeLink LinkD;				/* Info. from FindNode() */

long	StreamSizes[NSTREAMS] =
{
	 SMALL_MESSAGE
	,MEDIUM_MESSAGE
	,LARGE_MESSAGE
};

#define	Fprintf		(void)fprintf
#define	dots(A)		(A[0]=='.'&&(A[1]==0||(A[1]=='.'&&A[2]==0)))

/*
**	Routines
*/

int	compare();
void	LinkStats(), LongStats(), ShortStats(), ListLink(), SortLinks();
void	ShortHeader();
bool	FindLinks();


#ifdef AUSAM
#include <udp.h>
typedef udport SOCKADDR;
#else
#include <sys/socket.h>
#include <netinet/in.h>
typedef struct sockaddr_in SOCKADDR;
#endif

main(argc,argv)
char *argv[];
{
	/* listen for linkstats requests on stdin and form and transmit replies.
	 * There are two sorts of request, linklist and linkstats.
	 * A linklist request is of the form
	 * 	"linklist" or "linklist linkname"
	 * The former requests all links, the latter, those for a particular link.
	 * The reply is of the form
	 *	"linklist: linkname linkname ..."
	 * A linkstats request is of the form
	 *	"linkstats linkname"
	 * The reply is of the form
	 *	"linkstats: linkname\0<statusfile>"
	 * where the statusfile has been converted entirely to network byte order.
	 */
#ifdef	STDIO
Traceflag = 10;
close(2);
#ifdef AUSAM
fopen("/tmp/display","w");
#else
fopen("/dev/display","w");
#endif
#endif
	
	for(;;)
	{
		char mesg[1400];
		int mesglen;
		SOCKADDR	peer;
#ifndef	AUSAM
		int peerlen;
#endif

		signal(SIGALRM, SIG_DFL);
		alarm(3*60);

#ifdef	AUSAM
		peer.udp_fill = 1;
		if (ioctl(0, NIOC_RECV, &peer)== -1) continue;
		mesglen = read(0,mesg, sizeof(mesg));
#else
		peerlen = sizeof(peer);
		mesglen = recvfrom(0, mesg, sizeof(mesg), 0, &peer, &peerlen);
#endif
		alarm(0);
#ifdef STDIO
fprintf(stderr,"message %d <%0.*s>\n",mesglen, mesglen, mesg);
#endif

		mesg[mesglen]='\0';
		if (mesglen >= 8 && strncmp(mesg, "linklist", 8)==0)
			linklist(mesg+8, mesglen-8, &peer);
		else if (mesglen > 10 && strncmp(mesg, "linkstats ", 10)==0)
			linkstats(mesg+9, mesglen-9, &peer);
	}
}

linklist(link, len, peer)
char *link;
int len;
SOCKADDR *peer;
{
	char *reply;

	clearllist();
	if (len == 0)
		FindLinks(Spooldir);
	else
	{
		register int	i;
		link[len]='\0';
		if (*link++ != ' ') return;
		for ( i = 0 ; ; i++ )
		{
			char *		linkp = concat(Spooldir, link, Slash, NULLSTR);
			struct stat	statb;

			if
			(
				stat(linkp, &statb) != SYSERROR
				&&
				(statb.st_mode&S_IFMT) == S_IFDIR
			)
			{
#				ifdef	MULTIPATH
				if ( !FindLinks(linkp) )
#				endif	MULTIPATH
					ListLink(Spooldir, link, statb.st_ino);
				break;
			}

			free(linkp);

			if ( i == 0 )
			{
				char *l;
				if ( (l = FindAlias(link)) != NULLSTR )
					link = l;

				if ( FindNode(link, pt_msg, &LinkD) )
				{
					link = LinkD.nl_name;
					continue;
				}
			}

			break;
		}
	}
#ifdef STDIO
fprintf(stderr,"NLinks = %d\n",NLinks);
#endif
	if (NLinks == 0)
		reply = concat("badlink: ", link, NULLSTR);
	else
	{
		int len, l;
		int splen = strlen(Spooldir);

		SortLinks();
		len = sizeof("linklist:") -1;
		for (l=0; l<NLinks; l++)
			len += strlen(LinkVec[l]->lql_link + splen) +1;
		reply = malloc(len+1);
		strcpy(reply, "linklist:");
		for (l=0; l<NLinks; l++)
			strcat(reply, " "),
			strcat(reply, LinkVec[l]->lql_link + splen);
	}
#ifdef	AUSAM
	ioctl(1, NIOC_SEND, peer);
	write(1, reply, strlen(reply));
#else
	sendto(1, reply, strlen(reply), 0, peer, sizeof(struct sockaddr_in));
#endif
	free(reply);
}

linkstats(mesg, msglen, peer)
char *mesg;
int msglen;
SOCKADDR *peer;
{
    register int	i;
    register int	j, st,d;
    char *		statefile, *m;
    char *		reply, *cp;

    for ( ; m=strrchr(mesg, ' ') ;  *m='\0')
    {
	statefile = concat(Spooldir, m+1, Slash, Statefile, NULLSTR);
	Trace2(1, "link stats from \"%s\"", statefile);

	for ( j = 0 ;; )
	if
	(
		(i = open(statefile, O_READ)) == SYSERROR
		||
		read(i, (char *)&NNstate, sizeof NNstate) != sizeof NNstate
	)
	{
		if ( i != SYSERROR )
			(void)close(i);

		if ( i == SYSERROR || ++j > 3 )
		{
			(void)strclr((char *)&NNstate, sizeof NNstate);
			break;
		}

		(void)sleep(1);
	}
	else
	{
		if ( strcmp(NNstate.version, StreamSCCSID) != STREQUAL )
				(void)strclr((char *)&NNstate, sizeof NNstate);

		(void)close(i);
		break;
	}

	free(statefile);

	/* now convert to network byte order */

	if (NNstate.procid)
	{
		if (kill(NNstate.procid, SIG0) == SYSERROR
			&&
			errno != EPERM
		) NNstate.procid = 0;
	}

	reply = malloc(13+strlen(m+1) + sizeof(NNstate));
	strcpy(reply, "linkstats: ");
	strcat(reply, m+1);
	{ int l;
	l = strlen(m+1) + 11;
	l = (l+4) & ~3;
	cp = reply+l;
	}

#define l(x)	*((long*)cp)= htonl(NNstate.x) ; cp += sizeof(long)
#define	s(x)	*((short*)cp) = htons(NNstate.x) ; cp += sizeof(short)
#define b(x)	*cp++ = NNstate.x
	b(linkstate); b(procstate);
	s(procid);
	l(speed); l(maxspeed);
	s(packetsize); s(nbufs); s(recvtimo); cp += 2;
	l(inbytes); l(outbytes), l(lasttime); l(allbytes); l(allmessages);
	l(starttime); l(thistime); l(activetime); l(inpkts); l(outpkts);
	for (st=0; st<NSTREAMS ; st++)
	for (d=0; d<2 ; d++)
	{
#define ll(x)	l(streams[d][st].str_/**/x)
#define ss(x)	s(streams[d][st].str_/**/x)
#define bb(x)	b(streams[d][st].str_/**/x)
		ll(size); ll(posn); ll(bytes); ll(messages); ll(time);
		ss(fd);
		bb(state); bb(flags);
	}
	for (d=0 ; d<8 ; d++) b(version[d]);


#ifdef	AUSAM
	ioctl(1, NIOC_SEND, peer);
	write(1, reply, cp - reply);
#else
	sendto(1, reply, cp - reply, 0, peer, sizeof(struct sockaddr_in));
#endif
	free(reply);
    }
}

/*
**	Cleanup for error routines
*/

void
finish(error)
	int	error;
{
	(void)exit(error);
}





/*
**	Queue a network link directory.
*/

void
ListLink(path, link, ino)
	char *		path;
	char *		link;
	ino_t		ino;
{
	register LLl_p	hllp;

	hllp = Talloc(LLel);

	hllp->lql_link = concat(path, link, NULLSTR);
	hllp->lql_ino = ino;

	hllp->lql_next = LinkList;
	LinkList = hllp;

	NLinks++;

	Trace2(1, "list link \"%s\"", hllp->lql_link);
}



/*
**	Search spooldir recursively for link directories
*/

bool
FindLinks(path)
	char *				path;
{
	register DIR *			dirp;
	register struct direct *	direp;
	bool				found = false;

	Trace2(1, "find links in \"%s\"", path);

	if ( (dirp = opendir(path)) == NULL )
	{
		Syserror("cannot read %s", path);
		return found;
	}

	while ( (direp = readdir(dirp)) != NULL )
	if ( direp->d_name[0] != WORKFLAG && !dots(direp->d_name) )
	{
		register LLl_p	hllp;
		struct stat	dstat;
		char *		newpath;

		Trace2(2, "entry \"%s\"", direp->d_name);

		for ( hllp = LinkList ; hllp != (LLl_p)0 ; hllp = hllp->lql_next )
			if ( hllp->lql_ino == direp->d_ino )
				break;

		newpath = concat(path, direp->d_name, Slash, NULLSTR);

		if
		(
			hllp == (LLl_p)0
			&&
			stat(newpath, &dstat) != SYSERROR
			&&
			(dstat.st_mode & S_IFMT) == S_IFDIR
		)
		{
			char *	newname;

			newname = newstr(direp->d_name);	/* direp re-used */

#			ifdef	MULTIPATH
			if ( !FindLinks(newpath) )
#			endif	MULTIPATH
			{
				ListLink(path, newname, direp->d_ino);
				found = true;
			}

			free(newname);
		}

		free(newpath);
	}

	closedir(dirp);

	return found;
}

clearllist()
{
	LinkList = NULL;
	while (NLinks)
		free(LinkVec[--NLinks]);
	if (LinkVec) free(LinkVec);
	LinkVec = NULL;
}


/*
**	Sort the links into alphabetic order
*/

void
SortLinks()
{
	register LLl_p	lp;
	register LLl_p *lpp;

	LinkVec = lpp = (LLl_p *)Malloc(sizeof(LLl_p) * NLinks);

	for ( lp = LinkList ; lp != (LLl_p)0 ; lp = lp->lql_next )
		*lpp++ = lp;

	DODEBUG(if((lpp-LinkVec)!=NLinks)Fatal1("bad NLinks"));

	Trace2(1, "found %d links", NLinks);

	if ( NLinks > 1 )
		qsort((char *)LinkVec, NLinks, sizeof(LLl_p), compare);
}



/*
**	Alpha compare
*/

int
compare(lpp1, lpp2)
	char *	lpp1;
	char *	lpp2;
{
	return strcmp((*(LLl_p *)lpp1)->lql_link, (*(LLl_p *)lpp2)->lql_link);
}
