#! /bin/sh
#
#	summarise acsnet log	- Bruce Ellis, July 1984.
#
#	flags:
#		-a	summarise each call
#		-d	give protocol stats
#		-c	cpu time as well
#		-e	list errors
#		-f	include failed calls in "errors"
#		-g	list garbage in log file
#		-r	list misc NNdaemon reports
#
AWKFILE=/usr/spool/ACSnet/_lib/logsum.awk
f=0
args=

for i
do
	case "$i" in
	-*)
		args="$args$i"
		;;
	*)
		if [ "$f" = "0" ]
		then
			f=1
		elif [ "$f" = "1" ]
		then
			f=2
		fi
		;;
	esac
done

if [ "$f" = "0" ]
then
	exec >&2
	echo 'Usage: logsum [-adcefgr] logfile ...'
	echo '	-a	summarise each call'
	echo '	-d	give protocol stats'
	echo '	-c	cpu time as well'
	echo '	-e	list errors'
	echo '	-f	include failed calls in "errors"'
	echo '	-g	list garbage in log file'
	echo '	-r	list misc NNdaemon reports'
	exit 1
else
	for i
	do
		case "$i" in
		-*)
			;;
		*)
			if [ "$f" = "2" ]
			then
				echo "$i:"
			fi

			echo "Options $args" | awk -f $AWKFILE - "$i"
			;;
		esac
	done
fi
