#! /bin/sh

#	Allows getfile from a server or client
#	Requires remote-procedure call facility ("on"/"rpc")

#	Written by: Ian M. Donaldson, 88/06/21
#	Updated by: Ian M. Donaldson, 88/06/21

SERVER=chudich

HOST=`/bin/hostname`
REAL_GETFILE=/usr/local/bin/getfile.real

case $HOST in
$SERVER)
	exec $REAL_GETFILE $*
	;;
*)
	STATUS=1
	trap "stty susp \^Z dsusp \^Y 2>/dev/null; exit \$STATUS" 0 1 2 3 15
	stty susp undef 2> /dev/null
	stty dsusp undef 2> /dev/null
	/usr/bin/on -i $SERVER $REAL_GETFILE $*
	STATUS=$?
	exit $STATUS
	;;
esac

# if we get this far something is wrong
exit 1
