#!/bin/sh
#
#	Search files in _bad directory, and prompt for action.
#
trap 'rm -f current; exit 0' 1 2 15

STATE=acsstate
ECHON='echo -n'
#ECHOC='\c'
SU=su
#SU=/etc/su
VIS='cat -v'
#VIS=vis

cd /usr/spool/ACSnet/_bad || exit 1

for i in `ls -tr [012]*`
do
	ln $i current
	echo `ls -l $i` [current]
	$VIS $i | MORE= ${PAGER-more}
	filedone=false
	until $filedone
	do
		echo 'Vis workfile (v), Move to link (m), Pass to receiver (p), Mail to user (M),'
		ECHON 'Statemsg (s), Remove (r), Next (n), Shell (!<command>) ? ' $ECHOC
		read reply
		case $reply
		in
		m|move)
			$ECHON "Directory ? ../" $ECHOC
			read dir
			mv $i ../$dir
			filedone=true
			;;
		n|next)
			filedone=true
			;;
		p|pass)
			$ECHON "arrived on link ? " $ECHOC
			read link
			$SU daemon -c "../_lib/receiver -L -l${link} -t100 $i"
			filedone=true
			;;
		M|mail)
			$ECHON "Who from ? " $ECHOC
			read from
			$ECHON "Who to ? " $ECHOC
			read to
			$VIS $i | rmail -f$from $to && rm $i && filedone=true
			;;
		r|remove|d|dp)
			rm $i
			filedone=true
			;;
		s|state)
			$ECHON "from host.hierarchy? " $ECHOC
			read host
			$SU daemon -c "$STATE -IRSXWf$host < $i"
			if [ ! -f ../_state/$host ]
			then
				mv $i ../_state/$host
			else
				rm -f $i
			fi
			filedone=true
			;;
		v|vis)
			$ECHON "../_work/*" $ECHOC
			read work
			$VIS ../_work/*$work | MORE= ${PAGER-more}
			filedone=false
			;;
		!*)
			reply=`expr "$reply" : '!\(.*\)' | sed -e 's/%/'"$i"'/g'`
			echo "$reply"
			trap '' 2 3
			sh -c "$reply"
			trap 'rm -f current; exit 0' 2 3
			;;
		'')
			exit 0
			;;
		*)
			echo "[$i] Valid commands are m,n,p,M,r,v and !."
			;;
		esac
	done
	rm -f current
done
