
.TH TEL 1 "GL"
.SH NAME
tel \- show and maintain information on persons
.SH SYNOPSIS
tel name			; search name, add to pdb if new
.br
tel name data [data]; add to private database (pdb)
.br
tel -a name [data]	; add to private database
.br
tel -d name		; query delete of record in pdb
.br
tel -h			; tel command synopsis
.br
tel -t name		; search but do not add to pdb
.br
tel -u			; update pdb 
.br
tel -v			; version number
.SH DESCRIPTION
Tel quickly shows the information on a person, if this information
is present in a private database $HOME/.tel. Otherwise the
searchname is passed to the 'postda' command, which will search
in the post database. A record found by the 'postda' command will
be added to the private database in order to speed up any subsequent search
to the same person. Furthermore, records not available in the post
database can be entered in the private database.

The search format is similar to that of the 'postda' command:
.sp
.ti +4
lastname[.firstname[.middlename][:location]
.sp
Only the first part of the names are needed for a search. The location
is typically 'apt' or 'attbl'.
.sp
.in +4
.ti -4
-a\ \ Add information to the private database. This is also done if more
than one argument is given.
.br
.ti -4
-d\ \ Delete record from the database. The records matching the searchname
are shown, and one can be selected to be removed.
.br
.ti -4
-h\ \ Help function lists the synopsis of the tel command.
.br
.ti -4
-t\ \ Search for the given name, but do not add to the private database
if a record is found in the post database.
.br
.ti -4
-u\ \ Update those records in the private database that where extracted
from the large post database. This option can be run as a cron task every
now and then to assure up to date information in the private database.
.br
.ti -4
-v\ \ Print the version number.
.SH FILES
$TEL or $HOME/.tel		private database
.SH SEE ALSO
postda, post -w
.SH PROVIDER
G Langhout
