
Here is the manpage from "scpp", the selective C pre-processor,
written by Brad Needham (textronix!tekig4!bradn), available from
your nearest mod.sources archive.
	/rich $alz

.TH SCPP 1 "28 September 1983"
.SH NAME
scpp \- selective C preprocessor
.SH SYNOPSIS
.B scpp
[
.BI \-M macro
] [
.BI \-D macro
] [
.BI \-D macro=def
] [
.B \-C
]
.ti +5
[
.BI \-I incdir
] [
.I file...
]
.SH DESCRIPTION
.B Scpp
concatenates the input
.I files
(or reads standard-in, if no
.I file
is given),
interprets all references to given macros,
leaving the rest of the
.IR file "(s)"
unaltered,
then writes the result to standard-out.
It is helpful in removing conditionally compiled code or misleading
macros from a file.
.PP
The
.I file
name "\fB-\fP" refers to standard-in.
.PP
The following options are available.
Each option can appear as frequently as desired.
.RS
.TP
.SM \-M
Interpret all references to the given
.I macro.
.I Macro
can be either a single macro name or a whitespace-separated list of
macro names (e.g. -MMAXINT or -M"MAXINT MININT INTWID").
All occurrences of the macro and all instances of the intrinsic macro
\&"defined()" referring to this macro are expanded.
All preprocessor directives referring to this macro (except
.BR #if )
perform their usual function and do not appear in the output.
.B #if
directives are interpreted only if their value is not dependent on macros
which are not to be interpreted.
.TP
.SM \-D
Define the
.I macro
to have the value
.I def,
or "1" if no
.I def
is given.
Unlike the C preprocessor,
.B scpp
does not implicitly define certain macros that describe the environment in
which the code will be running (e.g. "vax" or "unix").
.B \-D
implies
.B \-M.
.TP
.SM \-C
Preserve comments and whitespace in interpreted macro definitions.
Normally, comments and leading and trailing whitespace are stripped from
interpreted macro definitions.
.TP
.SM \-I
Add
.I incdir
to the list of directories to be searched for include files.
.B Scpp
searches directories in the same order as the C preprocessor:
if the include filename is enclosed in double-quotes ("...")
rather than angle-brackets (<...>),
the directory containing the current file being processed;
the directories given by -I, left-to-right;
the standard directory, /usr/include.
.RE
.SH AUTHOR
Brad Needham, Tektronix, Inc.
.SH "SEE ALSO"
cc(1).
.SH BUGS
Very long identifiers (those over 100 characters long) will crash
.B scpp.
.PP
Because
.B scpp
interprets only the given macros, the meaning of some code will change.
E.g. "scpp -MBOO" of
.br
	#define BOO hello,there
.br
	#define twopar(a,b) a b
.br
	twopar(BOO,folks)
.br
will generate
.br
	#define twopar(a,b) a b
.br
	twopar(hello,there,folks)
.br
causing an argument mismatch when the output is compiled.
.PP
Because uninterpreted "#if"s, "ifdef"s, and "ifndef"s, have no effect
on the output, the following example, when processed via "scpp -MLEFT",
will generate an error message complaining about
multiple definitions of "LEFT".
.br
	#ifdef ZULU
.br
	#define LEFT 20
.br
	#else
.br
	#define LEFT 347
.br
	#endif
.PP
The C preprocessor macros "\fB__FILE__\fP" and "\fB__LINE__\fP" have no
special meaning to
.B scpp.

----
Rich $alz	{mit-eddie, ihnp4, wjh12, cca, cbosgd, seismo}!mirror!rs
Mirror Systems	2067 Massachusetts Avenue  Cambridge, MA  02140
Telephone:	617-661-0777
"Hi, mom!"
