


RS(1)               UNIX Programmer's Manual                RS(1)



NAME
     rs - reminder system

SYNOPSIS
     rs [ -Aacknpv ] [ -s string ] [ -d # #-# ]

DESCRIPTION
     rs  is  a  personal  reminder  system.   Reminders  can   be
     displayed  every time you log into the system by placing the
     rs command in your .login or .profile  file.   The  reminder
     system includes three reminder files:


          1.   Reminders  ($HOME/.reminders)
          2.   Notes      ($HOME/.rsnotes)
          3.   User defined by setting the RSALT environment variable.
               (Defaults to $HOME/.phone_numbers)

     Options:

     rs   With no options, print reminder list to terminal.

     -A   Work with alternate reminder file.   The  name  of  the
          alternate  file  is  user  defined by setting the RSALT
          environment variable.  (If RSALT is not set, the alter-
          nate file defaults to 'phone_numbers'.)

     -a   Add reminders/notes/alternates.  You  are  prompted  to
          add   reminders/notes/alternates.    Appending   a   ^G
          (Control-G) at the end of a reminder will cause  rs  to
          mark   it  (Highlight)  during  display.   (See  RSINIT
          below.)

     -c   Add entries to calendar system.  You  are  prompted  to
          add calendar entries.  See calendar(1).

     -d   Delete reminders/notes/alternates.  This  option,  fol-
          lowed  by  a number or numbers, causes rs to delete the
          specified reminders/notes/alternates.   More  than  one
          number may be placed on the same command line separated
          by blanks.  A range of numbers may also be specified.

     -e   Edit reminders/notes/alternates file.   If  the  EDITOR
          environment  variable  is  set, the specified EDITOR is
          used.  If not, vi is used by default. (-v may  be  used
          in place of -e)

     -k   Kill (delete) all reminders/notes/alternates.

     -n   Work on notes file.

     -p   Print reminders/notes/alternates.  (By default, does an



Printed 7/3/86            3 July 1986                        1






RS(1)               UNIX Programmer's Manual                RS(1)



          lpr of reminder file.)

     -s   Search for reminders/notes/alternates  that  match  the
          given string.

     More than one option may follow a single "-", for example:

          rs -na    The command for "add note."

NOTES
     To mark a reminder (Highlight), append a ^G  (Control-G)  to
     the  reminder.   rs  will  mark  the reminder during display
     using one of the following:


          Standout
          Underscore.
          Bold
          Asterisk

     as defined in RSINIT.

     rs looks in the environment variable RSINIT  for  additional
     configuration options.  Options are:


     A    Display notes/alternates/calendar after additions.
     D    Display notes/alternates/calendar after deletions.
     a    Display reminders after additions.
     d    Display reminders after deletions.
     I    Ignore TERMCAP info during startup.
          (Default number of columns is 80, no mark capability)

     Default mark is standout mode.
          ('so' and 'se' must be defined in termcap entry.)

     U    Use underscore (underline) to mark reminders.
          ('us' and 'ue' must be defined in termcap entry.)
     B    Use Bold to mark reminders.
          ('bo' and 'be' must be defined in termcap entry.)
     S    Use '*' to mark reminders.
          (Terminal must have 'bs'.)

     For    example,    if    you    prefer    to    view    your
     reminders/notes/alternates  after  additions/deletions,  the
     csh command:


               setenv RSINIT 'aAdD'

     causes rs to display your  reminders/notes/alternates  after
     additions/deletions.   The  above  command  sequence  may be



Printed 7/3/86           3 July 1986                        2






RS(1)               UNIX Programmer's Manual                RS(1)



     placed in your .login file.

     Reminders/notes/alternates may be from one to 255 characters
     long.   If a reminder is longer than one line (As defined in
     termcap 'co'), rs  does  automatic  word  wrap.   To  add  a
     reminder/note/alternate  longer  than  one line, type in the
     entire reminder/note/alternate and end with  a  single  car-
     riage return.  Do not insert carriage returns before the end
     of a  reminder/note/alternate.   A  single  carriage  return
     always indicates the end of a reminder.

EXAMPLES
     rs -d 1 5 8
          Delete reminders 1, 5, 8.

     rs -n -d 1-5 8
          Delete notes 1, 2, 3, 4, 5, 8.

     rs -k
          Kill all reminders.

EXAMPLE USE OF ALTERNATE REMINDER FILE
     If you would like to have a list of phone numbers  that  can
     be  accessed  by the reminder system, you can do the follow-
     ing:

     Set the  RSALT  environment  variable  to  phone-numbers  by
     including the following command line in your .login file:

          setenv RSALT 'phone-numbers'

     Use the reminder system command:

          rs -A [options]

     to work on the phone-numbers reminder file.

EXAMPLE COMMANDS FOR PHONE-NUMBERS REMINDER FILE
     rs -A -a
          Add phone numbers to the phone-numbers reminder file.

     rs -A -s Joslyn
          Search for Joslyn's phone number.

     rs -A -e
          Edit phone-numbers.

     rs -A -p
          Print phone-numbers on the line printer.

     rs -A -d 1
          Delete the first line from phone-numbers.



Printed 7/3/86           3 July 1986                        3






RS(1)               UNIX Programmer's Manual                RS(1)



TIPS
     To make use  of  the  notes/alternates  easier,  the  author
     defines two aliases:

     alias rsn 'rs -n'     Use rsn to work with notes file.
     alias rsa 'rs -A'     Use rsa to work with alternate file.

FILES
     $HOME/.reminders    User's reminders.
     $HOME/.rsnotes      User's notes.
     /tmp/.rs*           Used during reminder deletion.
     $HOME/.?            Other reminder file(s) defined by RSALT.

SEE ALSO
     calendar(1), csh(1), environ(7), lpr(1), vi(1)

AUTHOR
     Don Joslyn, Manager
     Nova University Computer Center
     3301 College Avenue
     Fort Lauderdale, Florida 33314
     (305) 475-7678
     {codas, allegra, ucf-cs}!novavax!don

Printed 7/3/86            3 July 1986                        4
