.TH SDI 1 "Feb. 5, 1987"
.AT 3
.SH NAME
sdi \- a game of shooting missiles coming and going
.SH SYNOPSIS
.B sdi
[[options] ]...
.SH DESCRIPTION
.I sdi
is based on the classic 
.IR "missile command" ,
of arcade, Macintosh, and Alto fame.  Your mouse buttons control defenses
against the missiles flying by in two windows, and a third window is your
control panel.
Missiles are launched up in one window,
and, if you don't kill them there, they (after a few seconds of off-screen
ballistic mode), start down on your cities in a second window.
.PP
Your left button aims a high-speed interceptor missile, which
explodes leaving a large growing cloud of debris which destroys anything
attempting to pass through.  
Shifted interceptors have a larger cloud (but watch out near your
own cities.)
.PP
Your right button activates a pop-up x-ray laser, which detonates a small
atom bomb for energy, and then directs a beam at the six most-recently-launched missiles within range.
Shifted lasers have twice the range, but for no more 
than three missiles.
Lasered missiles die with a fizzle.  If a missile disappears off the top
of the screen before being sufficiently lasered, it lives on.
.PP
Your middle button activates a rock-dropping satellite.  Rocks are
dropped on a line between button-down and button-up, and start to drop
to the ground before they burn up in the atmosphere.
Shifted rocks are fewer, but last longer before burn up.
.PP
Missiles killed by blasts and rocks are worth 5 points, but
those killed by lasers are worth 50 points.  All missiles killed
on the city playing field (as opposed to the launch playing field)
are worth only one fifth as much.  A bonus city is awarded after
5000 points, then 10000, then 20000, and so on by powers of two.
If there is no place to build a bonus city, then the bonus is saved
until needed.  Each city left at the end of a turn is worth ten times
the current game level in points.
.PP
The windows will flash and beep when you try to shoot with an empty button.
A triple-beep sounds as an air raid warning whenever a
missile enters ballistic mode between the screens, and there were
previously no missiles there.
.PP
The control window should
be used for all window opening and closing--the others will follow.
Playing fields can be resized for some interesting variations, and the
number of cities will be adjusted.  However, this will always start
a new game.  There are three skill levels, everything is worth more
points at higher skills.  Skill level can only be changed between games.
.PP
Games can be saved and restored using the appropriate control panel
buttons, but only between rounds.  Window position and size are
among the parameters remembered in a saved game.
.PP
Shifted mouse buttons increase the 'size'
of the defense, but trade-off something else.  Meta moused buttons cause
your action to be done twice, spread to either side of the mouse position.
Your defenses are used up twice as fast as well.
.PP
In the control window,
the three top 'sliders' show the 'ammo' associated with your three
mouse buttons, the two bottom 'sliders' show the missiles-in-flight and
missiles-on-the-ground, respectively.
The 'Things To Read' button pops up an assortment of reading options,
including the manual entry.  The different 'options' buttons also pop
up subwindows.
.PP
The game is automatically suspended when in a subwindow.  If you want
to retain the subwindow while playing, move the subwindow
out of the way and explicitly 'resume' the game.
Only one subwindow at a time, though.
.PP
For the real junky, the 'non-stop' button restarts each
round without waiting for confirmation.  The big 'game over' message
at the end of the game is also bypassed.
.PP
For variety there are various options,
each followed by one or more parameters.  Spaces separate options and parameters.
.TP
.B -c
sets the cities to an arbitrary icon.  (A "ziggy" icon is popular here.)
.TP
.B -d
sets the delay between screen updates (in microseconds, default 150000),
.TP
.B -f
looks for a score file here.  If this option is not present, then
the environment is checked for an SDI_SCORES variable, and if it
is not present then a check is made for a /usr/game/lib/sdi_scores file,
and if that is not present then an attempt is made to open a file
called /tmp/sdi_scores (or other location specified by -DSCOREFILE when
.I sdi
was compiled.)  
.I Sdi
will never create a score file.   An easy way to start score-keeping is to
issue the shell command 'touch /tmp/sdi_scores', then play.
.TP
.B -g
Adds the 'gamemaster' item to the control panel, which when selected makes
all control panel items editable, and brings up a couple of more panels
to control (scroll down to see them).  Using this mode disables score file recording.
.TP
.B -h
set the height of the playing fields.
.TP
.B -i
must be followed by two numbers, the icon type and the icon-update-time in tenths of seconds.  Icon update time defaults to 5 (half a second).  Icon types are 0 for normal sit-there-and-do-nothing icon, 1 (the default) for an
icon with subtle amusing flavor, and 2 for wild bubbling icon.
.TP
.B -l
set the starting level, from 0 to 49.
.TP
.B -p
Select a type of pointer (i.e. cursor).
The following parameter is 0 for normal cursor, 1 for dynamic cursor, and 2 for cross hairs.
.TP
.B -r
the following parameter is the name of a file from which to restore a saved game.
.TP
.B -s
set the starting skill: 0 for novice, 1 for intermediate, 2 for expert.
.TP
.B -t
set the maximum time for a game, in seconds.  Using this option causes
a new slider to appear which ticks down the remaining seconds.  It also
automatically uses 'Non-stop' mode between rounds but not at the end of game.
When time runs out, the 'melt' button is implicitly pushed.
.TP
.B -w
set the height of the playing fields.
.PP
The following options, all starting with -b, specify different pixrects to be used in different
kind of blasts:
.TP
.B -bb
blast of an interceptor.
.TP
.B -bm
blast of a missile blowing up via interceptor.
.TP
.B -bk
blast of a missile blowing up via a laser.
.TP
.B -bl
blast of a laser's bomb source.
.TP
.B -bc
blast of a missile hitting a city.
.SH Bugs
When compiled against Sun 3.0 operating system libraries, the wrong window
sizes are used if the game starts iconic ('-Wi' option).  Works ok with
the 3.2 libraries, or if started non-iconic and then later closed.
.PP
The low-res 'game-over' picture keeps the shar-file size down for shipping,
but doesn't look great.
.PP
Too many silly control panel buttons, like 'melt'.
.PP
Far, far too many options.
.SH Author
Mark Weiser
